/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.customize;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.menu.customize.MenuCustomizeScreen;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetShortcutPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MenuCustomizeShortcutsScreen
extends MenuBackground {
    MenuBox box;
    MenuButton back;
    MenuButton[] shortcuts = new MenuButton[9];
    MenuButton unequip;
    MenuScrollBar scrollBar;
    List<MenuButton> magics = new ArrayList<MenuButton>();
    int buttonsX = 0;
    private int selectedShortcut = 0;
    LinkedHashSet<ResourceLocation> allMagic = new LinkedHashSet();

    public MenuCustomizeShortcutsScreen(LinkedHashMap<String, int[]> knownMagic) {
        super("gui.menu.customize.shortcuts", new Color(0, 0, 255));
        knownMagic.forEach((s, ints) -> {
            if (ModMagic.registry.containsKey(ResourceLocation.parse((String)s))) {
                this.allMagic.add(ResourceLocation.parse((String)s));
            }
        });
        this.drawPlayerInfo = false;
    }

    protected void action(String string) {
        switch (string) {
            case "back": {
                Minecraft.getInstance().setScreen((Screen)new MenuCustomizeScreen());
            }
        }
    }

    @Override
    public void init() {
        super.init();
        this.init(0.0f, 0);
    }

    public void init(float scrollOffset, int handleY) {
        this.drawSeparately = true;
        float boxPosX = (float)this.width * 0.25f;
        float boxWidth = (float)this.width * 0.67f;
        this.buttonPosY = (int)this.topBarHeight + 5;
        this.box = new MenuBox((int)boxPosX, (int)this.topBarHeight, (int)boxWidth, (int)this.middleHeight, 0.6f, new Color(4, 4, 68));
        this.buttonsX = this.box.getX() + 10;
        this.renderables.clear();
        this.children().clear();
        this.magics.clear();
        for (int i = 0; i < this.shortcuts.length; ++i) {
            int j = i;
            this.shortcuts[i] = new MenuButton((int)this.buttonPosX, this.buttonPosY + i * 18, (int)this.buttonWidth, Utils.translateToLocal("gui.menu.customize.shortcut", new Object[0]) + " " + (i + 1), MenuButton.ButtonType.BUTTON, e -> {
                this.selectedShortcut = j;
                this.init(this.scrollBar.scrollOffset, this.scrollBar.handleY);
            });
            this.addRenderableWidget((GuiEventListener)this.shortcuts[i]);
        }
        PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
        int totalMagics = 0;
        int magicLine = 0;
        this.unequip = new MenuButton((int)this.buttonPosX, this.buttonPosY - 18, (int)this.buttonWidth, Utils.translateToLocal("gui.menu.customize.unequip", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.select(null, 0));
        this.addRenderableWidget((GuiEventListener)this.unequip);
        for (ResourceLocation entry : this.allMagic) {
            Magic magic = (Magic)ModMagic.registry.get(entry);
            if (magic == null) continue;
            int level = playerData.getMagicLevel(entry);
            while (level >= 0) {
                int lvl = level;
                MenuButton button = new MenuButton((int)((float)((int)((float)this.width * 0.32f)) + (float)level * (this.buttonWidth + 5.0f)), this.buttonPosY + magicLine * 18, (int)((double)this.buttonWidth * 0.8), Utils.translateToLocal(magic.getTranslationKey(level), new Object[0]), MenuButton.ButtonType.SUBBUTTON, e -> this.select(magic, lvl));
                this.magics.add(button);
                this.addRenderableWidget((GuiEventListener)button);
                this.magics.get(totalMagics).setData(magic.getRegistryName().toString() + "," + level);
                --level;
                ++totalMagics;
            }
            ++magicLine;
        }
        int contentHeight = !this.magics.isEmpty() ? this.magics.get(this.magics.size() - 1).getY() - this.magics.get(0).getY() + 28 : 0;
        this.scrollBar = new MenuScrollBar((int)(boxPosX + boxWidth) - 14 - 4, (int)this.topBarHeight + 2, (int)(this.topBarHeight + this.middleHeight) - 2, (int)this.middleHeight, contentHeight);
        this.addRenderableWidget((GuiEventListener)this.scrollBar);
        this.scrollBar.scrollOffset = scrollOffset;
        this.scrollBar.setHandleY(handleY);
        for (MenuButton menuButton : this.magics) {
            if (menuButton == null) continue;
            menuButton.active = !this.isMagicAlreadyEquipped(menuButton.getData());
            menuButton.offsetY = (int)this.scrollBar.scrollOffset;
        }
        this.back = new MenuButton((int)this.buttonPosX, this.buttonPosY + 162, (int)this.buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.addRenderableWidget((GuiEventListener)this.back);
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.box.render(gui, mouseX, mouseY, partialTicks);
        this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
        gui.enableScissor(this.box.getX(), this.box.getY(), this.box.getX() + this.box.getWidth(), this.box.getY() + this.box.getHeight());
        this.magics.forEach(menuButton -> menuButton.render(gui, mouseX, mouseY, partialTicks));
        gui.disableScissor();
        for (i = 0; i < this.shortcuts.length; ++i) {
            this.shortcuts[i].render(gui, mouseX, mouseY, partialTicks);
            this.shortcuts[i].active = i != this.selectedShortcut;
        }
        this.back.render(gui, mouseX, mouseY, partialTicks);
        this.unequip.render(gui, mouseX, mouseY, partialTicks);
        this.scrollBar.render(gui, mouseX, mouseY, partialTicks);
        for (i = 0; i < this.magics.size(); ++i) {
            if (this.magics.get(i) == null) continue;
            this.magics.get((int)i).active = !this.isMagicAlreadyEquipped(this.magics.get(i).getData());
            this.magics.get((int)i).offsetY = (int)this.scrollBar.scrollOffset;
        }
    }

    private boolean isMagicAlreadyEquipped(String string) {
        PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
        for (Map.Entry<Integer, String> entry : playerData.getShortcutsMap().entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void select(Magic magic, int level) {
        if (magic == null) {
            PacketHandler.sendToServer(new CSSetShortcutPacket(this.selectedShortcut, level, ""));
        } else {
            PacketHandler.sendToServer(new CSSetShortcutPacket(this.selectedShortcut, level, magic.getRegistryName().toString()));
        }
        if (this.selectedShortcut < 8) {
            ++this.selectedShortcut;
            this.init(this.scrollBar.scrollOffset, this.scrollBar.handleY);
        }
    }

    public void updateScroll() {
        for (int i = 0; i < this.magics.size(); ++i) {
            if (this.magics.get(i) == null) continue;
            this.magics.get((int)i).offsetY = (int)this.scrollBar.scrollOffset;
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.mouseClicked(pMouseX, pMouseY, pButton);
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.mouseReleased(pMouseX, pMouseY, pButton);
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.scrollBar.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        this.updateScroll();
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double deltaX, double deltaY) {
        this.scrollBar.mouseScrolled(pMouseX, pMouseY, deltaX, deltaY);
        this.updateScroll();
        return super.mouseScrolled(pMouseX, pMouseY, deltaX, deltaY);
    }
}

