/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.items;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterable;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuStockItem;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.MenuItemsScreen;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MenuStockScreen
extends MenuFilterable {
    MenuBox box;
    MenuButton back;

    public MenuStockScreen() {
        super("gui.menu.items.stock", new Color(0, 0, 255));
        this.drawSeparately = true;
        this.minecraft = Minecraft.getInstance();
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
        this.box.renderWidget(gui, mouseX, mouseY, partialTicks);
        if (!this.inventory.isEmpty()) {
            int listHeight = ((MenuStockItem)((Object)this.inventory.get(this.inventory.size() - 1))).getY() + 20 - ((MenuStockItem)((Object)this.inventory.get(0))).getY() + 3;
            this.scrollBar.setContentHeight(listHeight);
        }
        for (Renderable renderable : this.inventory) {
            if (renderable instanceof MenuStockItem) {
                MenuStockItem menuStockItem = (MenuStockItem)renderable;
                menuStockItem.active = true;
                gui.enableScissor(this.box.getX() + 2, this.scrollBar.getY() + 2, this.box.getX() + this.box.getWidth(), this.scrollBar.getBottom() - 5);
                renderable.render(gui, mouseX, mouseY, partialTicks);
                gui.disableScissor();
                continue;
            }
            renderable.render(gui, mouseX, mouseY, partialTicks);
        }
        this.back.render(gui, mouseX, mouseY, partialTicks);
        super.render(gui, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderSelectedData(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = gui.pose();
        float iconPosX = (float)this.width * 0.335f;
        float iconPosY = (float)this.height * 0.8283f;
        float iconWidth = (float)this.width * 0.1015f;
        float iconHeight = (float)this.height * 0.1537f;
        matrixStack.pushPose();
        matrixStack.translate(iconPosX, iconPosY, 0.0f);
        matrixStack.scale(0.0625f * iconHeight, 0.0625f * iconHeight, 1.0f);
        ClientUtils.drawItemAsIcon(this.selectedItemStack, matrixStack, 1, -1, 16);
        matrixStack.popPose();
        gui.drawString(this.minecraft.font, this.selectedItemStack.getHoverName().getString(), (int)tooltipPosX + 45, (int)tooltipPosY + 0, 0xFFFFFF);
        if (this.selectedItemStack.getItem() instanceof KeybladeItem || this.selectedItemStack.getItem() instanceof KeychainItem) {
            KeybladeItem kb;
            KeybladeItem keybladeItem = kb = this.selectedItemStack.getItem() instanceof KeychainItem ? ((KeychainItem)this.selectedItemStack.getItem()).getKeyblade() : (KeybladeItem)this.selectedItemStack.getItem();
            if (kb != null && kb.data != null) {
                ClientUtils.drawSplitString(gui, kb.getDesc(), (int)tooltipPosX + 55, (int)tooltipPosY + 10, (int)((float)this.width * 0.38f), 0xAAAAAA);
                gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.status.strength", new Object[0]) + ": " + kb.getStrength(0), (int)((float)this.width * 0.85f), (int)tooltipPosY, 0xFF0000);
                gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.status.magic", new Object[0]) + ": " + kb.getMagic(0), (int)((float)this.width * 0.85f), (int)tooltipPosY + 10, 0x4444FF);
            } else {
                this.drawTooltipText(gui, this.selectedItemStack);
            }
        } else {
            this.drawTooltipText(gui, this.selectedItemStack);
        }
    }

    public void drawTooltipText(GuiGraphics gui, ItemStack selectedItemstack) {
        List tooltip = selectedItemstack.getTooltipLines(Item.TooltipContext.of((Level)this.minecraft.level), (Player)this.minecraft.player, (TooltipFlag)TooltipFlag.Default.NORMAL);
        for (int i = 1; i < Math.min(tooltip.size(), 3); ++i) {
            Font font = this.minecraft.font;
            String string = ((Component)tooltip.get(i)).getString();
            int n = (int)tooltipPosX + 60;
            int n2 = (int)tooltipPosY;
            Objects.requireNonNull(this.minecraft.font);
            gui.drawString(font, string, n, n2 + 9 * i + 5, 0xFFFFFF);
        }
        if (tooltip.size() > 3) {
            Font font = this.minecraft.font;
            int n = (int)tooltipPosX + 60;
            int n3 = (int)tooltipPosY;
            Objects.requireNonNull(this.minecraft.font);
            gui.drawString(font, "...", n, n3 + 9 * 3 + 5, 0xFFFFFF);
        }
    }

    @Override
    public void init() {
        float boxPosX = (float)this.width * 0.1537f;
        float topBarHeight = (float)this.height * 0.17f;
        float boxWidth = (float)this.width * 0.7135f;
        float middleHeight = (float)this.height * 0.6f;
        this.box = new MenuBox((int)boxPosX, (int)topBarHeight, (int)boxWidth, (int)middleHeight, 1.0f, new Color(40, 4, 255));
        float filterPosX = (float)this.width * 0.3f;
        float filterPosY = (float)this.height * 0.023f;
        this.buttonPosX = (float)this.width * 0.03f;
        this.buttonPosY = (int)(topBarHeight + 5.0f);
        this.filterBar = new MenuFilterBar((int)filterPosX, (int)filterPosY, this);
        this.filterBar.init();
        this.scrollBar = new MenuScrollBar(this.box.getX() + this.box.getWidth() - 17, this.box.getY(), this.box.getY() + this.box.getHeight(), this.box.getHeight(), 0);
        this.addRenderableWidget((GuiEventListener)this.scrollBar);
        this.initItems();
        super.init();
    }

    @Override
    public void initItems() {
        this.buttonWidth = (float)this.width * 0.07f;
        LocalPlayer player = this.minecraft.player;
        float invPosX = (float)this.width * 0.1594f;
        float invPosY = (float)this.height * 0.1851f;
        this.inventory.clear();
        this.renderables.clear();
        this.children().clear();
        this.filterBar.buttons.forEach(x$0 -> {
            Button cfr_ignored_0 = (Button)this.addWidget((GuiEventListener)x$0);
        });
        this.back = new MenuButton((int)this.buttonPosX, this.buttonPosY, (int)this.buttonWidth, Component.translatable((String)"gui.menu.back").getString(), MenuButton.ButtonType.BUTTON, b -> this.minecraft.setScreen((Screen)new MenuItemsScreen()));
        this.addRenderableWidget((GuiEventListener)this.back);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!this.filterItem(player.getInventory().getItem(i))) continue;
            items.add(player.getInventory().getItem(i));
        }
        items.sort(Comparator.comparing(Utils::getCategoryForStack).thenComparing(stack -> stack.getHoverName().getContents().toString()));
        int itemWidth = this.box.getWidth() / 2 - 10;
        for (int i = 0; i < items.size(); i += 2) {
            MenuStockItem item = new MenuStockItem(this, (ItemStack)items.get(i), (int)invPosX, (int)invPosY + i * 7, itemWidth, true);
            this.inventory.add(item);
            if (i + 1 >= items.size()) continue;
            MenuStockItem item2 = new MenuStockItem(this, (ItemStack)items.get(i + 1), (int)invPosX + ((MenuStockItem)((Object)this.inventory.get(i))).getWidth(), (int)invPosY + i * 7, itemWidth, true);
            this.inventory.add(item2);
        }
        this.inventory.forEach(x$0 -> {
            MenuStockItem cfr_ignored_0 = (MenuStockItem)this.addWidget((GuiEventListener)x$0);
        });
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.scrollBar.mouseClicked(mouseX, mouseY, mouseButton);
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.mouseReleased(pMouseX, pMouseY, pButton);
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.scrollBar.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        this.updateScroll();
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void updateScroll() {
        this.inventory.forEach(button -> {
            button.offsetY = (int)this.scrollBar.scrollOffset;
        });
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (mouseX >= (double)this.box.getX() && mouseX <= (double)(this.scrollBar.getX() + this.scrollBar.getWidth())) {
            this.scrollBar.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }
        this.updateScroll();
        return false;
    }
}

