/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment;

import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuEquipmentButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.MenuItemsScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuAccessorySelectorScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuArmorSelectorScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuEquipmentSelectorScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuKeybladeArmorSelectorScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuPotionSelectorScreen;
import online.kingdomkeys.kingdomkeys.client.gui.menu.items.equipment.MenuShotlockSelectorScreen;
import online.kingdomkeys.kingdomkeys.client.gui.organization.WeaponTreeSelectionScreen;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MenuEquipmentScreen
extends MenuBackground {
    MenuBox listBox;
    MenuBox detailsBox;
    Button back;
    Button showKeybladesButton;
    MenuScrollBar scrollBar;
    boolean showingKeyblades = false;

    public MenuEquipmentScreen() {
        super("gui.menu.items.equipment", new Color(0, 0, 255));
        this.drawSeparately = true;
    }

    public MenuEquipmentScreen(boolean showingKeyblades) {
        super("gui.menu.items.equipment", new Color(0, 0, 255));
        this.drawSeparately = true;
        this.showingKeyblades = showingKeyblades;
    }

    @Override
    public void init() {
        ItemStack item;
        int slot;
        MenuEquipmentButton sbSlot;
        super.init();
        this.renderables.clear();
        this.children().clear();
        this.buttonWidth = (float)this.width * 0.07f;
        float listBoxX = (float)this.width * 0.16f;
        float boxY = (float)this.height * 0.174f;
        float topBarHeight = (float)this.height * 0.17f;
        float listBoxWidth = (float)this.width * 0.452f;
        float boxHeight = (float)this.height * 0.5972f;
        float detailsWidth = (float)this.width * 0.2588f;
        float detailsX = listBoxX + listBoxWidth;
        this.listBox = new MenuBox((int)listBoxX, (int)boxY, (int)listBoxWidth, (int)boxHeight, 0.6f, new Color(76, 76, 76));
        this.detailsBox = new MenuBox((int)detailsX, (int)boxY, (int)detailsWidth, (int)boxHeight, 0.6f, new Color(76, 76, 76));
        int itemHeight = 14;
        float itemsX = (float)this.width * 0.31f;
        float itemsY = (float)this.height * 0.1907f;
        this.buttonPosY = (int)(topBarHeight + 5.0f);
        this.buttonPosX = 15.4f;
        PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
        this.back = new MenuButton((int)this.buttonPosX, playerData.getAlignment() == Utils.OrgMember.NONE ? this.buttonPosY : this.buttonPosY + 20, (int)this.buttonWidth, Component.translatable((String)"gui.menu.back").getString(), MenuButton.ButtonType.BUTTON, b -> this.minecraft.setScreen((Screen)new MenuItemsScreen()));
        this.addRenderableWidget((GuiEventListener)this.back);
        Map<ResourceLocation, ItemStack> keychains = playerData.getEquippedKeychains();
        List<String> shotlocks = Utils.getSortedShotlocks(playerData.getShotlockList());
        Map<Integer, ItemStack> items = playerData.getEquippedItems();
        Map<Integer, ItemStack> accessories = playerData.getEquippedAccessories();
        Map<Integer, ItemStack> kbArmor = playerData.getEquippedKBArmors();
        Map<Integer, ItemStack> armor = playerData.getEquippedArmors();
        AtomicInteger offset = new AtomicInteger();
        AtomicInteger hidden = new AtomicInteger(0);
        int lastButtonY = 0;
        if (playerData.getAlignment() != Utils.OrgMember.NONE) {
            MenuEquipmentButton orgWeaponSlot = new MenuEquipmentButton(playerData.getEquippedWeapon(), (int)itemsX, (int)itemsY + offset.get() + itemHeight * offset.getAndIncrement(), 0x555555, (Screen)new WeaponTreeSelectionScreen(playerData.getAlignment()), ItemCategory.TOOL, this, "gui.menu.items.equipment.weapon", 0xAAAAAA);
            this.addRenderableWidget((GuiEventListener)orgWeaponSlot);
            this.showKeybladesButton = new MenuButton((int)this.buttonPosX, this.buttonPosY, 45, Component.translatable((String)"gui.menu.items.equipment.weapon.keyblades").getString(), MenuButton.ButtonType.BUTTON, b -> {
                this.showingKeyblades = !this.showingKeyblades;
                this.init();
            });
            this.addRenderableWidget((GuiEventListener)this.showKeybladesButton);
            if (keychains.get(DriveForm.SYNCH_BLADE) != null && playerData.isAbilityEquipped("kingdomkeys:ability_synch_blade") && playerData.getEquippedWeapon() != null) {
                if (playerData.getEquippedWeapon().getItem() instanceof KeybladeItem) {
                    sbSlot = new MenuEquipmentButton(keychains.get(DriveForm.SYNCH_BLADE), (int)itemsX, (int)itemsY + (offset.get() - hidden.get()) + itemHeight * (offset.getAndIncrement() - hidden.get()), 0x880000, (Screen)new MenuEquipmentSelectorScreen(DriveForm.SYNCH_BLADE, new Color(112, 31, 35), 0x880000), ItemCategory.TOOL, this, "ability.ability_synch_blade.name", 16679301);
                    this.addRenderableWidget((GuiEventListener)sbSlot);
                } else {
                    sbSlot = new MenuEquipmentButton(keychains.get(DriveForm.SYNCH_BLADE), (int)itemsX, (int)itemsY + offset.get() + itemHeight * offset.getAndIncrement(), 0x880000, (Screen)new MenuEquipmentSelectorScreen(DriveForm.SYNCH_BLADE, new Color(112, 31, 35), 0x880000), ItemCategory.TOOL, this, "ability.ability_synch_blade.name", 16679301);
                    this.addRenderableWidget((GuiEventListener)sbSlot);
                    sbSlot.active = this.showingKeyblades;
                    sbSlot.visible = this.showingKeyblades;
                    hidden.getAndIncrement();
                }
            }
        } else {
            this.showingKeyblades = true;
        }
        if (keychains.get(DriveForm.NONE) != null) {
            MenuEquipmentButton firstSlot = new MenuEquipmentButton(keychains.get(DriveForm.NONE), (int)itemsX, (int)itemsY + offset.get() + itemHeight * offset.getAndIncrement(), 0x880000, (Screen)new MenuEquipmentSelectorScreen(DriveForm.NONE, new Color(112, 31, 35), 0x880000), ItemCategory.TOOL, this, "gui.menu.items.equipment.weapon", 16679301);
            this.addRenderableWidget((GuiEventListener)firstSlot);
            firstSlot.active = this.showingKeyblades;
            firstSlot.visible = this.showingKeyblades;
            hidden.getAndIncrement();
            if (playerData.getAlignment() == Utils.OrgMember.NONE && playerData.getEquippedAbilityLevel("kingdomkeys:ability_synch_blade")[1] > 0) {
                sbSlot = new MenuEquipmentButton(keychains.get(DriveForm.SYNCH_BLADE), (int)itemsX, (int)itemsY + offset.get() + itemHeight * offset.getAndIncrement(), 0x880000, (Screen)new MenuEquipmentSelectorScreen(DriveForm.SYNCH_BLADE, new Color(112, 31, 35), 0x880000), ItemCategory.TOOL, this, "ability.ability_synch_blade.name", 16679301);
                this.addRenderableWidget((GuiEventListener)sbSlot);
                sbSlot.active = this.showingKeyblades;
                sbSlot.visible = this.showingKeyblades;
                hidden.getAndIncrement();
            }
        }
        Comparator<Map.Entry> sortByFormOrder = Comparator.comparingInt(f -> ((DriveForm)ModDriveForms.registry.get((ResourceLocation)f.getKey())).getOrder());
        keychains.entrySet().stream().sorted(sortByFormOrder).forEachOrdered(entry -> {
            ResourceLocation form = (ResourceLocation)entry.getKey();
            ItemStack keychain = (ItemStack)entry.getValue();
            if (!form.equals((Object)DriveForm.NONE) && !form.equals((Object)DriveForm.SYNCH_BLADE) && ((DriveForm)ModDriveForms.registry.get(form)).isSlotVisible((Player)this.minecraft.player)) {
                MenuEquipmentButton button = new MenuEquipmentButton(keychain, (int)itemsX, (int)itemsY + offset.get() + itemHeight * offset.getAndIncrement(), 26214, (Screen)new MenuEquipmentSelectorScreen(form, new Color(10, 22, 22), 26214), ItemCategory.TOOL, this, ((DriveForm)ModDriveForms.registry.get(form)).getTranslationKey(), 48059);
                this.addRenderableWidget((GuiEventListener)button);
                hidden.getAndIncrement();
                button.active = this.showingKeyblades;
                button.visible = this.showingKeyblades;
            }
        });
        if (!this.showingKeyblades) {
            offset.set(offset.get() - hidden.get());
        }
        if (shotlocks != null) {
            MenuEquipmentButton shotlockSlot = new MenuEquipmentButton(playerData.getEquippedShotlock(), (int)itemsX, (int)itemsY + offset.get() + itemHeight * offset.getAndIncrement(), 0x11FF44, (Screen)new MenuShotlockSelectorScreen(new Color(17, 255, 100), 0x44FF99), ItemCategory.SHOTLOCK, this, "gui.menu.items.equipment.shotlock", 8519338);
            this.addRenderableWidget((GuiEventListener)shotlockSlot);
        }
        if (kbArmor != null) {
            kbArmor.entrySet().stream().forEachOrdered(entry -> {
                ItemStack item = (ItemStack)entry.getValue();
                MenuEquipmentButton kbArmorSlot = new MenuEquipmentButton(item, (int)itemsX, (int)itemsY + offset.get() + itemHeight * offset.getAndIncrement(), 16740864, (Screen)new MenuKeybladeArmorSelectorScreen(0, new Color(255, 127, 0), 16740864), ItemCategory.KBARMOR, this, Utils.translateToLocal("gui.menu.items.equipment.pauldron", new Object[0]), 16751165);
                this.addRenderableWidget((GuiEventListener)kbArmorSlot);
            });
        }
        if (accessories != null) {
            int c = 1;
            for (Map.Entry<Integer, ItemStack> entry2 : accessories.entrySet()) {
                if (c > playerData.getMaxAccessories()) break;
                slot = entry2.getKey();
                item = entry2.getValue();
                MenuEquipmentButton accessorySlot = slot == 0 ? new MenuEquipmentButton(item, (int)itemsX, (int)itemsY + offset.get() + itemHeight * offset.getAndIncrement(), 21930, (Screen)new MenuAccessorySelectorScreen(slot, new Color(31, 35, 112), 0x44AAFF), ItemCategory.ACCESSORIES, this, Utils.translateToLocal("gui.menu.items.equipment.accessories", new Object[0]), 4378367) : new MenuEquipmentButton(item, (int)itemsX, (int)itemsY + offset.get() + itemHeight * offset.getAndIncrement(), 21930, (Screen)new MenuAccessorySelectorScreen(slot, new Color(31, 35, 112), 0x44AAFF), ItemCategory.ACCESSORIES, this);
                this.addRenderableWidget((GuiEventListener)accessorySlot);
                ++c;
            }
        }
        if (armor != null) {
            int c = 1;
            for (Map.Entry<Integer, ItemStack> entry2 : armor.entrySet()) {
                if (c > playerData.getMaxArmors()) break;
                slot = entry2.getKey();
                item = entry2.getValue();
                MenuEquipmentButton armorSlot = slot == 0 ? new MenuEquipmentButton(item, (int)itemsX, (int)itemsY + offset.get() + itemHeight * offset.getAndIncrement(), 0xAAAA00, (Screen)new MenuArmorSelectorScreen(slot, new Color(255, 247, 0), 0x444400), ItemCategory.EQUIPMENT, this, Utils.translateToLocal("gui.menu.items.equipment.armor", new Object[0]), 0xFFFF00) : new MenuEquipmentButton(item, (int)itemsX, (int)itemsY + offset.get() + itemHeight * offset.getAndIncrement(), 0xAAAA00, (Screen)new MenuArmorSelectorScreen(slot, new Color(255, 247, 0), 0x444400), ItemCategory.EQUIPMENT, this);
                this.addRenderableWidget((GuiEventListener)armorSlot);
                ++c;
            }
        }
        if (items != null) {
            items.entrySet().stream().forEachOrdered(entry -> {
                int slot = (Integer)entry.getKey();
                ItemStack item = (ItemStack)entry.getValue();
                MenuEquipmentButton potionSlot = slot == 0 ? new MenuEquipmentButton(item, (int)itemsX, (int)itemsY + offset.get() + itemHeight * offset.getAndIncrement(), 30464, (Screen)new MenuPotionSelectorScreen(slot, new Color(31, 112, 35), 0x22FF22), ItemCategory.CONSUMABLE, this, Utils.translateToLocal("gui.menu.items.equipment.items", new Object[0]) + " [" + items.size() + "]", 8519301) : new MenuEquipmentButton(item, (int)itemsX, (int)itemsY + offset.get() + itemHeight * offset.getAndIncrement(), 30464, (Screen)new MenuPotionSelectorScreen(slot, new Color(31, 112, 35), 0x22FF22), ItemCategory.CONSUMABLE, this);
                this.addRenderableWidget((GuiEventListener)potionSlot);
            });
        }
        for (Renderable renderable : this.renderables) {
            if (!(renderable instanceof MenuEquipmentButton)) continue;
            MenuEquipmentButton button = (MenuEquipmentButton)renderable;
            lastButtonY = Math.max(button.getY(), lastButtonY);
        }
        this.scrollBar = new MenuScrollBar((int)(listBoxX + listBoxWidth - 14.0f - 2.0f), (int)topBarHeight + 4, (int)(this.middleHeight + topBarHeight) - 4, (int)this.middleHeight, (int)((float)(lastButtonY + 28) - itemsY));
        this.addRenderableWidget((GuiEventListener)this.scrollBar);
    }

    public void updateScroll() {
        this.renderables.forEach(renderable -> {
            if (renderable instanceof MenuEquipmentButton) {
                MenuEquipmentButton button = (MenuEquipmentButton)((Object)renderable);
                button.offsetY = (int)this.scrollBar.scrollOffset;
            }
        });
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
        this.listBox.renderWidget(gui, mouseX, mouseY, partialTicks);
        this.detailsBox.renderWidget(gui, mouseX, mouseY, partialTicks);
        for (Renderable renderable : this.renderables) {
            if (renderable instanceof MenuEquipmentButton) {
                gui.enableScissor(this.listBox.getX() + 2, this.scrollBar.getY() + 1, this.listBox.getX() + this.listBox.getWidth() + this.detailsBox.getWidth(), this.scrollBar.getBottom() + 2);
                renderable.render(gui, mouseX, mouseY, partialTicks);
                gui.disableScissor();
                continue;
            }
            renderable.render(gui, mouseX, mouseY, partialTicks);
        }
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double deltaX, double deltaY) {
        if (this.scrollBar != null) {
            this.scrollBar.mouseScrolled(pMouseX, pMouseY, deltaX, deltaY);
            this.updateScroll();
        }
        return super.mouseScrolled(pMouseX, pMouseY, deltaX, deltaY);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.scrollBar != null) {
            this.scrollBar.mouseClicked(pMouseX, pMouseY, pButton);
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (this.scrollBar != null) {
            this.scrollBar.mouseReleased(pMouseX, pMouseY, pButton);
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrollBar != null) {
            this.scrollBar.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
            this.updateScroll();
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }
}

