/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.party;

import java.awt.Color;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Member;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_None;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSPartyAddMember;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class GuiMenu_Party_Join
extends MenuBackground {
    MenuButton back;
    PlayerData playerData;
    WorldData worldData;
    MenuButton[] parties;

    public GuiMenu_Party_Join() {
        super("gui.menu.party.join", new Color(0, 0, 255));
        this.playerData = PlayerData.get((Player)this.minecraft.player);
        this.parties = new MenuButton[100];
        this.drawPlayerInfo = true;
        this.worldData = WorldData.getClient();
    }

    protected void action(String string) {
        String[] data;
        String partyName;
        Party p;
        for (MenuButton party : this.parties) {
            if (party == null) continue;
            party.visible = false;
        }
        switch (string) {
            case "back": {
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.minecraft.setScreen((Screen)new GuiMenu_Party_None());
            }
        }
        if (string.startsWith("party:") && (p = this.worldData.getPartyFromName(partyName = (data = string.split(":"))[1].substring(data[1].indexOf("]") + 2))) != null && p.getMembers().size() < p.getSize()) {
            PacketHandler.sendToServer(new CSPartyAddMember(p, (Player)this.minecraft.player));
            p.addMember(this.minecraft.player.getUUID(), this.minecraft.player.getDisplayName().getString());
            this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
            this.minecraft.setScreen((Screen)new GuiMenu_Party_Member());
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.refreshParties();
    }

    private void refreshParties() {
        this.playerData = PlayerData.get((Player)this.minecraft.player);
        List<String> privateParties = this.playerData.getPartiesInvited();
        this.worldData = WorldData.getClient();
        float topBarHeight = (float)this.height * 0.17f;
        int button_statsY = (int)topBarHeight + 5;
        float buttonWidth = (float)this.width * 0.1744f - 20.0f;
        for (int i = 0; i < this.renderables.size(); ++i) {
            if (!((AbstractWidget)this.renderables.get(i)).getMessage().getString().startsWith("[") && !((AbstractWidget)this.renderables.get(i)).getMessage().getString().startsWith("(P) [")) continue;
            this.renderables.remove(i);
        }
        int c = 0;
        for (String privateParty : privateParties) {
            Party p = this.worldData.getPartyFromName(privateParty);
            if (p == null) continue;
            int n = c;
            MenuButton menuButton = new MenuButton((int)((float)this.width * 0.3f), button_statsY + c++ * 18, (int)(buttonWidth * 2.0f), "(P) [" + p.getMembers().size() + "/" + p.getSize() + "] " + p.getName(), MenuButton.ButtonType.BUTTON, e -> this.action("party:" + e.getMessage().getString()));
            this.parties[n] = menuButton;
            this.addRenderableWidget((GuiEventListener)menuButton);
        }
        List<Party> partiesList = this.worldData.getParties();
        for (Party p : partiesList) {
            if (p == null || p.getPriv() || privateParties.contains(p.getName())) continue;
            int n = c;
            MenuButton menuButton = new MenuButton((int)((float)this.width * 0.3f), button_statsY + c++ * 18, (int)(buttonWidth * 2.0f), "[" + p.getMembers().size() + "/" + p.getSize() + "] " + p.getName(), MenuButton.ButtonType.BUTTON, e -> this.action("party:" + e.getMessage().getString()));
            this.parties[n] = menuButton;
            this.addRenderableWidget((GuiEventListener)menuButton);
        }
    }

    @Override
    public void init() {
        this.width = this.width;
        this.height = this.height;
        super.init();
        this.renderables.clear();
        float topBarHeight = (float)this.height * 0.17f;
        int button_statsY = (int)topBarHeight + 5;
        float buttonPosX = (float)this.width * 0.03f;
        float buttonWidth = (float)this.width * 0.1744f - 20.0f;
        this.back = new MenuButton((int)buttonPosX, button_statsY, (int)buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.addRenderableWidget((GuiEventListener)this.back);
        this.updateButtons();
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.render(gui, mouseX, mouseY, partialTicks);
        this.worldData = WorldData.getClient();
        this.refreshParties();
    }
}

