/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.party;

import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Leader;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Member;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSOpenMenu;
import online.kingdomkeys.kingdomkeys.network.cts.CSPartyLeave;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class GuiMenu_Party_Kick
extends MenuBackground {
    MenuButton back;
    final PlayerData playerData;
    WorldData worldData;
    Party party;
    MenuButton[] players;

    public GuiMenu_Party_Kick() {
        super("gui.menu.party.kick", new Color(0, 0, 255));
        this.playerData = PlayerData.get((Player)this.minecraft.player);
        this.players = new MenuButton[((Integer)ModConfigs.SERVER.partyMembersLimit.get()).intValue()];
        this.drawPlayerInfo = true;
        this.worldData = WorldData.getClient();
    }

    protected void action(String string) {
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] == null) continue;
            this.players[i].visible = false;
        }
        switch (string) {
            case "back": {
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.minecraft.setScreen((Screen)new GuiMenu_Party_Leader());
                break;
            }
            case "refresh": {
                this.refreshMembers();
            }
        }
        if (string.startsWith("member:")) {
            String[] data = string.split(":");
            String name = data[1];
            Party.Member member = null;
            for (Party.Member m : this.party.getMembers()) {
                if (!m.getUsername().equals(name)) continue;
                member = m;
            }
            if (member != null) {
                PacketHandler.sendToServer(new CSPartyLeave(this.party, member.getUUID()));
                this.party.removeMember(member.getUUID());
            }
            this.refreshMembers();
            this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.refreshMembers();
    }

    private void refreshMembers() {
        int i;
        this.worldData = WorldData.getClient();
        float topBarHeight = (float)this.height * 0.17f;
        int button_statsY = (int)topBarHeight + 5;
        float buttonWidth = (float)this.width * 0.1744f - 20.0f;
        for (i = 1; i < this.renderables.size(); ++i) {
            if (((AbstractWidget)this.renderables.get(i)).getMessage().getString().startsWith("Refresh")) continue;
            this.renderables.remove(i);
        }
        this.party = this.worldData.getPartyFromMember(this.minecraft.player.getUUID());
        if (this.party == null) {
            PacketHandler.sendToServer(new CSOpenMenu());
        } else {
            if (!this.party.getMember(this.minecraft.player.getUUID()).isLeader()) {
                this.minecraft.setScreen((Screen)new GuiMenu_Party_Member());
                return;
            }
            for (i = 1; i < this.party.getMembers().size(); ++i) {
                this.players[i] = new MenuButton((int)((float)this.width * 0.3f), button_statsY + (i - 1) * 18, (int)(buttonWidth * 2.0f), this.party.getMembers().get(i).getUsername(), MenuButton.ButtonType.BUTTON, e -> this.action("member:" + e.getMessage().getString()));
                this.addRenderableWidget((GuiEventListener)this.players[i]);
            }
        }
    }

    @Override
    public void init() {
        this.width = this.width;
        this.height = this.height;
        super.init();
        this.renderables.clear();
        float topBarHeight = (float)this.height * 0.17f;
        int button_statsY = (int)topBarHeight + 5;
        float buttonPosX = (float)this.width * 0.03f;
        float buttonWidth = (float)this.width * 0.1744f - 20.0f;
        this.back = new MenuButton((int)buttonPosX, button_statsY, (int)buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.addRenderableWidget((GuiEventListener)this.back);
        this.updateButtons();
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.render(gui, mouseX, mouseY, partialTicks);
        this.worldData = WorldData.getClient();
        this.party = this.worldData.getPartyFromMember(this.minecraft.player.getUUID());
        this.refreshMembers();
    }
}

