/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.party;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Leader;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_None;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSOpenMenu;
import online.kingdomkeys.kingdomkeys.network.cts.CSPartyLeave;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class GuiMenu_Party_Member
extends MenuBackground {
    MenuButton back;
    MenuButton leave;
    final PlayerData playerData;
    WorldData worldData;
    Party party;
    final ResourceLocation texture;

    public GuiMenu_Party_Member() {
        super("gui.menu.party", new Color(0, 0, 255));
        this.playerData = PlayerData.get((Player)this.minecraft.player);
        this.texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");
        this.drawPlayerInfo = true;
        this.worldData = WorldData.getClient();
        this.party = this.worldData.getPartyFromMember(this.minecraft.player.getUUID());
    }

    protected void action(String string) {
        switch (string) {
            case "back": {
                PacketHandler.sendToServer(new CSOpenMenu());
                break;
            }
            case "leave": {
                PacketHandler.sendToServer(new CSPartyLeave(this.party, this.minecraft.player.getUUID()));
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.minecraft.setScreen((Screen)new GuiMenu_Party_None());
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.leave.visible = true;
    }

    @Override
    public void init() {
        this.width = this.width;
        this.height = this.height;
        super.init();
        this.renderables.clear();
        this.party = this.worldData.getPartyFromMember(this.minecraft.player.getUUID());
        if (this.party == null) {
            PacketHandler.sendToServer(new CSOpenMenu());
        } else if (this.party.getMember(this.minecraft.player.getUUID()).isLeader()) {
            this.minecraft.setScreen((Screen)new GuiMenu_Party_Leader());
            return;
        }
        float topBarHeight = (float)this.height * 0.17f;
        int button_statsY = (int)topBarHeight + 5;
        float buttonPosX = (float)this.width * 0.03f;
        float buttonWidth = (float)this.width * 0.1744f - 20.0f;
        this.leave = new MenuButton((int)buttonPosX, button_statsY, (int)buttonWidth, Utils.translateToLocal("gui.menu.party.leave", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("leave"));
        this.addRenderableWidget((GuiEventListener)this.leave);
        this.back = new MenuButton((int)buttonPosX, button_statsY + 18, (int)buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.addRenderableWidget((GuiEventListener)this.back);
        this.updateButtons();
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = gui.pose();
        super.render(gui, mouseX, mouseY, partialTicks);
        this.worldData = WorldData.getClient();
        this.party = this.worldData.getPartyFromMember(this.minecraft.player.getUUID());
        if (this.party == null) {
            PacketHandler.sendToServer(new CSOpenMenu());
        } else {
            if (this.party.getMember(this.minecraft.player.getUUID()).isLeader()) {
                this.minecraft.setScreen((Screen)new GuiMenu_Party_Leader());
                return;
            }
            matrixStack.pushPose();
            matrixStack.scale(1.5f, 1.5f, 1.0f);
            gui.drawString(this.minecraft.font, "[" + this.party.getMembers().size() + "/" + this.party.getSize() + "] " + this.party.getName(), (int)(this.topLeftBarWidth + this.topGap) + 5, 10, 0xFF9900);
            matrixStack.popPose();
            this.drawParty(gui);
        }
    }

    public void drawParty(GuiGraphics gui) {
        gui.pose().pushPose();
        for (int i = 0; i < this.party.getMembers().size(); ++i) {
            Party.Member member = this.party.getMembers().get(i);
            this.drawPlayer(gui, i, member);
        }
        gui.pose().popPose();
    }

    public void drawPlayer(GuiGraphics gui, int order, Party.Member member) {
        PlayerData playerData;
        int i;
        PoseStack matrixStack = gui.pose();
        byte partySize = (byte)WorldData.getClient().getPartyFromMember(member.getUUID()).getMembers().size();
        float space = 0.18f;
        float playerHeight = (float)this.height * 0.45f;
        float playerPosX = 140.0f + (space *= 2.0f / (float)partySize) * (float)order * 1000.0f;
        float playerPosY = (float)this.height * 0.7f;
        Player player = Utils.getPlayerByName((Level)this.minecraft.level, member.getUsername().toLowerCase());
        matrixStack.pushPose();
        matrixStack.translate(playerPosX, playerPosY, 0.0f);
        if (partySize > 4) {
            matrixStack.translate(0.0f, -2.5f, 0.0f);
            matrixStack.scale(5.0f / (float)partySize, 5.0f / (float)partySize, 1.0f);
        }
        matrixStack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (member != null && player != null) {
            matrixStack.pushPose();
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)gui, (int)0, (int)0, (int)0, (int)0, (int)((int)playerHeight / 2), (float)0.0f, (float)0.0f, (float)0.0f, (LivingEntity)player);
            matrixStack.popPose();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        matrixStack.popPose();
        matrixStack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.translate(-playerPosX, -playerPosY, 100.0f);
        RenderSystem.enableBlend();
        int infoBoxWidth = (int)((float)this.width * 0.1385f - 14.0f);
        int infoBoxPosX = (int)(105.0f + space * (float)order * 1000.0f);
        int infoBoxPosY = (int)((float)this.height * 0.54f);
        gui.blit(this.texture, infoBoxPosX, infoBoxPosY, 123, 67, 12, 22);
        for (i = 0; i < infoBoxWidth; ++i) {
            gui.blit(this.texture, infoBoxPosX + 10 + i, infoBoxPosY, 136, 67, 2, 22);
        }
        gui.blit(this.texture, infoBoxPosX + 10 + infoBoxWidth, infoBoxPosY, 137, 67, 3, 22);
        gui.blit(this.texture, infoBoxPosX, infoBoxPosY + 22, 123, 90, 4, 35);
        for (i = 0; i < infoBoxWidth + 8; ++i) {
            gui.blit(this.texture, infoBoxPosX + 2 + i, infoBoxPosY + 22, 128, 90, 2, 35);
        }
        gui.blit(this.texture, infoBoxPosX + 2 + infoBoxWidth + 8, infoBoxPosY + 22, 129, 90, 3, 35);
        RenderSystem.disableBlend();
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(-playerPosX, -playerPosY, 100.0f);
        matrixStack.pushPose();
        float f = infoBoxPosX + 8;
        Objects.requireNonNull(this.minecraft.font);
        matrixStack.translate(f, (float)(infoBoxPosY + (11 - 9 / 2)), 1.0f);
        gui.drawString(this.minecraft.font, member.getUsername(), 0, 0, 0xFFFFFF);
        matrixStack.popPose();
        if (player != null && (playerData = PlayerData.get(player)) != null) {
            gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.status.level", new Object[0]) + ": " + playerData.getLevel(), infoBoxPosX + 4, infoBoxPosY + 26, 16767232);
            Font font = this.minecraft.font;
            String string = Utils.translateToLocal("gui.menu.status.hp", new Object[0]) + ": " + (int)player.getHealth() + "/" + (int)player.getMaxHealth();
            Objects.requireNonNull(this.minecraft.font);
            gui.drawString(font, string, infoBoxPosX + 4, infoBoxPosY + 26 + 9, 65280);
            Font font2 = this.minecraft.font;
            String string2 = Utils.translateToLocal("gui.menu.status.mp", new Object[0]) + ": " + (int)playerData.getMP() + "/" + (int)playerData.getMaxMP();
            Objects.requireNonNull(this.minecraft.font);
            gui.drawString(font2, string2, infoBoxPosX + 4, infoBoxPosY + 26 + 9 * 2, 0x4444FF);
        }
        matrixStack.popPose();
        matrixStack.popPose();
    }
}

