/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.party;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Create;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Join;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSOpenMenu;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class GuiMenu_Party_None
extends MenuBackground {
    MenuButton back;
    MenuButton create;
    MenuButton join;
    final PlayerData playerData;
    WorldData worldData;
    Party party;
    final ResourceLocation texture;

    public GuiMenu_Party_None() {
        super("gui.menu.party", new Color(0, 0, 255));
        this.playerData = PlayerData.get((Player)this.minecraft.player);
        this.texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");
        this.drawPlayerInfo = true;
        this.worldData = WorldData.getClient();
    }

    protected void action(String string) {
        switch (string) {
            case "back": {
                PacketHandler.sendToServer(new CSOpenMenu());
                break;
            }
            case "create": {
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.minecraft.setScreen((Screen)new GuiMenu_Party_Create());
                break;
            }
            case "join": {
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.minecraft.setScreen((Screen)new GuiMenu_Party_Join());
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.create.visible = true;
        this.join.visible = true;
        this.back.visible = true;
    }

    @Override
    public void init() {
        this.width = this.width;
        this.height = this.height;
        super.init();
        this.renderables.clear();
        this.party = this.worldData.getPartyFromMember(this.minecraft.player.getUUID());
        float topBarHeight = (float)this.height * 0.17f;
        int button_statsY = (int)topBarHeight + 5;
        float buttonPosX = (float)this.width * 0.03f;
        float buttonWidth = (float)this.width * 0.1744f - 20.0f;
        this.create = new MenuButton((int)buttonPosX, button_statsY, (int)buttonWidth, "gui.menu.party.create", MenuButton.ButtonType.BUTTON, true, e -> this.action("create"));
        this.addRenderableWidget((GuiEventListener)this.create);
        this.join = new MenuButton((int)buttonPosX, button_statsY + 18, (int)buttonWidth, "gui.menu.party.join", MenuButton.ButtonType.BUTTON, true, e -> this.action("join"));
        this.addRenderableWidget((GuiEventListener)this.join);
        this.back = new MenuButton((int)buttonPosX, button_statsY + 36, (int)buttonWidth, "gui.menu.back", MenuButton.ButtonType.BUTTON, true, e -> this.action("back"));
        this.addRenderableWidget((GuiEventListener)this.back);
        this.updateButtons();
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.render(gui, mouseX, mouseY, partialTicks);
        this.worldData = WorldData.getClient();
        this.drawParty(gui);
    }

    public void drawParty(GuiGraphics gui) {
        this.party = this.worldData.getPartyFromMember(this.minecraft.player.getUUID());
        if (this.party != null) {
            for (int i = 0; i < this.party.getMembers().size(); ++i) {
                Party.Member member = this.party.getMembers().get(i);
                this.drawPlayer(gui, i, member);
            }
        } else {
            Party.Member m = new Party.Member(this.minecraft.player.getUUID(), this.minecraft.player.getDisplayName().getString());
            this.drawPlayer(gui, 0, m);
        }
    }

    public void drawPlayer(GuiGraphics gui, int order, Party.Member member) {
        PlayerData playerData;
        int i;
        PoseStack matrixStack = gui.pose();
        float playerHeight = (float)this.height * 0.45f;
        float playerPosX = 150.0f + 0.18f * (float)order * (float)this.width;
        float playerPosY = (float)this.height * 0.7f;
        Player player = Utils.getPlayerByName((Level)this.minecraft.level, member.getUsername());
        matrixStack.pushPose();
        matrixStack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (member != null && player != null) {
            ClientUtils.renderPlayerNoAnims(gui.pose(), (int)playerPosX, (int)playerPosY, (int)playerHeight / 2, 0.0f, 0.0f, (LivingEntity)player);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        matrixStack.popPose();
        matrixStack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.translate(9.0f, 1.0f, 100.0f);
        RenderSystem.enableBlend();
        int infoBoxWidth = (int)((float)this.width * 0.1385f - 14.0f);
        int infoBoxPosX = (int)(105.0f + 0.18f * (float)order * (float)this.width);
        int infoBoxPosY = (int)((float)this.height * 0.54f);
        gui.blit(this.texture, infoBoxPosX, infoBoxPosY, 123, 67, 11, 22);
        for (i = 0; i < infoBoxWidth; ++i) {
            gui.blit(this.texture, infoBoxPosX + 11 + i, infoBoxPosY, 135, 67, 1, 22);
        }
        gui.blit(this.texture, infoBoxPosX + 11 + infoBoxWidth, infoBoxPosY, 137, 67, 3, 22);
        gui.blit(this.texture, infoBoxPosX, infoBoxPosY + 22, 123, 90, 3, 35);
        for (i = 0; i < infoBoxWidth + 8; ++i) {
            gui.blit(this.texture, infoBoxPosX + 3 + i, infoBoxPosY + 22, 127, 90, 1, 35);
        }
        gui.blit(this.texture, infoBoxPosX + 3 + infoBoxWidth + 8, infoBoxPosY + 22, 129, 90, 3, 35);
        RenderSystem.disableBlend();
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(10.0f, 2.0f, 100.0f);
        matrixStack.pushPose();
        float f = infoBoxPosX + 8;
        Objects.requireNonNull(this.minecraft.font);
        matrixStack.translate(f, (float)(infoBoxPosY + (11 - 9 / 2)), 1.0f);
        gui.drawString(this.minecraft.font, member.getUsername(), 0, 0, 0xFFFFFF);
        matrixStack.popPose();
        if (player != null && (playerData = PlayerData.get(player)) != null) {
            gui.drawString(this.minecraft.font, "LV: " + playerData.getLevel(), infoBoxPosX + 4, infoBoxPosY + 26, 16767232);
            Font font = this.minecraft.font;
            String string = "HP: " + (int)player.getHealth() + "/" + (int)player.getMaxHealth();
            Objects.requireNonNull(this.minecraft.font);
            gui.drawString(font, string, infoBoxPosX + 4, infoBoxPosY + 26 + 9, 65280);
            Font font2 = this.minecraft.font;
            String string2 = "MP: " + (int)playerData.getMP() + "/" + (int)playerData.getMaxMP();
            Objects.requireNonNull(this.minecraft.font);
            gui.drawString(font2, string2, infoBoxPosX + 4, infoBoxPosY + 26 + 9 * 2, 0x4444FF);
        }
        matrixStack.popPose();
        matrixStack.popPose();
    }
}

