/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.party;

import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Leader;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Member;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSOpenMenu;
import online.kingdomkeys.kingdomkeys.network.cts.CSPartySettings;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class GuiMenu_Party_Settings
extends MenuBackground {
    boolean priv = false;
    boolean friendlyFire = false;
    int pSize;
    Button togglePriv;
    Button toggleFF;
    Button accept;
    Button size;
    MenuButton back;
    final PlayerData playerData;
    WorldData worldData;
    Party party;

    public GuiMenu_Party_Settings() {
        super("gui.menu.party.settings", new Color(0, 0, 255));
        this.pSize = (Integer)ModConfigs.SERVER.partyMembersLimit.get();
        this.playerData = PlayerData.get((Player)this.minecraft.player);
        this.drawPlayerInfo = true;
        this.worldData = WorldData.getClient();
    }

    protected void action(String string) {
        switch (string) {
            case "back": {
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.minecraft.setScreen((Screen)new GuiMenu_Party_Leader());
                break;
            }
            case "togglePriv": {
                this.priv = !this.priv;
                break;
            }
            case "ff": {
                this.friendlyFire = !this.friendlyFire;
                break;
            }
            case "accept": {
                this.party.setPriv(this.priv);
                this.party.setSize((byte)this.pSize);
                this.party.setFriendlyFire(this.friendlyFire);
                PacketHandler.sendToServer(new CSPartySettings(this.party));
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.minecraft.setScreen((Screen)new GuiMenu_Party_Leader());
                break;
            }
            case "size": {
                this.pSize = this.pSize == (Integer)ModConfigs.SERVER.partyMembersLimit.get() ? 2 : ++this.pSize;
                this.size.setMessage((Component)Component.translatable((String)("" + this.pSize)));
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.togglePriv.setMessage((Component)(this.priv ? Component.translatable((String)Utils.translateToLocal("gui.menu.party.create.accessibility.private", new Object[0])) : Component.translatable((String)Utils.translateToLocal("gui.menu.party.create.accessibility.public", new Object[0]))));
        this.toggleFF.setMessage((Component)Component.translatable((String)("" + this.friendlyFire)));
        this.size.setMessage((Component)Component.translatable((String)("" + this.pSize)));
        this.togglePriv.visible = true;
        this.toggleFF.visible = true;
        this.accept.visible = true;
        this.size.visible = true;
    }

    @Override
    public void init() {
        this.width = this.width;
        this.height = this.height;
        super.init();
        this.renderables.clear();
        this.party = this.worldData.getPartyFromMember(this.minecraft.player.getUUID());
        if (this.party != null) {
            this.priv = this.party.getPriv();
            this.pSize = this.party.getSize();
            this.friendlyFire = this.party.getFriendlyFire();
            float topBarHeight = (float)this.height * 0.17f;
            int button_statsY = (int)topBarHeight + 5;
            float buttonPosX = (float)this.width * 0.03f;
            float buttonWidth = (float)this.width * 0.1744f - 20.0f;
            this.togglePriv = Button.builder((Component)Component.literal((String)""), e -> this.action("togglePriv")).bounds((int)((double)this.width * 0.25) - 2, button_statsY + 18, 100, 20).build();
            this.addRenderableWidget((GuiEventListener)this.togglePriv);
            this.size = Button.builder((Component)Component.literal((String)""), e -> this.action("size")).bounds((int)((double)this.width * 0.25 - 2.0 + 100.0 + 4.0), button_statsY + 18, 20, 20).build();
            this.addRenderableWidget((GuiEventListener)this.size);
            this.toggleFF = Button.builder((Component)Component.literal((String)""), e -> this.action("ff")).bounds((int)((double)this.width * 0.25) - 2, button_statsY + 54, 100, 20).build();
            this.addRenderableWidget((GuiEventListener)this.toggleFF);
            this.accept = Button.builder((Component)Component.translatable((String)Utils.translateToLocal("gui.menu.accept", new Object[0])), e -> this.action("accept")).bounds((int)((double)this.width * 0.25) - 2, button_statsY + 90, 130, 20).build();
            this.addRenderableWidget((GuiEventListener)this.accept);
            this.back = new MenuButton((int)buttonPosX, button_statsY, (int)buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
            this.addRenderableWidget((GuiEventListener)this.back);
        }
        this.updateButtons();
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.render(gui, mouseX, mouseY, partialTicks);
        this.worldData = WorldData.getClient();
        this.party = this.worldData.getPartyFromMember(this.minecraft.player.getUUID());
        if (this.party == null) {
            PacketHandler.sendToServer(new CSOpenMenu());
        } else {
            if (!this.party.getMember(this.minecraft.player.getUUID()).isLeader()) {
                this.minecraft.setScreen((Screen)new GuiMenu_Party_Member());
                return;
            }
            int buttonX = (int)((double)this.width * 0.25);
            gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.party.create.accessibility", new Object[0]), buttonX, (int)((double)this.height * 0.21), 0xFFFFFF);
            gui.drawString(this.minecraft.font, Utils.translateToLocal("Friendly Fire", new Object[0]), buttonX, (int)((double)this.height * 0.21) + 38, 0xFFFFFF);
        }
    }
}

