/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.status;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuColourBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSOpenMenu;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MenuStatusScreen
extends MenuBackground {
    String form = DriveForm.NONE.toString();
    final PlayerData playerData;
    Button stats_player;
    Button stats_back;
    List<MenuButton> dfStats;
    MenuColourBox level;
    MenuColourBox totalExp;
    MenuColourBox nextLevel;
    MenuColourBox hp;
    MenuColourBox mp;
    MenuColourBox ap;
    MenuColourBox driveGauge;
    MenuColourBox str;
    MenuColourBox mag;
    MenuColourBox def;
    MenuColourBox fRes;
    MenuColourBox bRes;
    MenuColourBox tRes;
    MenuColourBox aRes;
    MenuColourBox lRes;
    MenuColourBox wRes;
    MenuColourBox dRes;
    MenuColourBox dfLevel;
    MenuColourBox dfExp;
    MenuColourBox dfNextLevel;
    MenuColourBox dfFormGauge;
    MenuColourBox[] playerWidgets;
    MenuColourBox[] dfWidgets;

    public MenuStatusScreen() {
        super("gui.menu.status", new Color(0, 0, 255));
        this.playerData = PlayerData.get((Player)this.minecraft.player);
        this.dfStats = new ArrayList<MenuButton>();
        this.playerWidgets = new MenuColourBox[]{this.level, this.totalExp, this.nextLevel, this.hp, this.mp, this.ap, this.driveGauge, this.str, this.mag, this.def, this.fRes, this.bRes, this.tRes, this.lRes, this.wRes, this.dRes};
        this.dfWidgets = new MenuColourBox[]{this.dfLevel, this.dfExp, this.dfNextLevel, this.dfFormGauge};
        this.drawPlayerInfo = false;
    }

    protected void action(String string) {
        if (string.equals("back")) {
            PacketHandler.sendToServer(new CSOpenMenu());
        } else {
            this.form = string;
        }
        this.updateButtons();
    }

    private void updateButtons() {
        PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
        this.stats_player.active = !this.form.equals(DriveForm.NONE.toString());
        for (int i = 0; i < this.dfStats.size(); ++i) {
            this.dfStats.get((int)i).active = !this.form.equals(this.dfStats.get(i).getData()) && playerData.getDriveFormMap().containsKey(this.dfStats.get(i).getData());
            this.dfStats.get(i).setSelected(!this.dfStats.get((int)i).active);
        }
        if (this.form.equals(DriveForm.NONE.toString())) {
            this.form = DriveForm.NONE.toString();
            this.dfLevel.visible = false;
            this.dfExp.visible = false;
            this.dfNextLevel.visible = false;
            this.dfFormGauge.visible = false;
            this.level.visible = true;
            this.totalExp.visible = true;
            this.nextLevel.visible = true;
            this.hp.visible = true;
            this.mp.visible = true;
            this.ap.visible = true;
            this.driveGauge.visible = true;
        } else {
            this.dfLevel.visible = true;
            this.dfExp.visible = true;
            this.dfNextLevel.visible = true;
            this.dfFormGauge.visible = true;
            this.level.visible = false;
            this.totalExp.visible = false;
            this.nextLevel.visible = false;
            this.hp.visible = false;
            this.mp.visible = false;
            this.ap.visible = false;
            this.driveGauge.visible = false;
            int remainingExp = playerData.getDriveFormLevel(this.form) == ((DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)this.form))).getMaxLevel() ? 0 : ((DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)this.form))).getLevelUpCost(playerData.getDriveFormLevel(this.form) + 1) - playerData.getDriveFormExp(this.form);
            this.dfLevel.setValue("" + playerData.getDriveFormLevel(this.form));
            this.dfExp.setValue("" + playerData.getDriveFormExp(this.form));
            this.dfNextLevel.setValue("" + remainingExp);
            this.dfFormGauge.setValue("" + (2 + playerData.getDriveFormLevel(this.form)));
        }
    }

    @Override
    public void init() {
        int button_statsY;
        super.init();
        this.renderables.clear();
        float topBarHeight = (float)this.height * 0.17f;
        int button_stats_playerY = button_statsY = (int)topBarHeight + 5;
        int button_stats_formsY = button_stats_playerY + 18;
        float buttonPosX = (float)this.width * 0.03f;
        float subButtonPosX = buttonPosX + 10.0f;
        float buttonWidth = (float)this.width * 0.1744f - 20.0f;
        float subButtonWidth = buttonWidth - 10.0f;
        float dataWidth = (float)this.width * 0.1744f - 10.0f;
        int col1X = (int)(subButtonPosX + buttonWidth + 40.0f);
        int col2X = (int)((float)col1X + dataWidth * 2.0f) + 10;
        this.stats_player = new MenuButton((int)buttonPosX, button_stats_playerY, (int)buttonWidth, this.minecraft.player.getDisplayName().getString(), MenuButton.ButtonType.BUTTON, e -> this.action(DriveForm.NONE.toString()));
        this.addRenderableWidget((GuiEventListener)this.stats_player);
        int i = 0;
        ArrayList<String> forms = new ArrayList<String>(Utils.getSortedDriveForms(this.playerData.getDriveFormMap(), Utils.getVisibleDriveForms((Player)this.minecraft.player)).keySet());
        forms.remove(DriveForm.NONE.toString());
        forms.remove(DriveForm.SYNCH_BLADE.toString());
        forms.remove("kingdomkeys:form_anti");
        for (i = 0; i < forms.size(); ++i) {
            String formName = (String)forms.get(i);
            String name = ((DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)formName))).getTranslationKey();
            MenuButton b = new MenuButton((int)subButtonPosX, button_stats_formsY + i * 18, (int)subButtonWidth, Utils.translateToLocal(name, new Object[0]), MenuButton.ButtonType.SUBBUTTON, e -> this.action(formName));
            b.setData(formName);
            this.dfStats.add(b);
            this.addRenderableWidget((GuiEventListener)b);
        }
        this.stats_back = new MenuButton((int)buttonPosX, button_stats_formsY + i * 18, (int)buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.addRenderableWidget((GuiEventListener)this.stats_back);
        int c = 0;
        int spacer = 14;
        this.level = new MenuColourBox(col1X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.level", new Object[0]), "" + this.playerData.getLevel(), 136);
        this.addRenderableWidget((GuiEventListener)this.level);
        this.totalExp = new MenuColourBox(col1X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.totalexp", new Object[0]), "" + this.playerData.getExperience(), 136);
        this.addRenderableWidget((GuiEventListener)this.totalExp);
        this.nextLevel = new MenuColourBox(col1X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.nextlevel", new Object[0]), "" + this.playerData.getExpNeeded(this.playerData.getLevel(), this.playerData.getExperience()), 136);
        this.addRenderableWidget((GuiEventListener)this.nextLevel);
        this.hp = new MenuColourBox(col1X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.hp", new Object[0]), "" + (int)this.minecraft.player.getMaxHealth(), 34816);
        this.addRenderableWidget((GuiEventListener)this.hp);
        this.mp = new MenuColourBox(col1X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.mp", new Object[0]), "" + (int)this.playerData.getMaxMP(), 34816);
        this.addRenderableWidget((GuiEventListener)this.mp);
        this.ap = new MenuColourBox(col1X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.ap", new Object[0]), Utils.getConsumedAP(this.playerData) + "/" + this.playerData.getMaxAP(true), 34816);
        this.addRenderableWidget((GuiEventListener)this.ap);
        this.driveGauge = new MenuColourBox(col1X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.drivegauge", new Object[0]), "" + (int)this.playerData.getMaxDP() / 100, 34816);
        this.addRenderableWidget((GuiEventListener)this.driveGauge);
        c = 0;
        this.str = new MenuColourBox(col2X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.strength", new Object[0]), "" + this.playerData.getStrength(true), 0x880000);
        this.addRenderableWidget((GuiEventListener)this.str);
        this.mag = new MenuColourBox(col2X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.magic", new Object[0]), "" + this.playerData.getMagic(true), 0x880000);
        this.addRenderableWidget((GuiEventListener)this.mag);
        this.def = new MenuColourBox(col2X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.defense", new Object[0]), "" + this.playerData.getDefense(true), 0x880000);
        this.addRenderableWidget((GuiEventListener)this.def);
        this.fRes = new MenuColourBox(col2X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.fireres", new Object[0]), Utils.getArmorsStat(this.playerData, "fire") + "%", 0x887700);
        this.addRenderableWidget((GuiEventListener)this.fRes);
        this.bRes = new MenuColourBox(col2X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.blizzardres", new Object[0]), Utils.getArmorsStat(this.playerData, "ice") + "%", 0x887700);
        this.addRenderableWidget((GuiEventListener)this.bRes);
        this.wRes = new MenuColourBox(col2X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.waterres", new Object[0]), Utils.getArmorsStat(this.playerData, "water") + "%", 0x887700);
        this.addRenderableWidget((GuiEventListener)this.wRes);
        this.tRes = new MenuColourBox(col2X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.thunderres", new Object[0]), Utils.getArmorsStat(this.playerData, "lightning") + "%", 0x887700);
        this.addRenderableWidget((GuiEventListener)this.tRes);
        this.aRes = new MenuColourBox(col2X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.airres", new Object[0]), Utils.getArmorsStat(this.playerData, "air") + "%", 0x887700);
        this.addRenderableWidget((GuiEventListener)this.aRes);
        this.lRes = new MenuColourBox(col2X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.lightres", new Object[0]), Utils.getArmorsStat(this.playerData, "light") + "%", 0x887700);
        this.addRenderableWidget((GuiEventListener)this.lRes);
        this.dRes = new MenuColourBox(col2X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.darkres", new Object[0]), Utils.getArmorsStat(this.playerData, "darkness") + "%", 0x887700);
        this.addRenderableWidget((GuiEventListener)this.dRes);
        c = 0;
        this.dfLevel = new MenuColourBox(col1X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.formlevel", new Object[0]), "", 136);
        this.addRenderableWidget((GuiEventListener)this.dfLevel);
        this.dfExp = new MenuColourBox(col1X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.totalexp", new Object[0]), "", 136);
        this.addRenderableWidget((GuiEventListener)this.dfExp);
        this.dfNextLevel = new MenuColourBox(col1X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.nextlevel", new Object[0]), "", 136);
        this.addRenderableWidget((GuiEventListener)this.dfNextLevel);
        this.dfFormGauge = new MenuColourBox(col1X, button_statsY + c++ * spacer, (int)dataWidth * 2, Utils.translateToLocal("gui.menu.status.formgauge", new Object[0]), "", 34816);
        this.addRenderableWidget((GuiEventListener)this.dfFormGauge);
        this.updateButtons();
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        gui.fill(125, 77, 200, 87, 0xFFFFFF);
        super.render(gui, mouseX, mouseY, partialTicks);
    }
}

