/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.struggle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.menu.struggle.StruggleCreate;
import online.kingdomkeys.kingdomkeys.client.gui.menu.struggle.StruggleJoin;
import online.kingdomkeys.kingdomkeys.client.gui.menu.struggle.StruggleSettings;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.lib.Struggle;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MenuStruggle
extends MenuBackground {
    BlockPos boardPos;
    MenuButton create;
    MenuButton join;
    MenuButton settings;
    final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");

    public MenuStruggle(BlockPos pos) {
        super("Menu", new Color(252, 173, 3));
        this.minecraft = Minecraft.getInstance();
        this.boardPos = pos;
    }

    protected void action(buttons buttonID) {
        switch (buttonID.ordinal()) {
            case 0: {
                this.minecraft.setScreen((Screen)new StruggleCreate(this.boardPos));
                break;
            }
            case 1: {
                this.minecraft.setScreen((Screen)new StruggleJoin(this.boardPos));
                break;
            }
            case 2: {
                this.minecraft.setScreen((Screen)new StruggleSettings(this.boardPos));
            }
        }
        this.updateButtons();
    }

    @Override
    public void init() {
        this.width = this.width;
        this.height = this.height;
        super.init();
        float topBarHeight = (float)this.height * 0.17f;
        int start = (int)topBarHeight + 5;
        int pos = 0;
        float buttonPosX = (float)this.width * 0.03f;
        float buttonWidth = (float)this.width * 0.1744f - 22.0f;
        this.create = new MenuButton((int)buttonPosX, start, (int)buttonWidth, "Create match", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.CREATE));
        this.addRenderableWidget((GuiEventListener)this.create);
        this.join = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "Join match", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.JOIN));
        this.addRenderableWidget((GuiEventListener)this.join);
        this.settings = new MenuButton((int)buttonPosX, start + 18 * ++pos, (int)buttonWidth, "Struggle Settings", MenuButton.ButtonType.BUTTON, true, e -> this.action(buttons.SETTINGS));
        this.addRenderableWidget((GuiEventListener)this.settings);
        Struggle s = WorldData.getClient().getStruggleFromParticipant(this.minecraft.player.getUUID());
        if (s != null) {
            System.out.println(s.getOwner().getUsername());
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.create.visible = true;
        this.join.visible = true;
        Struggle s = WorldData.getClient().getStruggleFromParticipant(this.minecraft.player.getUUID());
        if (s != null) {
            this.settings.visible = s.getOwner().getUUID().equals(this.minecraft.player.getUUID());
        }
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.render(gui, mouseX, mouseY, partialTicks);
        this.drawPlayer(gui);
    }

    public void drawPlayer(GuiGraphics gui) {
        PoseStack matrixStack = gui.pose();
        float playerHeight = (float)this.height * 0.45f;
        float playerPosX = (float)this.width * 0.5229f;
        float playerPosY = (float)this.height * 0.7f;
        PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
        if (playerData != null) {
            int i;
            matrixStack.pushPose();
            LocalPlayer player = this.minecraft.player;
            ClientUtils.renderPlayerNoAnims(matrixStack, (int)playerPosX, (int)playerPosY, (int)playerHeight / 2, 0.0f, 0.0f, (LivingEntity)player);
            matrixStack.popPose();
            matrixStack.pushPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.translate(1.0f, 1.0f, 100.0f);
            RenderSystem.enableBlend();
            int infoBoxWidth = (int)((float)this.width * 0.1385f - 14.0f);
            int infoBoxPosX = (int)((float)this.width * 0.4354f);
            int infoBoxPosY = (int)((float)this.height * 0.54f);
            gui.blit(this.texture, infoBoxPosX, infoBoxPosY, 123, 67, 11, 22);
            for (i = 0; i < infoBoxWidth; ++i) {
                gui.blit(this.texture, infoBoxPosX + 11 + i, infoBoxPosY, 135, 67, 1, 22);
            }
            gui.blit(this.texture, infoBoxPosX + 11 + infoBoxWidth, infoBoxPosY, 137, 67, 3, 22);
            gui.blit(this.texture, infoBoxPosX, infoBoxPosY + 22, 123, 90, 3, 35);
            for (i = 0; i < infoBoxWidth + 8; ++i) {
                gui.blit(this.texture, infoBoxPosX + 3 + i, infoBoxPosY + 22, 127, 90, 1, 35);
            }
            gui.blit(this.texture, infoBoxPosX + 3 + infoBoxWidth + 8, infoBoxPosY + 22, 129, 90, 3, 35);
            RenderSystem.disableBlend();
            matrixStack.popPose();
            matrixStack.pushPose();
            matrixStack.translate(2.0f, 2.0f, 100.0f);
            matrixStack.pushPose();
            float f = infoBoxPosX + 8;
            Objects.requireNonNull(this.minecraft.font);
            matrixStack.translate(f, (float)(infoBoxPosY + (11 - 9 / 2)), 1.0f);
            gui.drawString(this.minecraft.font, this.minecraft.player.getDisplayName().getString(), 0, 0, 0xFFFFFF);
            matrixStack.popPose();
            gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.status.level", new Object[0]) + ": " + playerData.getLevel(), infoBoxPosX + 4, infoBoxPosY + 26, 16767232);
            Font font = this.minecraft.font;
            String string = Utils.translateToLocal("gui.menu.status.hp", new Object[0]) + ": " + (int)this.minecraft.player.getHealth() + "/" + (int)this.minecraft.player.getMaxHealth();
            Objects.requireNonNull(this.minecraft.font);
            gui.drawString(font, string, infoBoxPosX + 4, infoBoxPosY + 26 + 9, 65280);
            Font font2 = this.minecraft.font;
            String string2 = Utils.translateToLocal("gui.menu.status.mp", new Object[0]) + ": " + (int)playerData.getMP() + "/" + (int)playerData.getMaxMP();
            Objects.requireNonNull(this.minecraft.font);
            gui.drawString(font2, string2, infoBoxPosX + 4, infoBoxPosY + 26 + 9 * 2, 0x4444FF);
            matrixStack.popPose();
        }
    }

    public static enum buttons {
        CREATE,
        JOIN,
        SETTINGS;

    }
}

