/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.struggle;

import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Leader;
import online.kingdomkeys.kingdomkeys.client.gui.menu.struggle.MenuStruggle;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSPartyCreate;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class StruggleCreate
extends MenuBackground {
    BlockPos boardPos;
    boolean priv = false;
    int pSize;
    EditBox tfName;
    Button togglePriv;
    Button accept;
    Button size;
    MenuButton back;
    final PlayerData playerData;
    WorldData worldData;
    Party party;

    public StruggleCreate(BlockPos pos) {
        super("Start Struggle", new Color(252, 173, 3));
        this.pSize = (Integer)ModConfigs.SERVER.partyMembersLimit.get();
        this.playerData = PlayerData.get((Player)this.minecraft.player);
        this.drawPlayerInfo = true;
        this.worldData = WorldData.getClient();
        this.boardPos = pos;
    }

    protected void action(String string) {
        switch (string) {
            case "back": {
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.minecraft.setScreen((Screen)new MenuStruggle(this.boardPos));
                break;
            }
            case "togglePriv": {
                this.priv = !this.priv;
                break;
            }
            case "accept": {
                if (this.tfName.getValue().equals("") || !this.checkAvailable()) break;
                Party localParty = new Party(this.tfName.getValue(), this.minecraft.player.getUUID(), this.minecraft.player.getName().getString(), this.priv, Byte.parseByte(this.size.getMessage().getString()));
                PacketHandler.sendToServer(new CSPartyCreate(localParty));
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.minecraft.setScreen((Screen)new GuiMenu_Party_Leader());
                break;
            }
            case "size": {
                this.pSize = this.pSize == (Integer)ModConfigs.SERVER.partyMembersLimit.get() ? 2 : ++this.pSize;
                this.size.setMessage((Component)Component.translatable((String)("" + this.pSize)));
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.togglePriv.setMessage((Component)(this.priv ? Component.translatable((String)Utils.translateToLocal("gui.menu.party.create.accessibility.private", new Object[0])) : Component.translatable((String)Utils.translateToLocal("gui.menu.party.create.accessibility.public", new Object[0]))));
        this.togglePriv.visible = true;
        this.accept.visible = true;
        this.tfName.visible = true;
        this.size.visible = true;
    }

    @Override
    public void init() {
        super.init();
        this.renderables.clear();
        this.party = this.worldData.getPartyFromMember(this.minecraft.player.getUUID());
        float topBarHeight = (float)this.height * 0.17f;
        int button_statsY = (int)topBarHeight + 5;
        float buttonPosX = (float)this.width * 0.03f;
        float buttonWidth = (float)this.width * 0.1744f - 20.0f;
        this.togglePriv = Button.builder((Component)Component.literal((String)""), e -> this.action("togglePriv")).bounds((int)((double)this.width * 0.25) - 2, button_statsY + 54, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.togglePriv);
        this.accept = Button.builder((Component)Component.translatable((String)Utils.translateToLocal("gui.menu.accept", new Object[0])), e -> this.action("accept")).bounds((int)((double)this.width * 0.25) - 2, button_statsY + 90, 100, 20).build();
        this.addRenderableWidget((GuiEventListener)this.accept);
        this.size = Button.builder((Component)Component.translatable((String)String.valueOf(ModConfigs.SERVER.partyMembersLimit.get())), e -> this.action("size")).bounds((int)((double)this.width * 0.25 - 2.0 + 100.0 + 4.0), button_statsY + 54, 20, 20).build();
        this.addRenderableWidget((GuiEventListener)this.size);
        this.back = new MenuButton((int)buttonPosX, button_statsY, (int)buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.addRenderableWidget((GuiEventListener)this.back);
        this.tfName = new EditBox(this.minecraft.font, (int)((double)this.width * 0.25), (int)((double)this.height * 0.25), 100, 15, (Component)Component.literal((String)"")){

            public boolean charTyped(char c, int i) {
                super.charTyped(c, i);
                StruggleCreate.this.checkAvailable();
                return true;
            }

            public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                super.keyPressed(keyCode, scanCode, modifiers);
                StruggleCreate.this.checkAvailable();
                return true;
            }
        };
        this.addRenderableWidget((GuiEventListener)this.tfName);
        this.updateButtons();
    }

    private boolean checkAvailable() {
        if (this.tfName.getValue() != null && !this.tfName.getValue().equals("")) {
            Party p = this.worldData.getPartyFromName(this.tfName.getValue());
            this.accept.active = p == null;
            return p == null;
        }
        return false;
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.render(gui, mouseX, mouseY, partialTicks);
        this.worldData = WorldData.getClient();
        this.party = this.worldData.getPartyFromMember(this.minecraft.player.getUUID());
        int buttonX = (int)((double)this.width * 0.25);
        gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.party.create.name", new Object[0]), buttonX, (int)((double)this.height * 0.2), 0xFFFFFF);
        gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.party.create.accessibility", new Object[0]), buttonX, (int)((double)this.height * 0.35), 0xFFFFFF);
    }
}

