/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.struggle;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.menu.struggle.MenuStruggle;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.Struggle;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSStruggleSettings;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class StruggleSettings
extends MenuBackground {
    EditBox nameBox;
    EditBox pos1Box;
    EditBox pos2Box;
    EditBox dmgMultBox;
    boolean priv = false;
    byte pSize = (byte)8;
    int dmgMult = 100;
    BlockPos pos1;
    BlockPos pos2;
    BlockPos boardPos;
    Button togglePriv;
    Button accept;
    Button size;
    MenuButton back;
    final PlayerData playerData;
    WorldData worldData;
    Struggle struggle;

    public StruggleSettings(BlockPos pos) {
        super("Struggle Settings", new Color(252, 173, 3));
        this.playerData = PlayerData.get((Player)this.minecraft.player);
        this.drawPlayerInfo = true;
        this.worldData = WorldData.getClient();
        this.boardPos = pos;
    }

    protected void action(String string) {
        switch (string) {
            case "back": {
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.minecraft.setScreen((Screen)new MenuStruggle(this.boardPos));
                break;
            }
            case "togglePriv": {
                this.priv = !this.priv;
                break;
            }
            case "dmg_mult": {
                this.dmgMult = 1;
                break;
            }
            case "accept": {
                this.struggle.setSize(this.pSize);
                this.struggle.setDamageMult(this.dmgMult);
                this.struggle.setName(this.nameBox.getValue());
                this.pos1 = Utils.stringArrayToBlockPos(this.pos1Box.getValue().split(","));
                this.pos2 = Utils.stringArrayToBlockPos(this.pos2Box.getValue().split(","));
                this.struggle.setC1(this.pos1);
                this.struggle.setC2(this.pos2);
                PacketHandler.sendToServer(new CSStruggleSettings(this.struggle));
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.minecraft.setScreen((Screen)new MenuStruggle(this.boardPos));
                break;
            }
            case "size": {
                this.pSize = this.pSize == 8 ? (byte)2 : (byte)(this.pSize + 1);
                this.size.setMessage((Component)Component.translatable((String)("" + this.pSize)));
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.struggle == null) {
            return;
        }
        this.size.setMessage((Component)Component.translatable((String)("" + this.pSize)));
        this.nameBox.setValue(this.struggle.getName());
        this.dmgMultBox.setValue("" + this.dmgMult);
        if (this.struggle.c1 != null && this.struggle.c2 != null) {
            this.pos1Box.setValue(this.struggle.c1.getX() + "," + this.struggle.c1.getY() + "," + this.struggle.c1.getZ());
            this.pos2Box.setValue(this.struggle.c2.getX() + "," + this.struggle.c2.getY() + "," + this.struggle.c2.getZ());
        }
        this.accept.setMessage((Component)Component.translatable((String)"Accept"));
        this.accept.visible = true;
        this.size.visible = true;
    }

    @Override
    public void init() {
        this.width = this.width;
        this.height = this.height;
        super.init();
        this.renderables.clear();
        this.struggle = this.worldData.getStruggleFromBlockPos(this.boardPos);
        if (this.struggle != null) {
            this.pSize = this.struggle.getSize();
            this.dmgMult = this.struggle.getDamageMult();
            float topBarHeight = (float)this.height * 0.17f;
            int button_statsY = (int)topBarHeight + 5;
            float buttonPosX = (float)this.width * 0.03f;
            float buttonWidth = (float)this.width * 0.1744f - 20.0f;
            this.nameBox = new EditBox(this.minecraft.font, (int)((double)this.width * 0.25), button_statsY + 18, 100, 16, (Component)Component.literal((String)"")){

                public boolean charTyped(char c, int i) {
                    super.charTyped(c, i);
                    StruggleSettings.this.checkAvailable();
                    return true;
                }

                public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                    super.keyPressed(keyCode, scanCode, modifiers);
                    StruggleSettings.this.checkAvailable();
                    return true;
                }
            };
            this.addRenderableWidget((GuiEventListener)this.nameBox);
            this.size = Button.builder((Component)Component.literal((String)""), e -> this.action("size")).bounds((int)((double)this.width * 0.25 - 2.0 + 100.0 + 4.0), button_statsY + 18 - 2, 20, 20).build();
            this.addRenderableWidget((GuiEventListener)this.size);
            this.dmgMultBox = new EditBox(this.minecraft.font, (int)((double)this.width * 0.25), button_statsY + 54, 30, 15, (Component)Component.literal((String)"")){

                public boolean charTyped(char c, int i) {
                    if (Utils.isNumber(c) || c == '-') {
                        String text = new StringBuilder(this.getValue()).insert(this.getCursorPosition(), c).toString();
                        if (Utils.getInt(text) < 1000 && Utils.getInt(text) > -1000) {
                            super.charTyped(c, i);
                            StruggleSettings.this.dmgMult = Utils.getInt(this.getValue());
                            return true;
                        }
                        return false;
                    }
                    return false;
                }

                public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                    super.keyPressed(keyCode, scanCode, modifiers);
                    StruggleSettings.this.dmgMult = Utils.getInt(this.getValue());
                    return true;
                }

                public void renderWidget(@NotNull GuiGraphics gui, int pMouseX, int pMouseY, float pPartialTick) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    super.render(gui, pMouseX, pMouseY, pPartialTick);
                }
            };
            this.addRenderableWidget((GuiEventListener)this.dmgMultBox);
            this.pos1Box = new EditBox(this, this.minecraft.font, (int)((double)this.width * 0.25), button_statsY + 90, 100, 15, (Component)Component.literal((String)"")){

                public boolean charTyped(char c, int i) {
                    if (Utils.isNumber(c) || c == '-' || c == ',') {
                        String text = new StringBuilder(this.getValue()).insert(this.getCursorPosition(), c).toString();
                        if (Utils.getInt(text) < 1000 && Utils.getInt(text) > -1000) {
                            super.charTyped(c, i);
                            return true;
                        }
                        return false;
                    }
                    return false;
                }

                public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                    super.keyPressed(keyCode, scanCode, modifiers);
                    return true;
                }

                public void renderWidget(@NotNull GuiGraphics gui, int pMouseX, int pMouseY, float pPartialTick) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    super.render(gui, pMouseX, pMouseY, pPartialTick);
                }
            };
            this.addRenderableWidget((GuiEventListener)this.pos1Box);
            this.pos2Box = new EditBox(this, this.minecraft.font, (int)((double)this.width * 0.25) + 110, button_statsY + 90, 100, 15, (Component)Component.literal((String)"")){

                public boolean charTyped(char c, int i) {
                    if (Utils.isNumber(c) || c == '-' || c == ',') {
                        String text = new StringBuilder(this.getValue()).insert(this.getCursorPosition(), c).toString();
                        if (Utils.getInt(text) < 1000 && Utils.getInt(text) > -1000) {
                            super.charTyped(c, i);
                            return true;
                        }
                        return false;
                    }
                    return false;
                }

                public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                    super.keyPressed(keyCode, scanCode, modifiers);
                    return true;
                }

                public void renderWidget(@NotNull GuiGraphics gui, int pMouseX, int pMouseY, float pPartialTick) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    super.render(gui, pMouseX, pMouseY, pPartialTick);
                }
            };
            this.addRenderableWidget((GuiEventListener)this.pos2Box);
            this.accept = Button.builder((Component)Component.literal((String)""), e -> this.action("accept")).bounds((int)((double)this.width * 0.25) - 2, button_statsY + 108, 130, 20).build();
            this.addRenderableWidget((GuiEventListener)this.accept);
            this.back = new MenuButton((int)buttonPosX, button_statsY, (int)buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
            this.addRenderableWidget((GuiEventListener)this.back);
        }
        this.updateButtons();
    }

    private boolean checkAvailable() {
        if (this.nameBox.getValue() != null && !this.nameBox.getValue().equals("")) {
            Party p = this.worldData.getPartyFromName(this.nameBox.getValue());
            this.accept.active = p == null;
            return p == null;
        }
        return false;
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.render(gui, mouseX, mouseY, partialTicks);
        this.worldData = WorldData.getClient();
        this.struggle = this.worldData.getStruggleFromBlockPos(this.boardPos);
        int buttonX = (int)((double)this.width * 0.25);
        gui.drawString(this.minecraft.font, Utils.translateToLocal("Struggle name and size", new Object[0]), buttonX, (int)((double)this.height * 0.21), 0xFFFFFF);
        gui.drawString(this.minecraft.font, Utils.translateToLocal("Damage multiplier", new Object[0]), buttonX, (int)((double)this.height * 0.202) + 38, 0xFFFFFF);
    }
}

