/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.organization;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import online.kingdomkeys.kingdomkeys.api.event.EquipmentEvent;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.organization.WeaponTreeSelectionScreen;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.lib.Tags;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSummonKeyblade;
import online.kingdomkeys.kingdomkeys.network.cts.CSUnlockEquipOrgWeapon;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class WeaponUnlockScreen
extends Screen {
    PlayerData playerData;
    Utils.OrgMember member;
    Button cancel;
    Button next;
    Button prev;
    Button select;
    final int CANCEL = 2;
    final int NEXT = 3;
    final int PREV = 4;
    final int SELECT = 5;
    List<Item> weapons;
    int current = 0;
    private final ResourceLocation GLOW = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/org/glow.png");
    int startCost = 1000;
    boolean unlock = true;

    public WeaponUnlockScreen(Utils.OrgMember member) {
        super((Component)Component.literal((String)""));
        this.member = member;
        if (member == Utils.OrgMember.NONE) {
            throw new IllegalStateException("Tried to open Weapon Unlock screen with no Org Member");
        }
        this.weapons = Minecraft.getInstance().level.registryAccess().lookupOrThrow(Registries.ITEM).getOrThrow(Tags.getTagForMember(member)).stream().map(Holder::value).toList();
        this.playerData = PlayerData.get((Player)Minecraft.getInstance().player);
    }

    protected void renderBlurredBackground(float pPartialTick) {
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (deltaY > 0.0 && this.prev.visible) {
            this.actionPerformed(4);
            return true;
        }
        if (deltaY < 0.0 && this.next.visible) {
            this.actionPerformed(3);
            return true;
        }
        return false;
    }

    public void render(@NotNull GuiGraphics gui, int p_render_1_, int p_render_2_, float p_render_3_) {
        PoseStack matrixStack = gui.pose();
        int cost = (int)((double)this.startCost + 0.1 * (double)this.startCost * (double)this.current);
        this.renderBackground(gui, p_render_1_, p_render_2_, p_render_3_);
        String name = "";
        String weapon = "";
        int weapon_w = 128;
        int weapon_h = 128;
        this.renderBackground(gui, p_render_1_, p_render_2_, p_render_3_);
        matrixStack.pushPose();
        RenderSystem.enableBlend();
        gui.blit(this.GLOW, this.width / 2 - 128 - 5, this.height / 2 - 128, 0, 0, 256, 256);
        gui.drawString(this.font, new ItemStack((ItemLike)this.weapons.get(this.current)).getHoverName().getString(), this.width / 2 - 128 - 5, this.height / 2 - 120, 0xFFFFFF);
        gui.drawString(this.font, "Hearts Cost: " + cost, this.width / 2 - 128 - 5, this.height / 2 - 110, 0xFF0000);
        gui.drawString(this.font, "Current Hearts: " + this.playerData.getHearts(), this.width / 2 - 128 - 5, this.height / 2 - 100, 0xFF0000);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate((float)(this.width / 2 - 128 - 5 + 94), (float)(this.height / 2 - 128 + 88), 0.0f);
        matrixStack.scale(5.0f, 5.0f, 5.0f);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ClientUtils.drawItemAsIcon(new ItemStack((ItemLike)this.weapons.get(this.current)), matrixStack, 0, 0, 16);
        matrixStack.popPose();
        super.render(gui, p_render_1_, p_render_2_, p_render_3_);
    }

    protected void init() {
        super.init();
        this.cancel = Button.builder((Component)Component.translatable((String)"Back"), e -> this.actionPerformed(2)).bounds(0, 0, 50, 20).build();
        this.addRenderableWidget((GuiEventListener)this.cancel);
        this.next = Button.builder((Component)Component.literal((String)">"), e -> this.actionPerformed(3)).bounds(0, 0, 20, 20).build();
        this.addRenderableWidget((GuiEventListener)this.next);
        this.prev = Button.builder((Component)Component.literal((String)"<"), e -> this.actionPerformed(4)).bounds(0, 0, 20, 20).build();
        this.addRenderableWidget((GuiEventListener)this.prev);
        this.select = Button.builder((Component)Component.translatable((String)"Unlock"), e -> this.actionPerformed(5)).bounds(0, 0, 50, 20).build();
        this.addRenderableWidget((GuiEventListener)this.select);
        this.updateButtons();
    }

    public boolean isPauseScreen() {
        return false;
    }

    void actionPerformed(int ID) {
        switch (ID) {
            case 2: {
                Minecraft.getInstance().setScreen((Screen)new WeaponTreeSelectionScreen(this.member));
                break;
            }
            case 3: {
                if (this.current == this.weapons.size() - 1) {
                    this.current = 0;
                    break;
                }
                ++this.current;
                break;
            }
            case 4: {
                if (this.current == 0) {
                    this.current = this.weapons.size() - 1;
                    break;
                }
                --this.current;
                break;
            }
            case 5: {
                ItemStack weapon = new ItemStack((ItemLike)this.weapons.get(this.current));
                this.playerData.getWeaponsUnlocked().forEach(itemStack -> {
                    if (itemStack.is(weapon.getItem())) {
                        weapon.applyComponents(itemStack.getComponents());
                    }
                });
                if (this.unlock) {
                    this.playerData.unlockWeapon(weapon);
                    int cost = (int)((double)this.startCost + 0.1 * (double)this.startCost * (double)this.current);
                    this.playerData.removeHearts(cost);
                    PacketHandler.sendToServer(new CSUnlockEquipOrgWeapon(weapon, cost));
                    break;
                }
                if (((EquipmentEvent.OrgWeapon)NeoForge.EVENT_BUS.post((Event)new EquipmentEvent.OrgWeapon((Player)this.minecraft.player, this.playerData.getEquippedWeapon(), weapon))).isCanceled()) break;
                this.playerData.equipWeapon(weapon);
                if (Utils.findSummoned(this.minecraft.player.getInventory(), this.playerData.getEquippedWeapon()) > -1) {
                    PacketHandler.sendToServer(new CSSummonKeyblade(true));
                }
                PacketHandler.sendToServer(new CSUnlockEquipOrgWeapon(weapon));
            }
        }
        this.updateButtons();
    }

    public Item getStarterWeapon(Utils.OrgMember member) {
        return Tags.getFirstItemInTag((Level)Minecraft.getInstance().level, Tags.getTagForMember(member));
    }

    public boolean canUnlock() {
        int cost = (int)((double)this.startCost + 0.1 * (double)this.startCost * (double)this.current);
        if (this.playerData.getHearts() >= cost) {
            if (this.current == 0) {
                Utils.OrgMember rightMember = this.member == Utils.OrgMember.ROXAS ? Utils.OrgMember.XEMNAS : Utils.OrgMember.values()[this.member.ordinal() + 1];
                Utils.OrgMember leftMember = this.member == Utils.OrgMember.XEMNAS ? Utils.OrgMember.ROXAS : Utils.OrgMember.values()[this.member.ordinal() - 1];
                if (this.playerData.isWeaponUnlocked(this.getStarterWeapon(leftMember))) {
                    return true;
                }
                return this.playerData.isWeaponUnlocked(this.getStarterWeapon(rightMember));
            }
            return this.playerData.isWeaponUnlocked(this.weapons.get(this.current - 1));
        }
        return false;
    }

    public void updateButtons() {
        if (this.playerData.isWeaponUnlocked(this.weapons.get(this.current))) {
            this.unlock = false;
            this.select.setMessage((Component)Component.translatable((String)"Equip"));
            if (this.playerData.getEquippedWeapon().getItem() == this.weapons.get(this.current)) {
                this.select.active = false;
                this.select.setMessage((Component)Component.translatable((String)"Equipped"));
            } else {
                this.select.active = true;
                this.select.setMessage((Component)Component.translatable((String)"Equip"));
            }
        } else {
            this.unlock = true;
            this.select.setMessage((Component)Component.translatable((String)"Unlock"));
            this.select.active = this.canUnlock();
        }
        this.next.visible = true;
        this.next.setX(this.width / 2 - this.next.getWidth() / 2 + 128);
        this.next.setY(this.height / 2 - this.next.getHeight() / 2);
        this.prev.visible = true;
        this.prev.setX(this.width / 2 - this.prev.getWidth() / 2 - 128);
        this.prev.setY(this.height / 2 - this.prev.getHeight() / 2);
        this.select.visible = true;
        this.select.setX(this.width / 2 - this.select.getWidth() / 2);
        this.select.setY(this.height / 2 - this.select.getHeight() / 2 + 90);
        this.cancel.visible = true;
        this.cancel.setX(this.width / 2 - this.select.getWidth() / 2);
        this.cancel.setY(this.height / 2 - this.select.getHeight() / 2 + 115);
    }
}

