/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.entity.block.CardDoorTileEntity;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.DoorData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomDirection;

public class COMinimap
extends OverlayBase {
    public static final LayeredDraw.Layer INSTANCE = new COMinimap();
    public static List<RoomData> rooms = new ArrayList<RoomData>();

    private COMinimap() {
    }

    @Override
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        super.render(guiGraphics, deltaTracker);
        if (!rooms.isEmpty()) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(200.0f, 200.0f, 0.0f);
            guiGraphics.pose().scale(4.0f, 4.0f, 4.0f);
            for (int i = 0; i < rooms.size(); ++i) {
                RoomData roomData = rooms.get(i);
                int roomColor = Color.RED.getRGB();
                guiGraphics.fill(-roomData.pos.x() * 2, -roomData.pos.y() * 2, -roomData.pos.x() * 2 + 1, -roomData.pos.y() * 2 + 1, roomColor);
                if (roomData.getGenerated() != null && this.minecraft.player.getX() >= (double)roomData.getGenerated().getPosition().getX() && this.minecraft.player.getX() < (double)(roomData.getGenerated().getPosition().getX() + 64) && this.minecraft.player.getZ() >= (double)roomData.getGenerated().getPosition().getZ() && this.minecraft.player.getZ() < (double)(roomData.getGenerated().getPosition().getZ() + 64)) {
                    guiGraphics.pose().pushPose();
                    float rotationDegrees = Mth.wrapDegrees((float)this.minecraft.player.getYRot());
                    guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(rotationDegrees));
                    ClientUtils.drawItemAsIcon(new ItemStack((ItemLike)ModItems.k111.get()), guiGraphics.pose(), 0, 0, 1);
                    guiGraphics.pose().popPose();
                }
                roomData.getDoors().forEach((direction, doorData) -> {
                    if (doorData.getType() != DoorData.Type.NONE) {
                        CardDoorTileEntity te;
                        int offsetY = 0;
                        int offsetX = 0;
                        switch (direction) {
                            case NORTH: {
                                offsetY = 1;
                                break;
                            }
                            case SOUTH: {
                                offsetY = -1;
                                break;
                            }
                            case EAST: {
                                offsetX = -1;
                                break;
                            }
                            case WEST: {
                                offsetX = 1;
                            }
                        }
                        boolean open = false;
                        if (roomData.getGenerated() != null && (te = roomData.getGenerated().getDoorTE((Level)this.minecraft.level, (RoomDirection)((Object)direction))) != null) {
                            open = te.isOpen();
                        }
                        int colour = open ? Color.GREEN.getRGB() : Color.YELLOW.getRGB();
                        guiGraphics.fill(-roomData.pos.x() * 2 - offsetX, -roomData.pos.y() * 2 - offsetY, -roomData.pos.x() * 2 + 1 - offsetX, -roomData.pos.y() * 2 + 1 - offsetY, colour);
                    }
                });
            }
            guiGraphics.pose().popPose();
        }
    }
}

