/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.client.gui.elements.CommandMenuItem;
import online.kingdomkeys.kingdomkeys.client.gui.elements.CommandMenuSubMenu;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.handler.EntityEvents;
import online.kingdomkeys.kingdomkeys.handler.InputHandler;
import online.kingdomkeys.kingdomkeys.item.KKPotionItem;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.item.organization.ArrowgunItem;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.PortalData;
import online.kingdomkeys.kingdomkeys.limit.Limit;
import online.kingdomkeys.kingdomkeys.limit.ModLimits;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSpawnOrgPortalPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSSummonKeyblade;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseDriveFormPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseItemPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseLimitPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseMagicPacket;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CommandMenuGui
extends OverlayBase {
    public static final CommandMenuGui INSTANCE = new CommandMenuGui();
    public static Map<ResourceLocation, CommandMenuSubMenu> commandMenuElements;
    int TOP_WIDTH = 70;
    int TOP_HEIGHT = 15;
    int MENU_WIDTH = 71;
    int MENU_HEIGHT = 15;
    int iconWidth = 10;
    int textX = 0;
    public static final int NONE = 0;
    public static int reactionSelected;
    public final ResourceLocation root = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"root");
    public final ResourceLocation attack = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"attack");
    public final ResourceLocation magic = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"magic");
    public final ResourceLocation items = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"items");
    public final ResourceLocation drive = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"drive");
    public final ResourceLocation portals = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"portals");
    public final ResourceLocation target;
    public final ResourceLocation limit = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"limit");
    public final ResourceLocation revert;
    public ResourceLocation currentSubmenu;

    private CommandMenuGui() {
        this.target = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"target");
        this.revert = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"revert");
        this.currentSubmenu = this.root;
        commandMenuElements = new HashMap<ResourceLocation, CommandMenuSubMenu>();
        CommandMenuSubMenu rootSubmenu = new CommandMenuSubMenu.Builder(this.root, (Component)Component.translatable((String)"gui.commandmenu.command")).position(ModConfigs.cmXPos, Minecraft.getInstance().getWindow().getGuiScaledHeight()).openByDefault().changesColour().fixedHeader().colour(new Color(10, 51, 255)).onUpdate((subMenu, guiGraphics) -> subMenu.updatePosition(ModConfigs.cmXPos, Minecraft.getInstance().getWindow().getGuiScaledHeight())).withChildren(new CommandMenuItem.Builder(this.attack, (Component)Component.translatable((String)"gui.commandmenu.attack"), null).onUpdate((item, guiGraphics) -> this.updateRootItem(item, null, guiGraphics)).iconUV(30, 60), new CommandMenuItem.Builder(this.portals, (Component)Component.translatable((String)"gui.commandmenu.portal"), this.opensSubmenu(this.portals)).invisibleByDefault().onUpdate((item, guiGraphics) -> this.updateRootItem(item, this.portals, guiGraphics)).iconUV(40, 60), new CommandMenuItem.Builder(this.magic, (Component)Component.translatable((String)"gui.commandmenu.magic"), this.opensSubmenu(this.magic)).onUpdate((item, guiGraphics) -> this.updateRootItem(item, this.magic, guiGraphics)).iconUV(20, 60), new CommandMenuItem.Builder(this.items, (Component)Component.translatable((String)"gui.commandmenu.items"), this.opensSubmenu(this.items)).onUpdate((item, guiGraphics) -> this.updateRootItem(item, this.items, guiGraphics)).iconUV(10, 60), new CommandMenuItem.Builder(this.drive, (Component)Component.translatable((String)"gui.commandmenu.drive"), this.opensSubmenu(this.drive)).onUpdate((item, guiGraphics) -> this.updateRootItem(item, this.drive, guiGraphics)).iconUV(0, 60), new CommandMenuItem.Builder(this.revert, (Component)Component.translatable((String)"gui.commandmenu.revert"), item -> {
            PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
            if (playerData.getActiveDriveForm().equals("kingdomkeys:form_anti") && !playerData.isAbilityEquipped("kingdomkeys:ability_dark_domination") && EntityEvents.isHostiles) {
                this.playErrorSound();
            } else {
                PacketHandler.sendToServer(new CSUseDriveFormPacket(DriveForm.NONE.toString()));
                this.playSound((SoundEvent)ModSounds.unsummon.get());
            }
        }).invisibleByDefault().onUpdate((item, guiGraphics) -> {
            if (item.isVisible() && PlayerData.get((Player)this.minecraft.player).getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                item.setVisible(false);
                item.getParent().getChild(this.drive).setVisible(true);
            }
        }).iconUV(0, 60), new CommandMenuItem.Builder(this.limit, (Component)Component.translatable((String)"gui.commandmenu.limit"), this.opensSubmenu(this.limit)).invisibleByDefault().onUpdate((item, guiGraphics) -> this.updateRootItem(item, this.limit, guiGraphics)).iconUV(0, 60)).build();
        CommandMenuSubMenu magicSubmenu = new CommandMenuSubMenu.Builder(this.magic, (Component)Component.translatable((String)"gui.commandmenu.magic.title")).colour(new Color(102, 0, 255)).onUpdate(this.updateMagic()).withChildren(this.createMagicFromRegistry()).autoResizes().buildWithParent(rootSubmenu);
        CommandMenuSubMenu itemsSubmenu = new CommandMenuSubMenu.Builder(this.items, (Component)Component.translatable((String)"gui.commandmenu.items.title")).colour(new Color(77, 255, 77)).onOpen(this::createItems).autoResizes().buildWithParent(rootSubmenu);
        CommandMenuSubMenu targetSubmenu = new CommandMenuSubMenu.Builder(this.target, (Component)Component.translatable((String)"gui.commandmenu.target")).colour(new Color(10, 51, 255)).onOpen(this::createTargets).autoResizes().build();
        CommandMenuSubMenu portalsSubmenu = new CommandMenuSubMenu.Builder(this.portals, (Component)Component.translatable((String)"gui.commandmenu.portal.title")).colour(new Color(204, 204, 204)).onOpen(this::createPortals).autoResizes().buildWithParent(rootSubmenu);
        CommandMenuSubMenu limitSubmenu = new CommandMenuSubMenu.Builder(this.limit, (Component)Component.translatable((String)"gui.commandmenu.limit.title")).colour(new Color(255, 255, 0)).onUpdate(this.updateLimits()).withChildren(this.createLimitsFromRegistry()).autoResizes().buildWithParent(rootSubmenu);
        CommandMenuSubMenu driveSubmenu = new CommandMenuSubMenu.Builder(this.drive, (Component)Component.translatable((String)"gui.commandmenu.drive.title")).colour(new Color(0, 255, 255)).onUpdate(this.updateDriveForms()).withChildren(this.createDriveFormsFromRegistry()).autoResizes().buildWithParent(rootSubmenu);
    }

    private CommandMenuItem.OnEnter opensSubmenu(ResourceLocation subMenu) {
        return item -> {
            this.changeSubmenu(subMenu, true);
            this.playInSound();
        };
    }

    public CommandMenuSubMenu.OnUpdate updateMagic() {
        return (subMenu, guiGraphics) -> {
            AtomicInteger i = new AtomicInteger(0);
            HashMap magicList = new HashMap();
            PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
            ModConfigs.magicDisplayedInCommandMenu.stream().filter(m -> playerData.getMagicsMap().containsKey(m)).toList().forEach(s -> magicList.put(s, i.getAndIncrement()));
            subMenu.getChildren().forEach(item -> {
                item.setSorting(0.0);
                if (magicList.containsKey(item.getId().toString())) {
                    item.setSorting(((Integer)magicList.get(item.getId().toString())).intValue());
                    item.setMessage((Component)Component.translatable((String)((Magic)ModMagic.registry.get(item.getId())).getTranslationKey(playerData.getMagicLevel(item.getId()))));
                    item.setVisible(true);
                } else {
                    item.setVisible(false);
                }
            });
        };
    }

    public CommandMenuSubMenu.OnUpdate updateLimits() {
        return (subMenu, guiGraphics) -> {
            AtomicInteger i = new AtomicInteger(0);
            HashMap limits = new HashMap();
            PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
            Utils.getSortedLimits(Utils.getPlayerLimitAttacks((Player)this.minecraft.player)).forEach(limit -> limits.put(limit.getRegistryName().toString(), i.getAndIncrement()));
            subMenu.getChildren().forEach(item -> {
                item.setSorting(0.0);
                if (limits.containsKey(item.getId().toString())) {
                    item.setSorting(((Integer)limits.get(item.getId().toString())).intValue());
                    item.setVisible(true);
                } else {
                    item.setVisible(false);
                }
            });
        };
    }

    public CommandMenuSubMenu.OnUpdate updateDriveForms() {
        return (subMenu, guiGraphics) -> {
            AtomicInteger i = new AtomicInteger(0);
            HashMap formList = new HashMap();
            PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
            playerData.getDriveFormMap().forEach((s, ints) -> formList.put(s, ((DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)s))).getOrder()));
            subMenu.getChildren().forEach(item -> {
                item.setSorting(0.0);
                if (formList.containsKey(item.getId().toString())) {
                    item.setSorting(((Integer)formList.get(item.getId().toString())).intValue());
                    item.setVisible(((DriveForm)ModDriveForms.registry.get(item.getId())).displayInCommandMenu((Player)this.minecraft.player));
                } else {
                    item.setVisible(false);
                }
            });
        };
    }

    public CommandMenuItem.Builder[] createMagicFromRegistry() {
        ArrayList magic = new ArrayList();
        ModMagic.registry.forEach(magicRegistryObject -> magic.add(new CommandMenuItem.Builder(magicRegistryObject.getRegistryName(), (Component)Component.translatable((String)magicRegistryObject.getTranslationKey()), item -> {
            block4: {
                PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
                WorldData worldData = WorldData.getClient();
                int[] mag = playerData.getMagicsMap().get(magicRegistryObject.getRegistryName().toString());
                double cost = magicRegistryObject.getCost(mag[0], (Player)this.minecraft.player);
                if (playerData.getMaxMP() == 0.0 || playerData.getRecharge() || cost > playerData.getMaxMP() && cost < 300.0) {
                    this.playErrorSound();
                    this.changeSubmenu(this.root, true);
                    return;
                }
                if (worldData.getPartyFromMember(this.minecraft.player.getUUID()) != null && ((Magic)ModMagic.registry.get(magicRegistryObject.getRegistryName())).getHasToSelect()) {
                    if (this.currentSubmenu.equals((Object)this.target) && commandMenuElements.get(this.currentSubmenu).getSelected() != null) {
                        String target = commandMenuElements.get(this.currentSubmenu).getSelected().getId().getPath();
                        int level = playerData.getMagicLevel(magicRegistryObject.getRegistryName());
                        PacketHandler.sendToServer(new CSUseMagicPacket(magicRegistryObject.getRegistryName().toString(), target, level));
                        this.changeSubmenu(this.root, true);
                        break block4;
                    } else {
                        this.changeSubmenu(this.target, true);
                        this.playInSound();
                        return;
                    }
                }
                int level = playerData.getMagicLevel(magicRegistryObject.getRegistryName());
                PacketHandler.sendToServer(new CSUseMagicPacket(magicRegistryObject.getRegistryName().toString(), level, InputHandler.lockOn));
                this.changeSubmenu(this.root, true);
            }
            this.playSelectSound();
        }).onUpdate((item, guiGraphics) -> {
            PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
            Magic magicInst = (Magic)ModMagic.registry.get(item.getId());
            if (playerData.getMP() > 0.0 && !playerData.getRecharge()) {
                item.setActive(true);
                item.setTextColour(Color.WHITE);
                double magCost = magicInst.getCost(playerData.getMagicLevel(item.getId()), (Player)Minecraft.getInstance().player);
                if (playerData.getMP() <= magCost) {
                    if (playerData.getMaxMP() < magCost && magCost < 300.0) {
                        item.setTextColour(Color.GRAY);
                    } else if (playerData.isAbilityEquipped("kingdomkeys:ability_extra_cast")) {
                        if (magCost >= playerData.getMaxMP()) {
                            item.setTextColour(Color.ORANGE);
                        } else if (playerData.getMP() > 1.0 && playerData.getMP() - magCost < 1.0) {
                            item.setTextColour(Color.WHITE);
                        } else {
                            item.setTextColour(Color.ORANGE);
                        }
                    } else {
                        item.setTextColour(Color.ORANGE);
                    }
                }
            } else {
                item.setTextColour(Color.WHITE);
                item.setActive(false);
            }
        }).iconUV(160, 60)));
        return magic.toArray(new CommandMenuItem.Builder[0]);
    }

    public CommandMenuItem.Builder[] createDriveFormsFromRegistry() {
        ArrayList forms = new ArrayList();
        ModDriveForms.registry.stream().forEach(driveFormRegistryObject -> forms.add(new CommandMenuItem.Builder(driveFormRegistryObject.getRegistryName(), (Component)Component.translatable((String)driveFormRegistryObject.getTranslationKey()), item -> {
            PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
            if (playerData.getDP() >= (double)driveFormRegistryObject.getDriveCost()) {
                if (!this.antiFormCheck(playerData, (DriveForm)driveFormRegistryObject)) {
                    PacketHandler.sendToServer(new CSUseDriveFormPacket(driveFormRegistryObject.getRegistryName().toString()));
                }
                this.changeSubmenu(this.root, true);
                this.playInSound();
            } else {
                this.playErrorSound();
            }
        }).onUpdate((item, guiGraphics) -> {
            PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
            DriveForm form = (DriveForm)ModDriveForms.registry.get(item.getId());
            item.setActive(playerData.getDP() >= (double)form.getDriveCost());
        }).iconUV(0, 60)));
        return forms.toArray(new CommandMenuItem.Builder[0]);
    }

    public CommandMenuItem.Builder[] createLimitsFromRegistry() {
        ArrayList limits = new ArrayList();
        ModLimits.registry.forEach(limitRegistryObject -> limits.add(new CommandMenuItem.Builder(limitRegistryObject.getRegistryName(), (Component)Component.translatable((String)limitRegistryObject.getTranslationKey()), item -> {
            PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
            if (playerData.getDP() < (double)limitRegistryObject.getCost()) {
                this.playErrorSound();
            } else {
                if (InputHandler.lockOn != null) {
                    PacketHandler.sendToServer(new CSUseLimitPacket(limitRegistryObject.getRegistryName(), InputHandler.lockOn.getId()));
                } else {
                    PacketHandler.sendToServer(new CSUseLimitPacket(limitRegistryObject.getRegistryName()));
                }
                this.changeSubmenu(this.root, true);
                this.playInSound();
            }
        }).onUpdate((item, guiGraphics) -> {
            PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
            if (playerData.getLimitCooldownTicks() > 0) {
                item.setActive(false);
                return;
            }
            item.setActive(true);
            Limit limit = (Limit)ModLimits.registry.get(item.getId());
            item.setMessage((Component)Component.literal((String)(Component.translatable((String)limit.getTranslationKey()).getString() + "  ")));
            item.setActive(playerData.getDP() >= (double)limit.getCost());
            if (item.getParent().isVisible()) {
                String cost = String.valueOf(((Limit)ModLimits.registry.get(item.getId())).getCost() / 100);
                this.drawString(guiGraphics, this.font, cost, item.getX() + item.getWidth() - this.font.width(cost) - 16, item.getY() + 4, item.isActive() ? new Color(0, 255, 255).getRGB() : new Color(0, 255, 255).darker().darker().getRGB());
            }
        }).iconUV(0, 60)));
        return limits.toArray(new CommandMenuItem.Builder[0]);
    }

    public boolean isOrgMode() {
        return PlayerData.get((Player)this.minecraft.player).getAlignment() != Utils.OrgMember.NONE;
    }

    public void updateRootItem(CommandMenuItem item, ResourceLocation submenu, GuiGraphics guiGraphics) {
        ItemStack weapon;
        PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
        if (item.getId().equals((Object)this.portals) && this.isOrgMode() && item.getParent().getSelected().equals(item) && this.minecraft.player.getMainHandItem() != null && this.minecraft.player.getMainHandItem().getItem() instanceof ArrowgunItem && (weapon = this.minecraft.player.getMainHandItem()).has(ModComponents.ARROWGUN_AMMO)) {
            int ammo = (Integer)weapon.getOrDefault(ModComponents.ARROWGUN_AMMO, (Object)0);
            this.drawString(guiGraphics, this.minecraft.font, "" + ammo, item.getX() + 8 + (int)((double)item.getParent().getWidth() * ((double)ModConfigs.cmXScale / 100.0)), item.getY() + 4, 0xFFFFFF);
        }
        if (item.getId().equals((Object)this.attack) || item.getId().equals((Object)this.drive)) {
            item.setVisible(!this.isOrgMode());
        } else if (item.getId().equals((Object)this.portals) || item.getId().equals((Object)this.limit)) {
            item.setVisible(this.isOrgMode());
        }
        if (submenu == null) {
            item.setActive(true);
            return;
        }
        if (item.getId().equals((Object)this.magic)) {
            item.setTextColour(Color.WHITE);
            if (!playerData.getMagicsMap().isEmpty() && (playerData.getRecharge() || playerData.getMaxMP() < Utils.getCheapestMagicCost(playerData.getMagicsMap(), (Player)this.minecraft.player)) && playerData.getMagicCooldownTicks() <= 0) {
                item.setTextColour(Color.GRAY);
            }
            DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)playerData.getActiveDriveForm()));
            if (playerData.getMagicCooldownTicks() > 0 || !form.canUseMagic()) {
                item.setActive(false);
                return;
            }
            if (playerData.getMagicsMap().isEmpty()) {
                item.setActive(false);
                item.setMessage((Component)Component.literal((String)"???"));
            } else {
                item.setActive(true);
                item.setMessage((Component)Component.translatable((String)"gui.commandmenu.magic"));
            }
        }
        if (item.getId().equals((Object)this.drive)) {
            if (playerData.getDriveFormMap().size() < 4) {
                item.setActive(false);
                item.setMessage((Component)Component.literal((String)"???"));
            } else {
                item.setActive(true);
                Color color = playerData.getDP() >= (double)Utils.getCheapestDriveCost(playerData, Utils.getVisibleDriveForms((Player)this.minecraft.player)) ? Color.WHITE : Color.GRAY;
                item.setTextColour(color);
                item.setMessage((Component)Component.translatable((String)"gui.commandmenu.drive"));
            }
            if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                item.setVisible(false);
                item.getParent().getChild(this.revert).setVisible(true);
            }
        }
        if (item.getId().equals((Object)this.limit) && playerData.getLimitCooldownTicks() > 0) {
            item.setActive(false);
            return;
        }
        if (commandMenuElements.containsKey(submenu)) {
            if (submenu.equals((Object)this.items)) {
                item.setActive(false);
                playerData.getEquippedItems().forEach((integer, stack) -> {
                    if (!stack.isEmpty()) {
                        item.setActive(true);
                    }
                });
                return;
            }
            if (submenu.equals((Object)this.portals)) {
                item.setActive(!WorldData.getClient().getAllPortalsFromOwnerID(this.minecraft.player.getUUID()).isEmpty());
                return;
            }
            if (!commandMenuElements.get(submenu).getVisibleChildren().isEmpty()) {
                item.setActive(true);
                return;
            }
        }
        item.setActive(false);
    }

    public void createTargets(CommandMenuSubMenu subMenu) {
        subMenu.getChildren().clear();
        WorldData worldData = WorldData.getClient();
        if (worldData.getPartyFromMember(this.minecraft.player.getUUID()) != null) {
            subMenu.addChild(new CommandMenuItem.Builder(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)this.minecraft.player.getDisplayName().getString().toLowerCase()), (Component)Component.translatable((String)this.minecraft.player.getDisplayName().getString()), item -> subMenu.getParent().getSelected().onEnter()).build(subMenu));
            List<Party.Member> targets = worldData.getPartyFromMember(this.minecraft.player.getUUID()).getMembers();
            targets.stream().filter(member -> !member.getUsername().equals(this.minecraft.player.getDisplayName().getString())).filter(member -> {
                if (this.minecraft.player.level().getPlayerByUUID(member.getUUID()) == null) {
                    return false;
                }
                Player playerAlly = this.minecraft.player.level().getPlayerByUUID(member.getUUID());
                return this.minecraft.player.distanceTo((Entity)playerAlly) <= (float)((Integer)ModConfigs.SERVER.partyRangeLimit.get()).intValue();
            }).forEach(member -> subMenu.addChild(new CommandMenuItem.Builder(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)member.getUsername().toLowerCase()), (Component)Component.translatable((String)member.getUsername()), item -> subMenu.getParent().getSelected().onEnter()).build(subMenu)));
        }
    }

    public void createPortals(CommandMenuSubMenu subMenu) {
        subMenu.getChildren().clear();
        WorldData worldData = WorldData.getClient();
        worldData.getAllPortalsFromOwnerID(this.minecraft.player.getUUID()).forEach(uuid -> {
            PortalData portalData = worldData.getPortalFromUUID((UUID)uuid);
            String rlUUID = uuid.toString().replaceAll("-", "_");
            subMenu.addChild(new CommandMenuItem.Builder(ResourceLocation.parse((String)rlUUID), (Component)Component.translatable((String)portalData.getName()), item -> {
                PortalData portal = worldData.getPortalFromUUID(UUID.fromString(item.getId().getPath().replaceAll("_", "-")));
                if (!portal.getPos().equals((Object)new BlockPos(0, 0, 0))) {
                    this.summonPortal(portal);
                } else {
                    this.minecraft.player.sendSystemMessage((Component)Component.translatable((String)(String.valueOf(ChatFormatting.RED) + "You don't have any portal destinations")));
                }
                this.changeSubmenu(this.root, true);
                this.playInSound();
            }).iconUV(40, 60).build(subMenu));
        });
    }

    public void summonPortal(PortalData coords) {
        BlockPos destination = coords.getPos();
        if (this.minecraft.player.isShiftKeyDown()) {
            PacketHandler.sendToServer(new CSSpawnOrgPortalPacket(this.minecraft.player.blockPosition(), destination, coords.getDimID()));
        } else {
            HitResult rtr = InputHandler.getMouseOverExtended(100.0f);
            if (rtr != null) {
                EntityHitResult ertr;
                double distanceSq;
                double reachSq;
                if (rtr instanceof BlockHitResult) {
                    double reachSq2 = 10000.0;
                    BlockHitResult brtr = (BlockHitResult)rtr;
                    double distanceSq2 = this.minecraft.player.distanceToSqr((double)brtr.getBlockPos().getX(), (double)brtr.getBlockPos().getY(), (double)brtr.getBlockPos().getZ());
                    if (reachSq2 >= distanceSq2) {
                        PacketHandler.sendToServer(new CSSpawnOrgPortalPacket(brtr.getBlockPos().above(), destination, coords.getDimID()));
                    }
                } else if (rtr instanceof EntityHitResult && (reachSq = 10000.0) >= (distanceSq = this.minecraft.player.distanceToSqr((ertr = (EntityHitResult)rtr).getEntity().getX(), ertr.getEntity().getY(), ertr.getEntity().getZ()))) {
                    PacketHandler.sendToServer(new CSSpawnOrgPortalPacket(ertr.getEntity().blockPosition(), destination, coords.getDimID()));
                }
            }
        }
    }

    public void createItems(CommandMenuSubMenu subMenu) {
        subMenu.getChildren().clear();
        PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
        WorldData worldData = WorldData.getClient();
        playerData.getEquippedItems().forEach((integer, stack) -> {
            if (!stack.isEmpty()) {
                subMenu.addChild(new CommandMenuItem.Builder(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)integer.toString()), (Component)Component.literal((String)stack.getDisplayName().getString().substring(1, stack.getDisplayName().getString().length() - 1)), item -> {
                    Item patt0$temp = stack.getItem();
                    if (patt0$temp instanceof KKPotionItem) {
                        KKPotionItem potion = (KKPotionItem)patt0$temp;
                        Party party = worldData.getPartyFromMember(this.minecraft.player.getUUID());
                        if (potion.isGlobal() || party == null) {
                            PacketHandler.sendToServer(new CSUseItemPacket((int)integer));
                        } else if (this.currentSubmenu.equals((Object)this.target) && commandMenuElements.get(this.currentSubmenu).getSelected() != null) {
                            String target = commandMenuElements.get(this.currentSubmenu).getSelected().getId().getPath();
                            PacketHandler.sendToServer(new CSUseItemPacket((int)integer, target));
                        } else {
                            this.changeSubmenu(this.target, true);
                            this.playInSound();
                            return;
                        }
                        this.changeSubmenu(this.root, true);
                        this.playSelectSound();
                    } else {
                        this.playErrorSound();
                    }
                }).iconUV(10, 60).build(subMenu));
            }
        });
    }

    public void playSelectSound() {
        this.playSound((SoundEvent)ModSounds.menu_select.get());
    }

    public void playMoveSound() {
        this.playSound((SoundEvent)ModSounds.menu_move.get());
    }

    public void playBackSound() {
        this.playSound((SoundEvent)ModSounds.menu_back.get());
    }

    public void playInSound() {
        this.playSound((SoundEvent)ModSounds.menu_in.get());
    }

    public void playErrorSound() {
        this.playSound((SoundEvent)ModSounds.error.get());
    }

    public void playSound(SoundEvent sound) {
        LocalPlayer player = Minecraft.getInstance().player;
        Minecraft.getInstance().level.playSound((Player)player, player.position().x(), player.position().y(), player.position().z(), sound, SoundSource.MASTER, 1.0f, 1.0f);
    }

    public void changeSubmenu(ResourceLocation submenu, boolean resetSelected) {
        commandMenuElements.forEach((resourceLocation, subMenu) -> subMenu.setActive(false));
        CommandMenuSubMenu newSubmenu = commandMenuElements.get(submenu);
        CommandMenuSubMenu currentSubMenu = commandMenuElements.get(this.currentSubmenu);
        if (submenu.equals((Object)this.root)) {
            commandMenuElements.forEach((resourceLocation, subMenu) -> {
                if (!resourceLocation.equals((Object)this.root)) {
                    subMenu.setVisible(false);
                }
            });
        }
        if (submenu.equals((Object)this.target)) {
            commandMenuElements.get(submenu).setParent(commandMenuElements.get(this.currentSubmenu));
        }
        if (currentSubMenu.getParent() != null && currentSubMenu.getParent().getId().equals((Object)submenu)) {
            currentSubMenu.setVisible(false);
        }
        if (newSubmenu != null) {
            newSubmenu.close();
            newSubmenu.setActive(true);
            newSubmenu.onOpen();
            if (newSubmenu.visibleSize() > 0) {
                if (!this.currentSubmenu.equals((Object)this.root)) {
                    newSubmenu.setVisible(false);
                }
                if (resetSelected) {
                    newSubmenu.setSelected(newSubmenu.getFirst());
                }
                newSubmenu.setVisible(true);
                this.currentSubmenu = submenu;
            } else {
                newSubmenu.setActive(false);
            }
        }
    }

    public boolean antiFormCheck(PlayerData playerData, DriveForm driveForm) {
        if (!driveForm.canGoAnti()) {
            return false;
        }
        if (playerData.isAbilityEquipped("kingdomkeys:ability_dark_domination")) {
            return false;
        }
        if (playerData.isAbilityEquipped("kingdomkeys:ability_light_and_darkness")) {
            PacketHandler.sendToServer(new CSSummonKeyblade(true));
            PacketHandler.sendToServer(new CSUseDriveFormPacket("kingdomkeys:form_anti"));
            this.playSound((SoundEvent)ModSounds.antidrive.get());
            this.changeSubmenu(this.root, true);
            this.playSelectSound();
            return true;
        }
        double random = Math.random();
        int ap = playerData.getAntiPoints();
        int prob = 0;
        if (ap > 0 && ap <= 4) {
            prob = 0;
        } else if (ap > 4 && ap <= 9) {
            prob = 10;
        } else if (ap >= 10) {
            prob = 25;
        }
        if (random * 100.0 < (double)prob) {
            PacketHandler.sendToServer(new CSUseDriveFormPacket("kingdomkeys:form_anti"));
            this.playSound((SoundEvent)ModSounds.antidrive.get());
            this.changeSubmenu(this.root, true);
            this.playSelectSound();
            return true;
        }
        return false;
    }

    @Override
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        super.render(guiGraphics, deltaTracker);
        if (this.minecraft.player != null) {
            this.drawReactionCommands(guiGraphics, deltaTracker);
            List<CommandMenuSubMenu> submenus = commandMenuElements.values().stream().sorted(Comparator.comparingInt(CommandMenuSubMenu::getZ)).toList();
            submenus.forEach(submenu -> {
                submenu.render(guiGraphics, this.minecraft.getWindow().getGuiScaledWidth(), this.minecraft.getWindow().getGuiScaledHeight(), deltaTracker.getGameTimeDeltaPartialTick(true));
                submenu.onUpdate(guiGraphics);
            });
        }
    }

    public static void down() {
        INSTANCE.playMoveSound();
        commandMenuElements.get(CommandMenuGui.INSTANCE.currentSubmenu).next();
    }

    public static void up() {
        INSTANCE.playMoveSound();
        commandMenuElements.get(CommandMenuGui.INSTANCE.currentSubmenu).prev();
    }

    public static void enter() {
        commandMenuElements.get(CommandMenuGui.INSTANCE.currentSubmenu).getSelected().onEnter();
    }

    public static void cancel() {
        commandMenuElements.get(CommandMenuGui.INSTANCE.currentSubmenu).getSelected().onCancel();
    }

    public void drawReactionCommands(GuiGraphics gui, DeltaTracker deltaTracker) {
        float alpha = 1.0f;
        float scale = 1.05f;
        PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
        List<String> list = playerData.getReactionCommands();
        for (int i = 0; i < list.size(); ++i) {
            gui.pose().pushPose();
            float shade = i == reactionSelected ? 1.0f : 0.4f;
            RenderSystem.setShaderColor((float)shade, (float)shade, (float)shade, (float)alpha);
            gui.pose().translate(0.0f, (float)(commandMenuElements.get(this.currentSubmenu).getY() - 20 - 16 * i), 0.5f);
            gui.pose().scale(scale, scale, scale);
            gui.pose().pushPose();
            ReactionCommand command = (ReactionCommand)ModReactionCommands.registry.get(ResourceLocation.parse((String)list.get(i)));
            this.drawString(gui, this.minecraft.font, Utils.translateToLocal(command.getTranslationKey(), new Object[0]), (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + (ModConfigs.cmTextXOffset + 5), 4, 0xFFFFFF);
            gui.pose().scale((float)ModConfigs.cmXScale / 75.0f, 1.0f, 1.0f);
            RenderSystem.enableBlend();
            this.blit(gui, commandMenuElements.get(this.currentSubmenu).getTexture(), 0, 0, 0, 45, ModConfigs.cmReactionEndLWidth, this.TOP_HEIGHT);
            this.blit(gui, commandMenuElements.get(this.currentSubmenu).getTexture(), ModConfigs.cmReactionEndLWidth, 0, this.TOP_WIDTH - (ModConfigs.cmReactionEndLWidth + ModConfigs.cmReactionEndRWidth), this.TOP_HEIGHT, ModConfigs.cmReactionEndLWidth + 1, 45, 1, this.TOP_HEIGHT, 256, 256);
            this.blit(gui, commandMenuElements.get(this.currentSubmenu).getTexture(), this.TOP_WIDTH - ModConfigs.cmReactionEndRWidth, 0, ModConfigs.cmReactionEndLWidth + 3, 45, ModConfigs.cmReactionEndRWidth, this.TOP_HEIGHT);
            RenderSystem.disableBlend();
            gui.pose().popPose();
            gui.pose().popPose();
        }
    }

    static {
        reactionSelected = 0;
    }
}

