/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class GuiOverlay
extends OverlayBase {
    public static final GuiOverlay INSTANCE = new GuiOverlay();
    public static boolean showExp;
    public static boolean showMunny;
    public static List<LevelUpData> levelUpList;
    public static LevelUpData driveLevelData;
    public static boolean showDriveLevelUp;
    public static String driveForm;
    public static UUID playerWhoLevels;
    public static long timeExp;
    public static long timeMunny;
    public static long timeLevelUp;
    public static long timeDriveLevelUp;
    public static int munnyGet;
    int levelSeconds = 6;
    int width;
    int sHeight;
    PlayerData playerData;
    ResourceLocation levelUpTexture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/levelup.png");
    ResourceLocation menuTexture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/menu/menu_button.png");
    public static float notifTicks;
    public static float prevNotifTicks;
    public static float driveNotifTicks;
    public static float prevDriveNotifTicks;

    @Override
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        super.render(guiGraphics, deltaTracker);
        this.width = this.minecraft.getWindow().getGuiScaledWidth();
        this.sHeight = this.minecraft.getWindow().getGuiScaledHeight();
        this.playerData = PlayerData.get((Player)this.minecraft.player);
        if (this.playerData != null) {
            if (showExp) {
                this.showExp(guiGraphics);
            }
            if (showMunny) {
                this.showMunny(guiGraphics);
            }
            int lvlCounter = 0;
            Iterator<LevelUpData> it = levelUpList.iterator();
            while (it.hasNext()) {
                this.showLevelUp(guiGraphics, deltaTracker, lvlCounter++);
                LevelUpData actual = it.next();
                if (System.currentTimeMillis() / 1000L <= actual.timeLevelUp + (long)this.levelSeconds) continue;
                it.remove();
            }
            if (showDriveLevelUp) {
                this.showDriveLevelUp(guiGraphics, deltaTracker);
            }
        }
    }

    private void showExp(GuiGraphics gui) {
        if (this.playerData != null) {
            String reqExp = String.valueOf(this.playerData.getExpNeeded(this.playerData.getLevel(), this.playerData.getExperience()));
            this.drawString(gui, this.minecraft.font, Utils.translateToLocal("stats.levelNext", new Object[0]), 5, 5, 0xFFFFFF);
            Font font = this.minecraft.font;
            Objects.requireNonNull(this.minecraft.font);
            this.drawString(gui, font, reqExp, 5, 5 + 9, 0xFFFFFF);
            if (System.currentTimeMillis() / 1000L > timeExp + 4L) {
                showExp = false;
            }
        }
    }

    private void showMunny(GuiGraphics gui) {
        PoseStack matrixStack = gui.pose();
        int heightOffsetText = 0;
        int heightOffsetNum = 0;
        if (!showExp) {
            matrixStack.pushPose();
            matrixStack.translate(1.0f, 1.0f, 0.0f);
            heightOffsetText = 0;
            Objects.requireNonNull(this.minecraft.font);
            heightOffsetNum = 9;
            matrixStack.popPose();
        } else {
            Objects.requireNonNull(this.minecraft.font);
            heightOffsetText = 9 + 10;
            Objects.requireNonNull(this.minecraft.font);
            heightOffsetNum = 9 * 2 + 10;
        }
        this.drawString(this.guiGraphics, this.minecraft.font, Utils.translateToLocal("stats.munnyGet", new Object[0]), 5, 5 + heightOffsetText, 0xFFFFFF);
        this.drawString(this.guiGraphics, this.minecraft.font, "" + munnyGet, 5, 5 + heightOffsetNum, 0xFFFFFF);
        if (System.currentTimeMillis() / 1000L > timeMunny + 4L) {
            showMunny = false;
        }
    }

    private void showLevelUp(GuiGraphics gui, DeltaTracker deltaTracker, int actual) {
        int LEVULUP_WIDTH = 155;
        if (actual >= levelUpList.size()) {
            return;
        }
        LevelUpData levelData = levelUpList.get(actual);
        if (levelData == null) {
            return;
        }
        int[] notifColor = Utils.getRGBFromDec(levelData.color);
        String name = levelData.playerName;
        int lvl = levelData.lvl;
        PoseStack matrixStack = gui.pose();
        matrixStack.pushPose();
        int totalSpace = 0;
        for (int i = 0; i < actual; ++i) {
            totalSpace = (int)((float)totalSpace + 21.6f);
            Objects.requireNonNull(this.minecraft.font);
            totalSpace += (int)(9.0f * 1.2f) * GuiOverlay.levelUpList.get((int)i).messages1.size();
            totalSpace = (int)((float)totalSpace + 10.8f);
        }
        matrixStack.translate(0.0f, (float)totalSpace, 0.0f);
        float notifXPos = (float)levelData.prevNotifTicks + (float)(levelData.notifTicks - levelData.prevNotifTicks) * deltaTracker.getGameTimeDeltaPartialTick(true);
        if (notifXPos <= -155.0f) {
            notifXPos = -155.0f;
        }
        matrixStack.translate((float)this.width + notifXPos, 4.0f, 0.0f);
        Objects.requireNonNull(this.minecraft.font);
        int height = (int)(9.0f * 1.2f) * levelData.messages1.size();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)((float)notifColor[0] / 255.0f), (float)((float)notifColor[1] / 255.0f), (float)((float)notifColor[2] / 255.0f), (float)1.0f);
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, 0.0f);
        matrixStack.scale(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 0, 256, 36);
        matrixStack.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        this.showText(matrixStack, "LEVEL UP!" + String.valueOf(ChatFormatting.ITALIC), 6.0f, 4.0f, 0.0f, 0.75f, 0.75f, 1.0f, Color.decode(String.format("#%02x%02x%02x", (byte)-1, (byte)-1, (byte)-1)).hashCode());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.showText(matrixStack, "LV.", 50.0f, 4.0f, 0.0f, 0.75f, 0.75f, 1.0f, 14929920);
        this.showText(matrixStack, "" + lvl, 50 + this.font.width("LV."), 4.0f, 0.0f, 0.75f, 0.75f, 1.0f, 0xFFFFFF);
        this.showText(matrixStack, name, 150 - this.font.width(name), 4.0f, 0.0f, 0.75f, 0.75f, 1.0f, 0xFFFFFF);
        RenderSystem.setShaderColor((float)((float)notifColor[0] / 255.0f), (float)((float)notifColor[1] / 255.0f), (float)((float)notifColor[2] / 255.0f), (float)1.0f);
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 21.6f, 0.0f);
        matrixStack.scale(0.6f, (float)height, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 36, 256, 1);
        matrixStack.popPose();
        RenderSystem.setShaderColor((float)((float)notifColor[0] / 255.0f), (float)((float)notifColor[1] / 255.0f), (float)((float)notifColor[2] / 255.0f), (float)1.0f);
        matrixStack.pushPose();
        matrixStack.translate(0.0f, (float)height + 21.6f, 0.0f);
        matrixStack.scale(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 37, 256, 14);
        matrixStack.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < levelData.messages1.size(); ++i) {
            String message = levelData.messages1.get(i);
            float x = 5.0f;
            Objects.requireNonNull(this.minecraft.font);
            float y = 9.0f * 1.2f * (float)i + 23.0f;
            if (message.startsWith("A_")) {
                this.blit(gui, this.menuTexture, (int)x, (int)y - 2, 74, 102, 12, 12);
                message = message.replace("A_", "");
                x += 13.0f;
            }
            if (message.startsWith("S_")) {
                this.blit(gui, this.menuTexture, (int)x, (int)y - 2, 100, 102, 12, 12);
                message = message.replace("S_", "");
                x += 13.0f;
            }
            if (message.startsWith("M_")) {
                this.blit(gui, this.menuTexture, (int)x, (int)y - 2, 87, 115, 12, 12);
                message = message.replace("M_", "");
                x += 13.0f;
            }
            if (message.startsWith("C_")) {
                this.blit(gui, this.menuTexture, (int)x, (int)y - 2, 87, 129, 12, 12);
                message = message.replace("C_", "");
                x += 13.0f;
            }
            if (message.startsWith("R_")) {
                this.blit(gui, this.menuTexture, (int)x, (int)y - 2, 101, 129, 12, 12);
                message = message.replace("R_", "");
                x += 13.0f;
            }
            this.showText(matrixStack, Utils.translateToLocal(message, new Object[0]), x, y, 0.0f, 0.8f, 0.8f, 1.0f, 0xFFFFFF);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.popPose();
    }

    private void showDriveLevelUp(GuiGraphics gui, DeltaTracker deltaTracker) {
        PoseStack matrixStack = gui.pose();
        if (this.playerData == null || driveForm == null) {
            return;
        }
        DriveForm drive = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)driveForm));
        float[] driveColor = drive.getDriveColor();
        matrixStack.pushPose();
        float driveNotifXPos = prevDriveNotifTicks + (driveNotifTicks - prevDriveNotifTicks) * deltaTracker.getGameTimeDeltaPartialTick(true);
        if (driveNotifXPos > 155.0f) {
            driveNotifXPos = 155.0f;
        }
        matrixStack.translate(driveNotifXPos - 155.0f, 4.0f, 0.0f);
        Objects.requireNonNull(this.minecraft.font);
        int heightBase = (int)(9.0f * 1.1f) * GuiOverlay.driveLevelData.messages1.size();
        Objects.requireNonNull(this.minecraft.font);
        int heightDF = (int)(9.0f * 1.1f) * GuiOverlay.driveLevelData.messages2.size();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)driveColor[0], (float)driveColor[1], (float)driveColor[2], (float)1.0f);
        matrixStack.pushPose();
        RenderSystem.setShaderColor((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        matrixStack.pushPose();
        matrixStack.translate(2.0f, (float)(this.sHeight / 3), 0.0f);
        matrixStack.scale(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 51, 256, 36);
        matrixStack.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.showText(matrixStack, this.minecraft.player.getDisplayName().getString(), 140.0f - (float)this.minecraft.font.width(this.minecraft.player.getDisplayName().getString()) * 0.75f, this.sHeight / 3 + 4, 0.0f, 0.75f, 0.75f, 1.0f, 0xFFFFFF);
        RenderSystem.setShaderColor((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        matrixStack.pushPose();
        matrixStack.translate(2.0f, (float)(this.sHeight / 3 + 21), 0.0f);
        matrixStack.scale(0.6f, (float)(heightBase + 1), 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 87, 256, 1);
        matrixStack.popPose();
        RenderSystem.setShaderColor((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        matrixStack.pushPose();
        matrixStack.translate(2.0f, (float)(this.sHeight / 3 + 22 + heightBase), 0.0f);
        matrixStack.scale(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 88, 256, 14);
        matrixStack.popPose();
        RenderSystem.setShaderColor((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        for (int i = 0; i < GuiOverlay.driveLevelData.messages1.size(); ++i) {
            String message = GuiOverlay.driveLevelData.messages1.get(i);
            float x = 33.0f;
            float f = this.sHeight / 3;
            Objects.requireNonNull(this.minecraft.font);
            float y = f + 9.0f * 1.1f * (float)i + 23.0f;
            if (message.startsWith("A_")) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.blit(gui, this.menuTexture, (int)x, (int)y - 3, 74, 102, 12, 12);
                message = message.replace("A_", "");
                x += 13.0f;
            }
            this.showText(matrixStack, Utils.translateToLocalFormatted(message, new Object[0]), x, y, 0.0f, 0.8f, 0.8f, 1.0f, 0xFFFFFF);
        }
        RenderSystem.setShaderColor((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
        matrixStack.pushPose();
        matrixStack.translate(4.5f, (float)(this.sHeight / 3 + 6), 0.0f);
        matrixStack.scale(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 102, 43, 36);
        matrixStack.popPose();
        matrixStack.popPose();
        matrixStack.pushPose();
        RenderSystem.setShaderColor((float)driveColor[0], (float)driveColor[1], (float)driveColor[2], (float)1.0f);
        matrixStack.pushPose();
        matrixStack.translate(2.0f, (float)(this.sHeight / 3 + 29 + heightBase), 0.0f);
        matrixStack.scale(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 51, 256, 36);
        matrixStack.popPose();
        String formName = Utils.translateToLocal(((DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)driveForm))).getTranslationKey(), new Object[0]);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.showText(matrixStack, "LV.", 2.0f + (float)this.minecraft.font.width("LV. ") * 0.75f + 20.0f, this.sHeight / 3 + 29 + heightBase + 4, 0.0f, 0.75f, 0.75f, 1.0f, 14929920);
        this.showText(matrixStack, "" + this.playerData.getDriveFormLevel(driveForm), 1.5f + (float)this.minecraft.font.width("999") * 0.75f + 32.0f, this.sHeight / 3 + 29 + heightBase + 4, 0.0f, 0.75f, 0.75f, 1.0f, 0xFFFFFF);
        this.showText(matrixStack, formName, 140.0f - (float)this.minecraft.font.width(formName) * 0.75f, this.sHeight / 3 + 29 + heightBase + 4, 0.0f, 0.75f, 0.75f, 1.0f, 0xFFFFFF);
        RenderSystem.setShaderColor((float)driveColor[0], (float)driveColor[1], (float)driveColor[2], (float)1.0f);
        matrixStack.pushPose();
        matrixStack.translate(2.0f, (float)(this.sHeight / 3 + 50 + heightBase), 0.0f);
        matrixStack.scale(0.6f, (float)heightDF, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 87, 256, 1);
        matrixStack.popPose();
        RenderSystem.setShaderColor((float)driveColor[0], (float)driveColor[1], (float)driveColor[2], (float)1.0f);
        matrixStack.pushPose();
        matrixStack.translate(2.0f, (float)(this.sHeight / 3 + 50 + heightBase + heightDF), 0.0f);
        matrixStack.scale(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 88, 256, 14);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, (float)(this.sHeight / 3 + 50 + heightBase), 0.0f);
        RenderSystem.setShaderColor((float)driveColor[0], (float)driveColor[1], (float)driveColor[2], (float)1.0f);
        for (int i = 0; i < GuiOverlay.driveLevelData.messages2.size(); ++i) {
            String message = GuiOverlay.driveLevelData.messages2.get(i);
            float x = 33.0f;
            Objects.requireNonNull(this.minecraft.font);
            float y = 9.0f * 1.1f * (float)i;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (message.startsWith("A_")) {
                this.blit(gui, this.menuTexture, (int)x, (int)y - 2, 74, 102, 12, 12);
                message = message.replace("A_", "");
                x += 13.0f;
            }
            this.showText(matrixStack, Utils.translateToLocalFormatted(message, new Object[0]), x, y, 0.0f, 0.8f, 0.8f, 1.0f, 0xFFFFFF);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.popPose();
        RenderSystem.setShaderColor((float)driveColor[0], (float)driveColor[1], (float)driveColor[2], (float)1.0f);
        matrixStack.pushPose();
        matrixStack.translate(4.5f, (float)(this.sHeight / 3 + 34 + heightBase), 0.0f);
        matrixStack.scale(0.6f, 0.6f, 1.0f);
        this.blit(gui, this.levelUpTexture, 0, 0, 0, 102, 43, 36);
        matrixStack.popPose();
        matrixStack.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.popPose();
        if (System.currentTimeMillis() / 1000L > timeDriveLevelUp + (long)this.levelSeconds) {
            showDriveLevelUp = false;
        }
    }

    private void showText(PoseStack matrixStack, String text, float tX, float tY, float tZ, float sX, float sY, float sZ, int color) {
        matrixStack.pushPose();
        matrixStack.translate(tX, tY, tZ);
        matrixStack.scale(sX, sY, sZ);
        this.drawString(this.guiGraphics, this.minecraft.font, text, 0, 0, color);
        matrixStack.popPose();
    }

    @SubscribeEvent
    public void ClientTick(ClientTickEvent.Post event) {
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        for (LevelUpData notif : levelUpList) {
            if (notif.sliding) {
                notif.prevNotifTicks = notif.notifTicks;
                notif.notifTicks -= 50;
                continue;
            }
            if (notif.notifTicks > -150) continue;
            notif.prevNotifTicks = 0;
            notif.notifTicks = 0;
        }
        if (showDriveLevelUp) {
            prevDriveNotifTicks = driveNotifTicks;
            driveNotifTicks += 50.0f;
        } else if (driveNotifTicks > 150.0f) {
            prevDriveNotifTicks = 0.0f;
            driveNotifTicks = 0.0f;
        }
    }

    static {
        levelUpList = new ArrayList<LevelUpData>();
        driveLevelData = new LevelUpData();
        driveForm = "";
        playerWhoLevels = Util.NIL_UUID;
        notifTicks = 0.0f;
        prevNotifTicks = 0.0f;
        driveNotifTicks = 0.0f;
        prevDriveNotifTicks = 0.0f;
    }

    public static class LevelUpData {
        public String playerName;
        public UUID playerUUID;
        public int lvl;
        public int prevNotifTicks;
        public int notifTicks;
        public boolean sliding = true;
        public long timeLevelUp;
        public List<String> messages1 = new ArrayList<String>();
        public List<String> messages2 = new ArrayList<String>();
        public int color;
    }
}

