/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class HPGui
extends OverlayBase {
    public static final HPGui INSTANCE = new HPGui();
    float hpBarWidth;
    float missingHpBarWidth;
    int guiHeight = 10;
    private float playerHealth;
    private long lastSystemTime;
    private float lastPlayerHealth;
    final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/hpbar.png");

    private HPGui() {
    }

    @Override
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        super.render(guiGraphics, deltaTracker);
        LocalPlayer player = this.minecraft.player;
        int screenWidth = this.minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = this.minecraft.getWindow().getGuiScaledHeight();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float scale = 1.0f;
        switch ((Integer)this.minecraft.options.guiScale().get()) {
            case 0: {
                scale = 0.85f;
            }
        }
        float scaleFactor = 1.5f * (float)ModConfigs.hpXScale / 100.0f;
        this.hpBarWidth = player.getHealth() * scaleFactor;
        int hpBarMaxWidth = (int)(player.getMaxHealth() * scaleFactor);
        float i = player.getHealth();
        long j = Util.getMillis();
        if (i < this.playerHealth && player.invulnerableTime > 0) {
            this.lastSystemTime = j;
        } else if (i > this.playerHealth && player.invulnerableTime > 0) {
            this.lastSystemTime = j;
        }
        if (j - this.lastSystemTime > 1000L || this.playerHealth < player.getHealth()) {
            this.playerHealth = i;
            this.lastPlayerHealth = i;
            this.lastSystemTime = j;
        }
        this.missingHpBarWidth = Math.max((this.lastPlayerHealth - player.getHealth()) * scaleFactor, 0.0f);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        RenderSystem.enableBlend();
        poseStack.translate((float)ModConfigs.hpXPos, (float)ModConfigs.hpYPos, 0.0f);
        poseStack.pushPose();
        poseStack.translate((float)screenWidth - (float)hpBarMaxWidth * scale - 8.0f * scale, (float)screenHeight - (float)this.guiHeight * scale - 2.0f * scale, 0.0f);
        poseStack.scale(scale, scale, scale);
        this.drawHPBarBack(guiGraphics, 0, 0, hpBarMaxWidth, scale, (Player)player);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate((float)screenWidth - this.hpBarWidth * scale - 8.0f * scale, (float)screenHeight - (float)this.guiHeight * scale - 1.0f * scale - 0.1f, 0.0f);
        poseStack.scale(scale, scale, scale);
        this.drawHPBarTop(guiGraphics, 0, 0, this.hpBarWidth, scale, (Player)player);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate((float)screenWidth - (this.hpBarWidth + this.missingHpBarWidth) * scale - 8.0f * scale, (float)screenHeight - (float)this.guiHeight * scale - 1.0f * scale - 0.1f, 0.0f);
        poseStack.scale(scale, scale, scale);
        this.drawDamagedHPBarTop(guiGraphics, 0, 0, this.missingHpBarWidth, scale, (LivingEntity)player);
        poseStack.popPose();
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    public void drawHPBarBack(GuiGraphics gui, int posX, int posY, float width, float scale, Player player) {
        PoseStack matrixStack = gui.pose();
        matrixStack.pushPose();
        matrixStack.pushPose();
        matrixStack.translate(scale * (float)posX, scale * (float)posY, 0.0f);
        matrixStack.scale(scale, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 0, 0, 2, 12);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate((float)(posX + 2) * scale, (float)posY * scale, 0.0f);
        matrixStack.scale(width, scale, 0.0f);
        int v = Utils.isPlayerLowHP(player) ? 8 : 2;
        this.blit(gui, this.texture, 0, 0, v, 0, 1, 12);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate((float)(posX + 2) * scale + width, scale * (float)posY, 0.0f);
        matrixStack.scale(scale, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 3, 0, 2, 12);
        matrixStack.popPose();
        matrixStack.popPose();
    }

    public void drawHPBarTop(GuiGraphics gui, int posX, int posY, float width, float scale, Player player) {
        PoseStack matrixStack = gui.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)(posX + 2) * scale, (float)(posY + 2) * scale, 0.0f);
        matrixStack.scale(width, scale, 0.0f);
        this.blit(gui, this.texture, 0, -1, 2, 12, 1, 8);
        matrixStack.popPose();
    }

    public void drawDamagedHPBarTop(GuiGraphics gui, int posX, int posY, float width, float scale, LivingEntity player) {
        PoseStack matrixStack = gui.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)(posX + 2) * scale, (float)(posY + 2) * scale, 0.0f);
        matrixStack.scale(width, scale, 0.0f);
        this.blit(gui, this.texture, 0, -1, 2, 22, 1, 8);
        matrixStack.popPose();
    }
}

