/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.GlobalData;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.handler.InputHandler;
import online.kingdomkeys.kingdomkeys.util.Utils;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class LockOnGui
extends OverlayBase {
    public static final LockOnGui INSTANCE = new LockOnGui();
    int guiWidth = 256;
    int guiHeight = 256;
    int hpGuiWidth = 173;
    float hpBarWidth;
    float missingHpBarWidth;
    float hpPerBar;
    int hpBars;
    int currentBar;
    int oldBar;
    int hpGuiHeight = 10;
    int noborderguiwidth = 171;
    float lockOnScale;
    float hpBarScale;
    LivingEntity lastTrackedTarget;
    private float targetHealth;
    private long lastSystemTime;
    private float lastTargetHealth;
    final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/hpbar.png");

    private LockOnGui() {
    }

    @SubscribeEvent
    public static void renderOverlay(RenderGuiLayerEvent.Pre event) {
        if (InputHandler.lockOn != null && event.getName().equals((Object)VanillaGuiLayers.CROSSHAIR)) {
            event.setCanceled(true);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        super.render(guiGraphics, deltaTracker);
        LocalPlayer player = this.minecraft.player;
        PlayerData playerData = PlayerData.get((Player)player);
        if (playerData != null) {
            LivingEntity target = InputHandler.lockOn;
            if (target == null) {
                this.missingHpBarWidth = 0.0f;
            } else {
                if (player.distanceTo((Entity)target) > (float)InputHandler.LOCK_ON_REACH || player.hasEffect(ModMobEffects.KO)) {
                    InputHandler.lockOn = null;
                    return;
                }
                float size = 6.0f;
                int screenWidth = this.minecraft.getWindow().getGuiScaledWidth();
                int screenHeight = this.minecraft.getWindow().getGuiScaledHeight();
                this.lockOnScale = (float)ModConfigs.lockOnIconScale / 100.0f;
                this.hpBarScale = (float)ModConfigs.lockOnHPScale / 100.0f;
                PoseStack poseStack = guiGraphics.pose();
                poseStack.pushPose();
                poseStack.translate((float)(screenWidth / 2) - (float)(this.guiWidth / 2) * this.lockOnScale / size - 0.5f, (float)(screenHeight / 2) - (float)(this.guiHeight / 2) * this.lockOnScale / size - 0.5f, 0.0f);
                poseStack.scale(this.lockOnScale / size, this.lockOnScale / size, this.lockOnScale / size);
                this.blit(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/lockon_0.png"), 0, 0, 0, 0, this.guiWidth, this.guiHeight);
                poseStack.translate((float)(this.guiWidth / 2), (float)(this.guiWidth / 2), 0.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees((float)Math.toDegrees((float)(player.tickCount % 360 * ModConfigs.lockOnIconRotation) / 100.0f)));
                poseStack.translate((float)(-this.guiWidth / 2), (float)(-this.guiWidth / 2), 0.0f);
                this.blit(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/lockon_1.png"), 0, 0, 0, 0, this.guiWidth, this.guiHeight);
                poseStack.popPose();
                poseStack.pushPose();
                if (target != null && playerData.isAbilityEquipped("kingdomkeys:ability_scan")) {
                    GlobalData targetData;
                    poseStack.pushPose();
                    RenderSystem.enableBlend();
                    poseStack.translate((float)ModConfigs.lockOnXPos, (float)ModConfigs.lockOnYPos, 0.0f);
                    Component targetName = target.getName();
                    if (!ModConfigs.mobLevelName && (targetData = GlobalData.getClient(target)) != null && targetData.getLevel() > 0) {
                        targetName = Component.translatable((String)(target.getDisplayName().getString() + " Lv." + String.valueOf(Utils.getLevelColor((Player)player, targetData.getLevel())) + targetData.getLevel() + String.valueOf(ChatFormatting.RESET)));
                    }
                    this.drawString(guiGraphics, this.minecraft.font, targetName, screenWidth - this.minecraft.font.width((FormattedText)targetName), (int)(26.0f * this.hpBarScale), 0xFFFFFF);
                    this.drawHPBar(guiGraphics, target);
                    RenderSystem.disableBlend();
                    poseStack.popPose();
                }
                poseStack.scale(this.hpBarScale, this.hpBarScale, this.hpBarScale);
                poseStack.popPose();
            }
        }
    }

    public void drawHPBar(GuiGraphics gui, LivingEntity target) {
        float hpBarMaxWidth;
        int screenWidth = this.minecraft.getWindow().getGuiScaledWidth();
        this.hpPerBar = ModConfigs.lockOnHpPerBar;
        float widthMultiplier = 10.0f * this.hpBarScale;
        float targetHealth = Math.min(target.getHealth(), target.getMaxHealth());
        this.hpBars = target.getMaxHealth() % this.hpPerBar == 0.0f ? (int)(target.getMaxHealth() / this.hpPerBar) : (int)(target.getMaxHealth() / this.hpPerBar) + 1;
        this.currentBar = targetHealth % this.hpPerBar == 0.0f ? (int)(targetHealth / this.hpPerBar) : (int)(targetHealth / this.hpPerBar) + 1;
        float firstBar = target.getMaxHealth() > this.hpPerBar ? target.getMaxHealth() % this.hpPerBar : target.getMaxHealth();
        float oneBar = target.getMaxHealth() > this.hpPerBar ? this.hpPerBar : target.getMaxHealth();
        this.hpBarWidth = targetHealth % this.hpPerBar == 0.0f && targetHealth != 0.0f ? oneBar * widthMultiplier : targetHealth % this.hpPerBar * widthMultiplier;
        float i = targetHealth;
        long j = Util.getMillis();
        if (i < this.targetHealth && target.invulnerableTime > 0) {
            this.lastSystemTime = j;
        } else if (i > this.targetHealth && target.invulnerableTime > 0) {
            this.lastSystemTime = j;
        }
        if (j - this.lastSystemTime > 1000L || this.targetHealth < targetHealth) {
            this.targetHealth = i;
            this.lastTargetHealth = i;
            this.lastSystemTime = j;
            this.oldBar = this.currentBar;
            this.missingHpBarWidth = 0.0f;
        }
        this.missingHpBarWidth = targetHealth % this.hpPerBar == 0.0f ? 0.0f : Math.min(Math.max(this.lastTargetHealth - targetHealth, 0.0f), this.hpPerBar - targetHealth % this.hpPerBar) % this.hpPerBar * widthMultiplier;
        float bgHPBarMaxWidth = 0.0f;
        if (target.getMaxHealth() >= this.hpPerBar) {
            if (targetHealth + this.hpPerBar > target.getMaxHealth() && this.currentBar == this.hpBars) {
                hpBarMaxWidth = firstBar * widthMultiplier;
                bgHPBarMaxWidth = this.hpPerBar * widthMultiplier;
            } else if (this.currentBar == 1) {
                hpBarMaxWidth = oneBar * widthMultiplier;
                bgHPBarMaxWidth = 0.0f;
            } else {
                hpBarMaxWidth = oneBar * widthMultiplier;
                bgHPBarMaxWidth = this.hpPerBar * widthMultiplier;
            }
        } else {
            hpBarMaxWidth = target.getMaxHealth() % this.hpPerBar * widthMultiplier;
        }
        gui.pose().pushPose();
        this.drawHPBarBack(gui, (float)screenWidth - hpBarMaxWidth - 4.0f * this.hpBarScale, 0.0f * this.hpBarScale, hpBarMaxWidth, this.hpBarScale, (float)screenWidth - bgHPBarMaxWidth - 4.0f * this.hpBarScale, bgHPBarMaxWidth);
        this.drawHPBarTop(gui, (float)screenWidth - this.hpBarWidth - 2.0f * this.hpBarScale, 2.0f * this.hpBarScale, this.hpBarWidth, this.hpBarScale);
        this.drawDamagedHPBarTop(gui, (float)screenWidth - this.hpBarWidth - this.missingHpBarWidth - 2.0f * this.hpBarScale, 2.0f * this.hpBarScale, this.missingHpBarWidth, this.hpBarScale, target);
        this.drawHPBars(gui, (float)screenWidth - hpBarMaxWidth - 4.0f * this.hpBarScale, 0.0f * this.hpBarScale, hpBarMaxWidth, this.hpBarScale, target);
        this.drawDamagedHPBars(gui, (float)screenWidth - hpBarMaxWidth - 4.0f * this.hpBarScale, 0.0f * this.hpBarScale, hpBarMaxWidth, this.hpBarScale, target);
        gui.pose().popPose();
    }

    public void drawHPBarBack(GuiGraphics gui, float posX, float posY, float width, float scale, float bgPosX, float bgHPBarMaxWidth) {
        PoseStack matrixStack = gui.pose();
        matrixStack.pushPose();
        matrixStack.translate(posX, posY, 0.0f);
        matrixStack.pushPose();
        matrixStack.translate(bgPosX - posX, posY, 0.0f);
        matrixStack.pushPose();
        matrixStack.scale(scale, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 0, 0, 2, 12);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(2.0f * scale, 0.0f, 0.0f);
        matrixStack.scale(bgHPBarMaxWidth, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 14, 0, 1, 12);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(2.0f * scale + bgHPBarMaxWidth, 0.0f, 0.0f);
        matrixStack.scale(scale, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 3, 0, 2, 12);
        matrixStack.popPose();
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.scale(scale, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 0, 0, 2, 12);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(2.0f * scale, 0.0f, 0.0f);
        matrixStack.scale(width, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 2, 0, 1, 12);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(2.0f * scale + width, 0.0f, 0.0f);
        matrixStack.scale(scale, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 3, 0, 2, 12);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(width - 20.0f * scale, 12.0f * scale, 0.0f);
        matrixStack.scale(scale, scale, 0.0f);
        this.blit(gui, this.texture, 1, 0, 0, 32, 23, 12);
        matrixStack.popPose();
        for (int i = 0; i < this.hpBars - 1; ++i) {
            matrixStack.pushPose();
            matrixStack.translate(width - 19.0f * scale - 17.0f * scale * (float)(i + 1), 12.0f * scale, 0.0f);
            matrixStack.scale(scale, scale, 0.0f);
            this.blit(gui, this.texture, 0, 0, 0, 46, 17, 12);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }

    public void drawHPBarTop(GuiGraphics gui, float posX, float posY, float width, float scale) {
        PoseStack matrixStack = gui.pose();
        matrixStack.pushPose();
        matrixStack.translate(posX, posY, 0.0f);
        matrixStack.scale(width, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 2, 12, 1, 8);
        matrixStack.popPose();
    }

    private void drawHPBars(GuiGraphics gui, float posX, float posY, float width, float scale, LivingEntity target) {
        PoseStack matrixStack = gui.pose();
        if (target.isAlive()) {
            for (int i = 1; i < this.currentBar; ++i) {
                matrixStack.pushPose();
                matrixStack.translate(posX + width - 17.0f * scale - 17.0f * scale * (float)i - 2.0f * scale, posY + 12.0f * scale, 0.0f);
                matrixStack.scale(scale, scale, 0.0f);
                this.blit(gui, this.texture, 0, 0, 0, 60, 17, 12);
                matrixStack.popPose();
            }
        }
    }

    private void drawDamagedHPBarTop(GuiGraphics gui, float posX, float posY, float width, float scale, LivingEntity target) {
        PoseStack matrixStack = gui.pose();
        matrixStack.pushPose();
        matrixStack.pushPose();
        matrixStack.translate(posX, posY, 0.0f);
        matrixStack.scale(width, scale, 0.0f);
        this.blit(gui, this.texture, 0, 0, 2, 22, 1, 8);
        matrixStack.popPose();
        matrixStack.popPose();
    }

    private void drawDamagedHPBars(GuiGraphics gui, float posX, float posY, float width, float scale, LivingEntity target) {
        PoseStack matrixStack = gui.pose();
        if (target.isAlive()) {
            for (int i = this.currentBar; i < this.oldBar; ++i) {
                matrixStack.pushPose();
                matrixStack.translate(posX + width - 17.0f * scale - 17.0f * scale * (float)i - 2.0f * scale, posY + 12.0f * scale, 0.0f);
                matrixStack.scale(scale, scale, 0.0f);
                this.blit(gui, this.texture, 0, 0, 17, 60, 17, 12);
                matrixStack.popPose();
            }
        }
    }
}

