/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class PartyHUDGui
extends OverlayBase {
    public static final PartyHUDGui INSTANCE = new PartyHUDGui();
    int hpBarWidth;
    int guiHeight = 10;
    int counter = 0;

    private PartyHUDGui() {
    }

    public ResourceLocation getLocationSkin(Player player) {
        PlayerInfo networkplayerinfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getUUID());
        return networkplayerinfo == null ? DefaultPlayerSkin.get((UUID)player.getUUID()).texture() : networkplayerinfo.getSkin().texture();
    }

    @Override
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        super.render(guiGraphics, deltaTracker);
        LocalPlayer player = this.minecraft.player;
        int screenWidth = this.minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = this.minecraft.getWindow().getGuiScaledHeight();
        float scale = 0.5f;
        WorldData worldData = WorldData.getClient();
        Party p = worldData.getPartyFromMember(player.getUUID());
        if (p == null) {
            return;
        }
        ArrayList<Party.Member> allies = new ArrayList<Party.Member>();
        allies.clear();
        for (Party.Member m : p.getMembers()) {
            if (m.getUUID().equals(player.getUUID())) continue;
            allies.add(m);
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)ModConfigs.partyXPos, (float)(ModConfigs.partyYPos - 100), 0.0f);
        for (int i = 0; i < allies.size(); ++i) {
            Party.Member member = (Party.Member)allies.get(i);
            Player playerAlly = player.level().getPlayerByUUID(member.getUUID());
            this.renderFace(guiGraphics, playerAlly, screenWidth, screenHeight, scale, i);
        }
        poseStack.popPose();
    }

    public void renderFace(GuiGraphics gui, Player playerAlly, float screenWidth, float screenHeight, float scale, int i) {
        String name;
        ResourceLocation skin = playerAlly != null ? this.getLocationSkin(playerAlly) : ResourceLocation.withDefaultNamespace((String)"textures/entity/player/wide/steve.png");
        PoseStack matrixStack = gui.pose();
        matrixStack.pushPose();
        matrixStack.translate(-16.0f, -screenHeight / 4.0f * ((float)(i * ModConfigs.partyYDistance) / 100.0f), 0.0f);
        int headWidth = 32;
        int headHeight = 32;
        float headPosX = 0.0f;
        float headPosY = 0.0f;
        float scaledHeadPosX = headPosX * scale;
        float scaledHeadPosY = headPosY * scale;
        matrixStack.pushPose();
        matrixStack.translate(screenWidth - (float)headWidth * scale - scaledHeadPosX, screenHeight - (float)headHeight * scale - scaledHeadPosY, 0.0f);
        matrixStack.scale(scale, scale, scale);
        if (playerAlly == null) {
            RenderSystem.setShaderColor((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.blit(gui, skin, 0, 0, 32, 32, headWidth, headHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.popPose();
        int hatWidth = 32;
        int hatHeight = 32;
        float hatPosX = 0.0f;
        float hatPosY = 0.0f;
        float scaledHatPosX = hatPosX * scale;
        float scaledHatPosY = hatPosY * scale;
        matrixStack.pushPose();
        matrixStack.translate(screenWidth - (float)hatWidth * scale - scaledHatPosX, screenHeight - (float)hatHeight * scale - scaledHatPosY, 0.0f);
        matrixStack.scale(scale, scale, scale);
        this.blit(gui, skin, 0, 0, 160, 32, hatWidth, hatHeight);
        matrixStack.popPose();
        matrixStack.pushPose();
        matrixStack.translate(screenWidth - (float)hatWidth * scale - scaledHatPosX, screenHeight - (float)hatHeight * scale - scaledHatPosY, 0.0f);
        matrixStack.scale(scale, scale, scale);
        String string = name = playerAlly == null ? "Out of range" : playerAlly.getDisplayName().getString();
        if (playerAlly != null && this.minecraft.player.distanceTo((Entity)playerAlly) >= (float)((Integer)ModConfigs.SERVER.partyRangeLimit.get()).intValue()) {
            this.drawCenteredString(gui, this.minecraft.font, "Out of range", 16, -20, 0xFFFFFF);
        }
        this.drawCenteredString(gui, this.minecraft.font, name, 16, -10, 0xFFFFFF);
        matrixStack.popPose();
        if (playerAlly != null) {
            matrixStack.translate(screenWidth - (float)headWidth * scale - scaledHeadPosX, screenHeight - (float)headHeight * scale - scaledHeadPosY, 0.0f);
            float val = playerAlly.getHealth();
            float max = playerAlly.getMaxHealth();
            ResourceLocation hptexture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/hpbar.png");
            matrixStack.translate(-4.0f, 0.0f, 1.0f);
            matrixStack.pushPose();
            matrixStack.scale(scale / 3.0f * 2.0f, scale, 1.0f);
            this.blit(gui, hptexture, 0, 0, 0, 72, 12, 2);
            matrixStack.popPose();
            matrixStack.pushPose();
            matrixStack.translate(0.0f, 1.0f, 1.0f);
            matrixStack.scale(scale / 3.0f * 2.0f, scale * 28.0f, 1.0f);
            this.blit(gui, hptexture, 0, 0, 0, 74, 12, 1);
            matrixStack.popPose();
            matrixStack.pushPose();
            matrixStack.translate(0.0f, 30.0f, 1.0f);
            matrixStack.scale(scale / 3.0f * 2.0f, scale, 1.0f);
            this.blit(gui, hptexture, 0, -30, 0, 72, 12, 2);
            matrixStack.popPose();
            matrixStack.pushPose();
            matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            matrixStack.translate(-4.0f, -15.0f, 1.0f);
            matrixStack.scale(scale * 0.66f, scale * 28.0f * val / max, 1.0f);
            this.blit(gui, hptexture, 0, 0, 0, 78, 12, 1);
            matrixStack.popPose();
            PlayerData playerData = PlayerData.get(playerAlly);
            if (playerData != null) {
                val = (float)playerData.getMP();
                max = (float)playerData.getMaxMP();
                ResourceLocation mptexture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/mpbar.png");
                matrixStack.translate(20.0f, 0.0f, 1.0f);
                matrixStack.pushPose();
                matrixStack.scale(scale / 3.0f * 2.0f, scale, 1.0f);
                this.blit(gui, mptexture, 0, 0, 0, 58, 12, 2);
                matrixStack.popPose();
                matrixStack.pushPose();
                matrixStack.translate(0.0f, 1.0f, 1.0f);
                matrixStack.scale(scale / 3.0f * 2.0f, scale * 28.0f, 1.0f);
                this.blit(gui, mptexture, 0, 0, 0, 60, 12, 1);
                matrixStack.popPose();
                matrixStack.pushPose();
                matrixStack.translate(0.0f, 30.0f, 1.0f);
                matrixStack.scale(scale / 3.0f * 2.0f, scale, 1.0f);
                this.blit(gui, mptexture, 0, -30, 0, 58, 12, 2);
                matrixStack.popPose();
                matrixStack.pushPose();
                matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                matrixStack.translate(-4.0f, -15.0f, 1.0f);
                matrixStack.scale(scale / 3.0f * 2.0f, scale * 28.0f * val / max, 1.0f);
                this.blit(gui, mptexture, 0, 0, 0, 64, 12, 1);
                matrixStack.popPose();
            }
        }
        matrixStack.popPose();
    }
}

