/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class PlayerPortraitGui
extends OverlayBase {
    public static final PlayerPortraitGui INSTANCE = new PlayerPortraitGui();

    private PlayerPortraitGui() {
    }

    @Override
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        super.render(guiGraphics, deltaTracker);
        PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
        int screenWidth = this.minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = this.minecraft.getWindow().getGuiScaledHeight();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation skin = this.minecraft.player.getSkin().texture();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)skin);
        float scale = 0.5f;
        switch ((Integer)this.minecraft.options.guiScale().get()) {
            case 3: {
                scale = 0.48f;
                break;
            }
            case 2: {
                scale = 0.32f;
                break;
            }
            case 1: {
                scale = 0.16f;
            }
        }
        if (playerData != null) {
            if (playerData.getActiveDriveForm().equals("kingdomkeys:form_anti")) {
                RenderSystem.setShaderColor((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
            }
            if (Utils.isPlayerLowHP((Player)this.minecraft.player)) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.5f, (float)0.5f, (float)1.0f);
            }
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            float playerHeight = (float)screenHeight / 2.0f * scale;
            float playerPosX = (float)screenWidth * (1.0f - scale / 10.0f);
            float playerPosY = (float)screenHeight + playerHeight * 0.95f;
            poseStack.pushPose();
            if (this.minecraft.player == null) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            ItemStack stack = player.getInventory().getItem(player.getInventory().selected);
            player.getInventory().setItem(player.getInventory().selected, new ItemStack((ItemLike)Items.AIR));
            ClientUtils.renderPlayerNoAnims(poseStack, (int)playerPosX + ModConfigs.playerSkinXPos, (int)playerPosY + ModConfigs.playerSkinYPos, (int)playerHeight, 0.0f, 0.0f, (LivingEntity)player);
            player.getInventory().setItem(player.getInventory().selected, stack);
            poseStack.popPose();
            poseStack.popPose();
        }
    }
}

