/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import java.util.Map;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.CommandMenuGui;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.handler.InputHandler;
import online.kingdomkeys.kingdomkeys.handler.KeyboardHelper;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class ShortcutsGui
extends OverlayBase {
    public static final ShortcutsGui INSTANCE = new ShortcutsGui();
    PlayerData playerData;

    private ShortcutsGui() {
    }

    @Override
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        super.render(guiGraphics, deltaTracker);
        if (KeyboardHelper.isScrollActivatorDown() && CommandMenuGui.INSTANCE.currentSubmenu == CommandMenuGui.INSTANCE.root && Minecraft.getInstance().screen == null) {
            this.playerData = PlayerData.get((Player)this.minecraft.player);
            int i = 0;
            for (Map.Entry<Integer, String> entry : this.playerData.getShortcutsMap().entrySet()) {
                int colour;
                String[] data = entry.getValue().split(",");
                Magic magic = (Magic)ModMagic.registry.get(ResourceLocation.parse((String)data[0]));
                double cost = magic.getCost(Integer.parseInt(data[1]), (Player)this.minecraft.player);
                int n = colour = this.playerData.getMP() > cost ? 0xFFFFFF : 0xFF9900;
                if (this.playerData.isAbilityEquipped("kingdomkeys:ability_extra_cast") && cost > this.playerData.getMP() && this.playerData.getMP() > 1.0 && cost < 300.0) {
                    colour = 0xFFFFFF;
                }
                DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)this.playerData.getActiveDriveForm()));
                if (this.playerData.getMaxMP() == 0.0 || this.playerData.getRecharge() || cost > this.playerData.getMaxMP() && cost < 300.0 || cost < 300.0 && cost >= this.playerData.getMP() && this.playerData.isAbilityEquipped("kingdomkeys:ability_mp_safety") || this.playerData.getMagicCasttimeTicks() > 0 || this.playerData.getMagicCooldownTicks() > 0 || !form.canUseMagic()) {
                    colour = 0x888888;
                }
                this.drawString(guiGraphics, this.minecraft.font, Utils.translateToLocal(InputHandler.Keybinds.SCROLL_ACTIVATOR.keybinding.getKey().getName(), new Object[0]) + " + " + (entry.getKey() + 1) + ": " + Utils.translateToLocal(magic.getTranslationKey(Integer.parseInt(data[1])), new Object[0]), (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset, 4 + i * 10, colour);
                ++i;
            }
        }
    }
}

