/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.handler.ClientEvents;
import online.kingdomkeys.kingdomkeys.shotlock.Shotlock;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class ShotlockGUI
extends OverlayBase {
    public static final ShotlockGUI INSTANCE = new ShotlockGUI();
    float focusBarWidth;
    int guiWidth = 44;
    int guiHeight = 122;
    int noborderguiwidth = 42;
    int noborderguiheight = 120;
    PlayerData playerData;
    public ResourceLocation focusBar = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/focusbar.png");

    private ShotlockGUI() {
    }

    @Override
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        super.render(guiGraphics, deltaTracker);
        LocalPlayer player = this.minecraft.player;
        int screenWidth = this.minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = this.minecraft.getWindow().getGuiScaledHeight();
        float rawScale = 1.0f;
        switch ((Integer)this.minecraft.options.guiScale().get()) {
            case 0: {
                rawScale = 0.85f;
            }
        }
        float scaleX = rawScale * (float)ModConfigs.focusXScale / 100.0f;
        float scaleY = rawScale * (float)ModConfigs.focusYScale / 100.0f;
        this.playerData = PlayerData.get((Player)player);
        if (this.playerData == null || this.playerData.getMaxFocus() <= 0.0) {
            return;
        }
        this.focusBarWidth = (int)this.playerData.getFocus();
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.pushPose();
        RenderSystem.enableBlend();
        poseStack.translate((float)(ModConfigs.focusXPos + 38), (float)(ModConfigs.focusYPos - 10), 0.0f);
        poseStack.translate((float)screenWidth - (float)this.guiWidth * scaleX - 20.0f * scaleX, (float)screenHeight - (float)this.guiHeight * scaleY - 8.0f * scaleY, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(50.0f));
        poseStack.pushPose();
        poseStack.scale(scaleX, scaleY, 1.0f);
        this.drawFocusBarBack(guiGraphics, 0.0f, 0.0f, this.guiWidth, 1.0f);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(scaleX, scaleY, 1.0f);
        this.drawFocusCostBarTop(guiGraphics, 0.0f, 0.0f, this.playerData.getFocus(), 1.0f);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(scaleX, scaleY, 1.0f);
        this.drawFocusBarTop(guiGraphics, 0.0f, 0.0f, (float)ClientEvents.focusGaugeTemp, 1.0f);
        poseStack.popPose();
        poseStack.popPose();
        if (ClientEvents.focusing) {
            int guiWidth = 256;
            int guiHeight = 256;
            float focusScale = 4.0f;
            float size = 6.0f;
            poseStack.pushPose();
            poseStack.pushPose();
            Shotlock shotlock = Utils.getPlayerShotlock((Player)this.minecraft.player);
            this.playerData = PlayerData.get((Player)this.minecraft.player);
            if (this.playerData == null) {
                return;
            }
            poseStack.translate((float)(screenWidth / 2) - (float)(guiWidth / 2) * focusScale / size - 0.5f, (float)(screenHeight / 2) - (float)(guiHeight / 2) * focusScale / size - 0.5f, 0.0f);
            poseStack.scale(focusScale / size, focusScale / size, focusScale / size);
            if (ClientEvents.focusGaugeTemp <= 0.0) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.blit(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/focus.png"), 0, 0, 0, 0, guiWidth, guiHeight);
            poseStack.pushPose();
            poseStack.scale(2.0f, 2.0f, 2.0f);
            Font font = this.minecraft.font;
            String string = this.playerData.getShotlockEnemies().size() + "/" + shotlock.getMaxLocks();
            int n = guiWidth / 2;
            int n2 = guiHeight / 4;
            Objects.requireNonNull(this.minecraft.font);
            this.drawString(guiGraphics, font, string, n, n2 - 9 / 2, 0x88CC33);
            poseStack.popPose();
            if (ClientEvents.focusGaugeTemp > 0.0) {
                double max = this.playerData.getFocus();
                double actual = ClientEvents.focusGaugeTemp;
                int topOffset = 25;
                int botOffset = 31;
                int realGuiHeight = guiHeight - botOffset - topOffset;
                int n3 = (int)(actual * (double)realGuiHeight / max);
                this.blit(guiGraphics, ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/gui/focus2.png"), 0, guiHeight - botOffset - n3, 0, guiHeight - botOffset - n3, guiWidth, n3);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.popPose();
            poseStack.popPose();
        }
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    public void drawFocusBarBack(GuiGraphics gui, float posX, float posY, float width, float scale) {
        PoseStack matrixStack = gui.pose();
        matrixStack.pushPose();
        matrixStack.translate(posX * scale, posY * scale, 0.0f);
        matrixStack.scale(scale, scale, 0.0f);
        this.blit(gui, this.focusBar, 0, 0, 0, 0, this.guiWidth, this.guiHeight);
        matrixStack.popPose();
    }

    public void drawFocusCostBarTop(GuiGraphics gui, float posX, float posY, double focus, float scale) {
        PoseStack matrixStack = gui.pose();
        matrixStack.pushPose();
        int h = (int)(focus * (double)this.noborderguiheight / 100.0);
        matrixStack.translate(posX * scale, posY * scale, 0.0f);
        matrixStack.scale(scale, scale, 0.0f);
        this.blit(gui, this.focusBar, 0, this.noborderguiheight - h + 1, 88, 120 - h, this.noborderguiwidth + 1, h);
        matrixStack.popPose();
    }

    public void drawFocusBarTop(GuiGraphics gui, float posX, float posY, float amount, float scale) {
        PoseStack matrixStack = gui.pose();
        matrixStack.pushPose();
        int h = (int)(amount * (float)this.noborderguiheight / 100.0f);
        matrixStack.translate(posX * scale, posY * scale, 0.0f);
        matrixStack.scale(scale, scale, 0.0f);
        this.blit(gui, this.focusBar, 0, this.noborderguiheight - h + 1, 44, 120 - h, this.noborderguiwidth + 1, h);
        matrixStack.popPose();
    }
}

