/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import online.kingdomkeys.kingdomkeys.client.gui.overlay.OverlayBase;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class SoAMessages
extends OverlayBase {
    public static final SoAMessages INSTANCE = new SoAMessages();
    private final Queue<Utils.Title> messages = new LinkedList<Utils.Title>();
    String displayedTitle;
    String displayedSubTitle;
    int titleFadeIn;
    int titleDisplayTime;
    int titleFadeOut;
    int titlesTimer;
    float scaledWidth;
    float scaledHeight;

    private SoAMessages() {
    }

    public void queueMessages(Utils.Title ... messages) {
        this.messages.addAll(Arrays.asList(messages));
    }

    public void queueMessage(Utils.Title message) {
        this.messages.add(message);
    }

    public void clearMessage() {
        this.messages.clear();
        this.displayedTitle = "";
        this.displayedSubTitle = "";
        this.titlesTimer = 0;
    }

    @Override
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        super.render(guiGraphics, deltaTracker);
        if (!this.messages.isEmpty() || this.titlesTimer != 0) {
            this.draw(guiGraphics, deltaTracker);
        }
    }

    @SubscribeEvent
    public void clientTick(ClientTickEvent.Pre event) {
        if (!(Minecraft.getInstance().isPaused() || this.messages.isEmpty() && this.titlesTimer == 0)) {
            this.tick();
        }
    }

    public void displayTitle(String title, String subTitle, int timeFadeIn, int displayTime, int timeFadeOut) {
        if (title == null && subTitle == null && timeFadeIn < 0 && displayTime < 0 && timeFadeOut < 0) {
            this.displayedTitle = "";
            this.titlesTimer = 0;
        } else if (title != null) {
            this.displayedSubTitle = subTitle;
            this.displayedTitle = title;
            this.titleFadeIn = timeFadeIn;
            this.titleDisplayTime = displayTime;
            this.titleFadeOut = timeFadeOut;
            this.titlesTimer = this.titleFadeIn + this.titleDisplayTime + this.titleFadeOut;
        } else if (subTitle != null) {
            this.displayedTitle = "";
            this.displayedSubTitle = subTitle;
            this.titleFadeIn = timeFadeIn;
            this.titleDisplayTime = displayTime;
            this.titleFadeOut = timeFadeOut;
            this.titlesTimer = this.titleFadeIn + this.titleDisplayTime + this.titleFadeOut;
        } else {
            if (timeFadeIn >= 0) {
                this.titleFadeIn = timeFadeIn;
            }
            if (displayTime >= 0) {
                this.titleDisplayTime = displayTime;
            }
            if (timeFadeOut >= 0) {
                this.titleFadeOut = timeFadeOut;
            }
            if (this.titlesTimer > 0) {
                this.titlesTimer = this.titleFadeIn + this.titleDisplayTime + this.titleFadeOut;
            }
        }
    }

    public void draw(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        this.scaledWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        this.scaledHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        if (this.titlesTimer > 0) {
            float f4 = (float)this.titlesTimer - deltaTracker.getGameTimeDeltaPartialTick(true);
            int j1 = 255;
            if (this.titlesTimer > this.titleFadeOut + this.titleDisplayTime) {
                float f5 = (float)(this.titleFadeIn + this.titleDisplayTime + this.titleFadeOut) - f4;
                j1 = (int)(f5 * 255.0f / (float)this.titleFadeIn);
            }
            if (this.titlesTimer <= this.titleFadeOut) {
                j1 = (int)(f4 * 255.0f / (float)this.titleFadeOut);
            }
            if ((j1 = Mth.clamp((int)j1, (int)0, (int)255)) > 8) {
                PoseStack matrixStack = guiGraphics.pose();
                matrixStack.pushPose();
                matrixStack.translate(this.scaledWidth / 2.0f, this.scaledHeight / 2.0f, 0.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                matrixStack.pushPose();
                matrixStack.scale(4.0f, 4.0f, 4.0f);
                int l1 = j1 << 24 & 0xFF000000;
                int i2 = this.font.width(Utils.translateToLocal(this.displayedTitle, new Object[0]));
                this.renderTextBackground(guiGraphics, -10, i2);
                guiGraphics.drawString(Minecraft.getInstance().font, Utils.translateToLocal(this.displayedTitle, new Object[0]), (float)(-i2 / 2), -10.0f, 0xFFFFFF | l1, true);
                matrixStack.popPose();
                if (!this.displayedSubTitle.isEmpty()) {
                    matrixStack.pushPose();
                    matrixStack.scale(2.0f, 2.0f, 2.0f);
                    int k = this.font.width(Utils.translateToLocal(this.displayedSubTitle, new Object[0]));
                    this.renderTextBackground(guiGraphics, 5, k);
                    guiGraphics.drawString(Minecraft.getInstance().font, Utils.translateToLocal(this.displayedSubTitle, new Object[0]), (float)(-k / 2), 5.0f, 0xFFFFFF | l1, true);
                    matrixStack.popPose();
                }
                RenderSystem.disableBlend();
                matrixStack.popPose();
            }
        }
    }

    protected void renderTextBackground(GuiGraphics guiGraphics, int yIn, int stringWidthIn) {
        int i = Minecraft.getInstance().options.getBackgroundColor(0.0f);
        if (i != 0) {
            int j = -stringWidthIn / 2;
            guiGraphics.fill(j - 2, yIn - 2, j + stringWidthIn + 2, yIn + 9 + 2, i);
        }
    }

    public void tick() {
        if (this.titlesTimer > 0) {
            --this.titlesTimer;
            if (this.titlesTimer <= 0) {
                this.displayedTitle = "";
                this.displayedSubTitle = "";
            }
        }
        if (!this.messages.isEmpty() && this.titlesTimer == 0) {
            Utils.Title t = this.messages.poll();
            this.displayTitle(t.title, t.subtitle, t.fadeIn, t.displayTime, t.fadeOut);
        }
    }
}

