/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.synthesis;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterable;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuStockItem;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.KKAccessoryItem;
import online.kingdomkeys.kingdomkeys.item.KKArmorItem;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSCloseMoogleGUI;
import online.kingdomkeys.kingdomkeys.network.cts.CSOpenMenu;
import online.kingdomkeys.kingdomkeys.network.cts.CSShopBuy;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopItem;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopList;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopListRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class ShopScreen
extends MenuFilterable {
    MenuBox boxL;
    MenuBox boxM;
    MenuButton create;
    private MenuButton back;
    SynthesisScreen parent;

    public ShopScreen(PlayerData playerData, SynthesisScreen parent) {
        super("gui.shop.main.title", new Color(255, 0, 0));
        this.drawSeparately = true;
        this.parent = parent;
        parent.playerData = playerData;
    }

    public ShopScreen(PlayerData playerData, String nbt, SynthesisScreen parent) {
        this(playerData, parent);
    }

    public ShopList getShopList() {
        return ShopListRegistry.getInstance().getRegistry().get(ResourceLocation.parse((String)this.parent.invFile));
    }

    protected void action(String string) {
        switch (string) {
            case "create": {
                PacketHandler.sendToServer(new CSShopBuy(ResourceLocation.parse((String)this.parent.invFile), this.selectedItemStack));
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.itemget.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void init() {
        float boxPosX = (float)this.width * 0.2f;
        float topBarHeight = (float)this.height * 0.17f;
        float boxWidth = (float)this.width * 0.3f;
        float middleHeight = (float)this.height * 0.6f;
        this.boxL = new MenuBox((int)boxPosX, (int)topBarHeight, (int)boxWidth, (int)middleHeight, 1.0f, new Color(100, 4, 4));
        this.boxM = new MenuBox((int)boxPosX + (int)boxWidth, (int)topBarHeight, (int)(boxWidth * 0.7f), (int)middleHeight, 1.0f, new Color(100, 4, 4));
        int scrollTop = (int)topBarHeight;
        int scrollBot = (int)((float)scrollTop + middleHeight);
        float filterPosX = (float)this.width * 0.3f;
        float filterPosY = (float)this.height * 0.02f;
        this.filterBar = new MenuFilterBar((int)filterPosX, (int)filterPosY, this);
        this.filterBar.init();
        this.scrollBar = new MenuScrollBar((int)(boxPosX + boxWidth - 17.0f), scrollTop, scrollBot, (int)middleHeight, 0);
        this.addRenderableWidget((GuiEventListener)this.scrollBar);
        this.initItems();
        this.buttonPosX -= 10.0f;
        this.buttonWidth = (float)this.width * 0.07f;
        super.init();
    }

    @Override
    public void initItems() {
        int i;
        float invPosX = (float)this.boxL.getX() + 4.0f;
        float invPosY = (float)this.height * 0.1851f;
        this.inventory.clear();
        this.children().clear();
        this.renderables.clear();
        this.filterBar.buttons.forEach(x$0 -> {
            Button cfr_ignored_0 = (Button)this.addWidget((GuiEventListener)x$0);
        });
        ShopList shopList = this.getShopList();
        ArrayList<ResourceLocation> items = new ArrayList<ResourceLocation>();
        for (i = 0; i < shopList.getList().size(); ++i) {
            Object itemName = null;
            ShopItem shopItem = shopList.getList().get(i);
            if (shopItem != null) {
                ResourceLocation recipeRL = Utils.getItemRegistryName(shopItem.getResult());
                ItemStack stack = new ItemStack((ItemLike)shopItem.getResult());
                if (shopItem.getResult() instanceof KeychainItem) {
                    stack = new ItemStack((ItemLike)((KeychainItem)shopItem.getResult()).getKeyblade());
                }
                if (!this.filterItem(stack)) continue;
                items.add(recipeRL);
                continue;
            }
            KingdomKeys.LOGGER.error(String.valueOf(itemName) + " is not a valid recipe, check it");
        }
        items.sort(Comparator.comparing(Utils::getCategoryForShop).thenComparing(stackRL -> new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(stackRL)).getHoverName().getContents().toString()));
        for (i = 0; i < items.size(); ++i) {
            ItemStack itemStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get((ResourceLocation)items.get(i)));
            if (itemStack != null && itemStack.getItem() instanceof KeychainItem) {
                itemStack = new ItemStack((ItemLike)((KeychainItem)itemStack.getItem()).getKeyblade());
            }
            MenuStockItem item = new MenuStockItem((MenuFilterable)this, (ResourceLocation)items.get(i), itemStack, (int)invPosX, (int)invPosY + i * 14, this.boxL.getWidth() - this.scrollBar.getWidth() - 6, false);
            item.setBackgroundColor(new Color(80, 10, 10));
            this.inventory.add(item);
        }
        this.inventory.forEach(x$0 -> {
            MenuStockItem cfr_ignored_0 = (MenuStockItem)this.addWidget((GuiEventListener)x$0);
        });
        super.init();
        this.create = new MenuButton(this.boxM.getX() + this.boxM.getWidth() / 2 - (int)(this.buttonWidth + 22.0f) / 2, (int)((double)this.height * 0.67), (int)this.buttonWidth, "gui.shop.buy", MenuButton.ButtonType.ROUNDBUTTON, e -> this.action("create"));
        this.create.setCenterText(true);
        this.addRenderableWidget((GuiEventListener)this.create);
        this.back = new MenuButton((int)this.buttonPosX, this.buttonPosY, (int)this.buttonWidth / 2, Component.translatable((String)"gui.menu.back").getString(), MenuButton.ButtonType.BUTTON, b -> this.minecraft.setScreen((Screen)new SynthesisScreen(this.parent.playerData, this.parent.invFile, this.parent.name, this.parent.moogle)));
        this.addRenderableWidget((GuiEventListener)this.back);
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
        this.boxL.renderWidget(gui, mouseX, mouseY, partialTicks);
        this.boxM.renderWidget(gui, mouseX, mouseY, partialTicks);
        super.render(gui, mouseX, mouseY, partialTicks);
        if (this.inventory.isEmpty()) {
            return;
        }
        int listHeight = ((MenuStockItem)((Object)this.inventory.get(this.inventory.size() - 1))).getY() + 20 - ((MenuStockItem)((Object)this.inventory.get(0))).getY() + 3;
        this.scrollBar.setContentHeight(listHeight);
        if (this.selectedItemStack != ItemStack.EMPTY) {
            boolean enoughMunny = false;
            boolean enoughTier = false;
            List<ShopItem> list = ShopListRegistry.getInstance().getRegistry().get(ResourceLocation.parse((String)this.parent.invFile)).getList();
            ShopItem item = null;
            for (ShopItem shopItem : list) {
                Object it = shopItem.getResult();
                if (it instanceof KeychainItem) {
                    it = ((KeychainItem)it).getKeyblade();
                }
                if (!ItemStack.isSameItem((ItemStack)new ItemStack((ItemLike)it, shopItem.getAmount()), (ItemStack)this.selectedItemStack)) continue;
                item = shopItem;
                break;
            }
            if (item != null) {
                enoughMunny = this.parent.playerData.getMunny() >= item.getCost();
                enoughTier = (Boolean)ModConfigs.SERVER.requireSynthTier.get() == false || this.parent.playerData.getSynthLevel() >= item.getTier();
                this.create.visible = true;
                boolean bl = this.create.active = enoughMunny && enoughTier;
                if (this.minecraft.player.getInventory().getFreeSlot() == -1) {
                    this.create.active = false;
                    this.create.setMessage((Component)Component.translatable((String)"gui.shop.no_empty_slot"));
                }
            }
            this.create.visible = item != null;
        } else {
            this.create.visible = false;
        }
        for (Renderable renderable : this.inventory) {
            if (renderable instanceof MenuStockItem) {
                MenuStockItem menuStockItem = (MenuStockItem)renderable;
                menuStockItem.active = true;
                gui.enableScissor(this.boxL.getX() + 2, this.scrollBar.getY() + 2, this.boxL.getX() + this.boxL.getWidth(), this.scrollBar.getBottom() - 5);
                renderable.render(gui, mouseX, mouseY, partialTicks);
                gui.disableScissor();
                continue;
            }
            renderable.render(gui, mouseX, mouseY, partialTicks);
        }
        this.create.render(gui, mouseX, mouseY, partialTicks);
        this.back.render(gui, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderSelectedData(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        Object line;
        PoseStack matrixStack = gui.pose();
        float tooltipPosX = (float)this.width * 0.3333f;
        float tooltipPosY = (float)this.height * 0.8f;
        float iconPosY = this.boxM.getPosY() + 25;
        PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
        matrixStack.pushPose();
        double offset = (float)this.boxM.getWidth() * 0.1f;
        matrixStack.translate((double)this.boxM.getX() + offset / 2.0, (double)iconPosY, 1.0);
        List<ShopItem> list = ShopListRegistry.getInstance().getRegistry().get(ResourceLocation.parse((String)this.parent.invFile)).getList();
        ShopItem item = null;
        for (ShopItem shopItem : list) {
            Object it = shopItem.getResult();
            if (it instanceof KeychainItem) {
                it = ((KeychainItem)it).getKeyblade();
            }
            if (!ItemStack.isSameItem((ItemStack)new ItemStack((ItemLike)it, shopItem.getAmount()), (ItemStack)this.selectedItemStack)) continue;
            item = shopItem;
            break;
        }
        if (item != null) {
            gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.shop.cost", new Object[0]) + " ", 2, -20, Color.yellow.getRGB());
            line = item.getCost() + " " + Utils.translateToLocal("gui.menu.main.munny", new Object[0]);
            gui.drawString(this.minecraft.font, (String)line, this.boxM.getWidth() - this.minecraft.font.width((String)line) - 10, -20, item.getCost() > playerData.getMunny() ? Color.RED.getRGB() : Color.GREEN.getRGB());
            if (((Boolean)ModConfigs.SERVER.requireSynthTier.get()).booleanValue()) {
                gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.shop.tier", new Object[0]) + " ", 2, -10, Color.yellow.getRGB());
                line = Utils.getTierFromInt(item.getTier()) + " - " + (10 + item.getTier() * 2) + " " + Utils.translateToLocal("gui.synthesis.exp", new Object[0]);
                gui.drawString(this.minecraft.font, (String)line, this.boxM.getWidth() - this.minecraft.font.width((String)line) - 10, -10, item.getTier() > playerData.getSynthLevel() ? Color.RED.getRGB() : Color.GREEN.getRGB());
            }
            matrixStack.pushPose();
            float size = 80.0f;
            matrixStack.translate((float)this.boxM.getWidth() * 0.7f / 2.0f, (float)this.boxM.getHeight() * 0.6f - size / 2.0f, 0.0f);
            ClientUtils.drawItemAsIcon(this.selectedItemStack, matrixStack, 0, -30, (int)size);
            matrixStack.popPose();
        }
        matrixStack.popPose();
        if (this.selectedItemStack != null && this.selectedItemStack.getItem() instanceof KeybladeItem || this.selectedItemStack.getItem() instanceof KKAccessoryItem || this.selectedItemStack.getItem() instanceof KKArmorItem) {
            Ability a;
            String desc = "";
            String ability = "";
            line = this.selectedItemStack.getItem();
            if (line instanceof KeybladeItem) {
                KeybladeItem kb = (KeybladeItem)line;
                desc = kb.getDesc();
                ability = kb.data.getLevelAbility(0);
            } else {
                line = this.selectedItemStack.getItem();
                if (line instanceof KKAccessoryItem) {
                    KKAccessoryItem accessory = (KKAccessoryItem)line;
                    ability = !accessory.getAbilities().isEmpty() ? accessory.getAbilities().getFirst() : null;
                }
            }
            matrixStack.pushPose();
            matrixStack.translate((double)(this.boxM.getX() + 20), (double)this.height * 0.58, 1.0);
            List<Component> stats = Utils.getResistancesStats(this.selectedItemStack);
            float scale = stats.size() > 4 ? 1.0f - (float)(stats.size() - 4) * 0.25f : 1.0f;
            matrixStack.scale(scale, scale, scale);
            int offset2 = -15;
            for (int i = 0; i < stats.size(); ++i) {
                Component c = stats.get(i);
                gui.drawString(this.minecraft.font, c, 0, offset2 + 10 * i, 0x4444FF);
            }
            if (ability != null && (a = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)ability))) != null) {
                String abilityName = Utils.translateToLocal(a.getTranslationKey(), new Object[0]);
                gui.drawString(this.minecraft.font, abilityName, -20 + this.boxM.getWidth() / 2 - this.minecraft.font.width(abilityName) / 2, (stats.size() - 1) * 10, 0xFFAA44);
            }
            matrixStack.popPose();
            if (!desc.equals("")) {
                matrixStack.pushPose();
                String text = Utils.translateToLocal(this.selectedItemStack.getDescriptionId(), new Object[0]);
                gui.drawString(this.minecraft.font, text, (int)(tooltipPosX + 5.0f), (int)tooltipPosY + 5, 0xFF9900);
                int n = (int)tooltipPosX + 5;
                int n2 = (int)tooltipPosY + 5;
                Objects.requireNonNull(this.minecraft.font);
                ClientUtils.drawSplitString(gui, desc, n, n2 + 9, (int)((float)this.width * 0.6f), 0xFFFFFF);
                matrixStack.popPose();
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        if (this.parent.moogle != -1) {
            PacketHandler.sendToServer(new CSCloseMoogleGUI(this.parent.moogle));
        }
        super.onClose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.scrollBar.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 1) {
            PacketHandler.sendToServer(new CSOpenMenu());
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.mouseReleased(pMouseX, pMouseY, pButton);
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.scrollBar.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        this.updateScroll();
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void updateScroll() {
        this.inventory.forEach(button -> {
            button.offsetY = (int)this.scrollBar.scrollOffset;
        });
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.scrollBar.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        this.updateScroll();
        return false;
    }
}

