/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.synthesis;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterable;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuStockItem;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.KKAccessoryItem;
import online.kingdomkeys.kingdomkeys.item.KKArmorItem;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSCloseMoogleGUI;
import online.kingdomkeys.kingdomkeys.network.cts.CSOpenMenu;
import online.kingdomkeys.kingdomkeys.network.cts.CSSynthesiseRecipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class SynthesisCreateScreen
extends MenuFilterable {
    MenuBox boxL;
    MenuBox boxM;
    MenuBox boxRT;
    MenuBox boxRB;
    MenuButton create;
    private MenuButton back;
    SynthesisScreen parent;

    public SynthesisCreateScreen(PlayerData playerData, SynthesisScreen parent) {
        super("gui.synthesis.synthesise.title", new Color(0, 255, 0));
        this.drawSeparately = true;
        this.parent = parent;
        parent.playerData = playerData;
    }

    protected void action(String string) {
        switch (string) {
            case "create": {
                PacketHandler.sendToServer(new CSSynthesiseRecipe(this.selectedRL));
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.itemget.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void init() {
        float boxPosX = (float)this.width * 0.1437f;
        float topBarHeight = (float)this.height * 0.17f;
        float boxWidth = (float)this.width * 0.3f;
        float middleHeight = (float)this.height * 0.6f;
        this.boxL = new MenuBox((int)boxPosX, (int)topBarHeight, (int)boxWidth, (int)middleHeight, 1.0f, new Color(40, 4, 255));
        this.boxM = new MenuBox((int)boxPosX + (int)boxWidth, (int)topBarHeight, (int)(boxWidth * 0.7f), (int)middleHeight, 1.0f, new Color(108, 40, 40));
        this.boxRT = new MenuBox(this.boxM.getX() + (int)(boxWidth * 0.7f), (int)topBarHeight, (int)(boxWidth * 1.17f), (int)(middleHeight * 0.2f), 1.0f, new Color(0, 0, 0));
        this.boxRB = new MenuBox(this.boxM.getX() + (int)(boxWidth * 0.7f), (int)topBarHeight + this.boxRT.getHeight(), (int)(boxWidth * 1.17f), (int)(middleHeight - (float)this.boxRT.getHeight()), 1.0f, new Color(4, 68, 4));
        int scrollTop = (int)topBarHeight;
        int scrollBot = (int)((float)scrollTop + middleHeight);
        this.scrollBar = new MenuScrollBar((int)(boxPosX + boxWidth - 17.0f), scrollTop, scrollBot, (int)middleHeight, 0);
        this.scrollBar2 = new MenuScrollBar(this.boxRB.getX() + this.boxRB.getWidth() - 17, this.boxRB.getY(), this.boxRB.getY() + this.boxRB.getHeight(), (int)middleHeight, 0);
        this.addRenderableWidget((GuiEventListener)this.scrollBar);
        this.addRenderableWidget((GuiEventListener)this.scrollBar2);
        float filterPosX = (float)this.width * 0.3f;
        float filterPosY = (float)this.height * 0.02f;
        this.filterBar = new MenuFilterBar((int)filterPosX, (int)filterPosY, this);
        this.filterBar.init();
        this.initItems();
        this.buttonPosX -= 10.0f;
        this.buttonWidth = (float)this.width * 0.07f;
        super.init();
    }

    @Override
    public void initItems() {
        int i;
        float invPosX = (float)this.width * 0.1494f;
        float invPosY = (float)this.height * 0.1851f;
        this.inventory.clear();
        this.children().clear();
        this.renderables.clear();
        this.filterBar.buttons.forEach(x$0 -> {
            Button cfr_ignored_0 = (Button)this.addWidget((GuiEventListener)x$0);
        });
        ArrayList<ResourceLocation> items = new ArrayList<ResourceLocation>();
        for (i = 0; i < this.parent.playerData.getKnownRecipeList().size(); ++i) {
            ResourceLocation itemName = this.parent.playerData.getKnownRecipeList().get(i);
            Recipe recipe = RecipeRegistry.getInstance().getValue(itemName);
            if (recipe != null) {
                ResourceLocation recipeRL = recipe.getRegistryName();
                ItemStack stack2 = new ItemStack((ItemLike)recipe.getResult());
                if (recipe.getResult() instanceof KeychainItem) {
                    stack2 = new ItemStack((ItemLike)((KeychainItem)recipe.getResult()).getKeyblade());
                }
                if (!this.filterItem(stack2)) continue;
                items.add(recipeRL);
                continue;
            }
            KingdomKeys.LOGGER.error(String.valueOf(itemName) + " is not a valid recipe, check it");
        }
        items.sort(Comparator.comparing(Utils::getCategoryForRecipe).thenComparing(stack -> new ItemStack((ItemLike)RecipeRegistry.getInstance().getValue((ResourceLocation)stack).getResult()).getHoverName().getContents().toString()));
        for (i = 0; i < items.size(); ++i) {
            ItemStack itemStack = new ItemStack((ItemLike)RecipeRegistry.getInstance().getValue((ResourceLocation)items.get(i)).getResult());
            if (itemStack != null && itemStack.getItem() instanceof KeychainItem) {
                itemStack = new ItemStack((ItemLike)((KeychainItem)RecipeRegistry.getInstance().getValue((ResourceLocation)items.get(i)).getResult()).getKeyblade());
            }
            MenuStockItem item = new MenuStockItem((MenuFilterable)this, (ResourceLocation)items.get(i), itemStack, (int)invPosX, (int)invPosY + i * 14, this.boxL.getWidth() - this.scrollBar.getWidth() - 6, false);
            item.setBackgroundColor(new Color(30, 30, 100));
            this.inventory.add(item);
        }
        this.inventory.forEach(x$0 -> {
            MenuStockItem cfr_ignored_0 = (MenuStockItem)this.addWidget((GuiEventListener)x$0);
        });
        super.init();
        this.create = new MenuButton(this.boxM.getX() + this.boxM.getWidth() / 2 - (int)(this.buttonWidth + 22.0f) / 2, (int)((double)this.height * 0.67), (int)this.buttonWidth, "gui.synthesis.synthesise.create", MenuButton.ButtonType.ROUNDBUTTON, e -> this.action("create"));
        this.create.setCenterText(true);
        this.addRenderableWidget((GuiEventListener)this.create);
        this.back = new MenuButton((int)this.buttonPosX, this.buttonPosY, (int)this.buttonWidth / 2, Component.translatable((String)"gui.menu.back").getString(), MenuButton.ButtonType.BUTTON, b -> this.minecraft.setScreen((Screen)new SynthesisScreen(this.parent.playerData, this.parent.invFile, this.parent.name, this.parent.moogle)));
        this.addRenderableWidget((GuiEventListener)this.back);
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
        this.boxL.renderWidget(gui, mouseX, mouseY, partialTicks);
        this.boxM.renderWidget(gui, mouseX, mouseY, partialTicks);
        this.boxRB.renderWidget(gui, mouseX, mouseY, partialTicks);
        this.boxRT.renderWidget(gui, mouseX, mouseY, partialTicks);
        super.render(gui, mouseX, mouseY, partialTicks);
        if (!this.inventory.isEmpty()) {
            int listHeight = ((MenuStockItem)((Object)this.inventory.get(this.inventory.size() - 1))).getY() + 20 - ((MenuStockItem)((Object)this.inventory.get(0))).getY() + 3;
            this.scrollBar.setContentHeight(listHeight);
        }
        if (this.selectedItemStack != ItemStack.EMPTY) {
            PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
            boolean enoughMats = true;
            boolean enoughMunny = false;
            boolean enoughTier = false;
            boolean enoughSpace = false;
            if (RecipeRegistry.getInstance().containsKey(this.selectedRL)) {
                Recipe recipe = RecipeRegistry.getInstance().getValue(this.selectedRL);
                enoughSpace = Utils.getFreeSlotsForPlayer((Player)this.minecraft.player) >= Utils.stacksForItemAmount(new ItemStack((ItemLike)recipe.getResult()), recipe.getAmount());
                enoughMunny = playerData.getMunny() >= recipe.getCost();
                enoughTier = (Boolean)ModConfigs.SERVER.requireSynthTier.get() == false || playerData.getSynthLevel() >= recipe.getTier();
                this.create.visible = true;
                for (Map.Entry<Item, Integer> m : recipe.getMaterials().entrySet()) {
                    if (playerData.getMaterialAmount(m.getKey()) >= m.getValue()) continue;
                    enoughMats = false;
                }
            }
            boolean bl = this.create.active = enoughMats && enoughMunny && enoughTier && enoughSpace;
            if (!enoughSpace) {
                this.create.setMessage((Component)Component.translatable((String)"gui.shop.no_empty_slot"));
            } else {
                this.create.setMessage((Component)Component.translatable((String)"gui.synthesis.synthesise.create"));
            }
            this.create.visible = RecipeRegistry.getInstance().containsKey(this.selectedRL);
        } else {
            this.create.visible = false;
        }
        for (Renderable renderable : this.inventory) {
            if (renderable instanceof MenuStockItem) {
                MenuStockItem menuStockItem = (MenuStockItem)renderable;
                menuStockItem.active = true;
                gui.enableScissor(this.boxL.getX() + 2, this.scrollBar.getY() + 2, this.boxL.getX() + this.boxL.getWidth(), this.scrollBar.getBottom() - 5);
                renderable.render(gui, mouseX, mouseY, partialTicks);
                gui.disableScissor();
                continue;
            }
            renderable.render(gui, mouseX, mouseY, partialTicks);
        }
        PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
        gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.synthesis.exp.mooglelevel", new Object[0]) + ": " + playerData.getSynthLevel(), this.boxRT.getX() + 7, this.boxRT.getY() + 6, 0xFFFF00);
        String line = Utils.translateToLocal("gui.menu.main.synthesis_tier", new Object[0]) + ": " + Utils.getTierFromInt(playerData.getSynthLevel());
        gui.drawString(this.minecraft.font, line, this.boxRT.getX() + this.boxRT.getWidth() - this.minecraft.font.width(line) - 5, this.boxRT.getY() + 6, 0xFFFFFF);
        line = Utils.translateToLocal("gui.synthesis.exp.nextlevel", new Object[0]) + ": ";
        gui.drawString(this.minecraft.font, line, this.boxRT.getX() + 7, this.boxRT.getY() + 18, 0xFFFF00);
        line = playerData.getSynthLevel() >= 7 ? "0 " + Utils.translateToLocal("gui.synthesis.exp", new Object[0]) : playerData.getSynthExpNeeded(playerData.getSynthLevel(), playerData.getSynthExperience()) + " " + Utils.translateToLocal("gui.synthesis.exp", new Object[0]);
        gui.drawString(this.minecraft.font, line, this.boxRT.getX() + this.boxRT.getWidth() - this.minecraft.font.width(line) - 5, this.boxRT.getY() + 18, 0xFFFFFF);
        this.create.render(gui, mouseX, mouseY, partialTicks);
        this.back.render(gui, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderSelectedData(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        Object color;
        PoseStack matrixStack = gui.pose();
        float tooltipPosX = (float)this.width * 0.3333f;
        float tooltipPosY = (float)this.height * 0.8f;
        float iconPosX = this.boxRT.getX();
        float iconPosY = this.boxRT.getY() + 25;
        PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
        matrixStack.pushPose();
        double offset = (float)this.boxM.getWidth() * 0.1f;
        matrixStack.translate((double)this.boxM.getX() + offset / 2.0, (double)iconPosY, 1.0);
        if (RecipeRegistry.getInstance().containsKey(this.selectedRL)) {
            Recipe recipe = RecipeRegistry.getInstance().getValue(this.selectedRL);
            gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.shop.cost", new Object[0]) + " ", 2, -20, Color.yellow.getRGB());
            String line = recipe.getCost() + " " + Utils.translateToLocal("gui.menu.main.munny", new Object[0]);
            gui.drawString(this.minecraft.font, line, this.boxM.getWidth() - this.minecraft.font.width(line) - 10, -20, recipe.getCost() > playerData.getMunny() ? Color.RED.getRGB() : Color.GREEN.getRGB());
            gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.shop.tier", new Object[0]) + " ", 2, -10, Color.yellow.getRGB());
            line = Utils.getTierFromInt(recipe.getTier()) + " - " + (10 + recipe.getTier() * 2) + " " + Utils.translateToLocal("gui.synthesis.exp", new Object[0]);
            color = Color.GREEN;
            if (recipe.getTier() > playerData.getSynthLevel()) {
                color = (Boolean)ModConfigs.SERVER.requireSynthTier.get() != false ? Color.RED : Color.WHITE;
            }
            gui.drawString(this.minecraft.font, line, this.boxM.getWidth() - this.minecraft.font.width(line) - 10, -10, ((Color)color).getRGB());
        }
        float size = 80.0f;
        matrixStack.translate((float)this.boxM.getWidth() * 0.7f / 2.0f, (float)(this.boxM.getHeight() / 2) - size / 2.0f, 0.0f);
        ClientUtils.drawItemAsIcon(this.selectedItemStack, matrixStack, 0, -10, (int)size);
        matrixStack.popPose();
        if (this.selectedItemStack != null && this.selectedItemStack.getItem() instanceof KeybladeItem || this.selectedItemStack.getItem() instanceof KKAccessoryItem || this.selectedItemStack.getItem() instanceof KKArmorItem) {
            Ability a;
            String desc = "";
            String ability = "";
            color = this.selectedItemStack.getItem();
            if (color instanceof KeybladeItem) {
                KeybladeItem kb = (KeybladeItem)color;
                desc = kb.getDesc();
                ability = kb.data.getLevelAbility(0);
            } else {
                color = this.selectedItemStack.getItem();
                if (color instanceof KKAccessoryItem) {
                    KKAccessoryItem accessory = (KKAccessoryItem)color;
                    ability = !accessory.getAbilities().isEmpty() ? accessory.getAbilities().getFirst() : null;
                }
            }
            matrixStack.pushPose();
            matrixStack.translate((double)(this.boxM.getX() + 20), (double)this.height * 0.58, 1.0);
            List<Component> stats = Utils.getResistancesStats(this.selectedItemStack);
            float scale = stats.size() > 4 ? 1.0f - (float)(stats.size() - 4) * 0.25f : 1.0f;
            matrixStack.scale(scale, scale, scale);
            int offset2 = -10;
            for (int i = 0; i < stats.size(); ++i) {
                Component c = stats.get(i);
                gui.drawString(this.minecraft.font, c, 0, offset2 + 10 * i, 0x4444FF);
            }
            if (ability != null && (a = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)ability))) != null) {
                String abilityName = Utils.translateToLocal(a.getTranslationKey(), new Object[0]);
                gui.drawString(this.minecraft.font, abilityName, -20 + this.boxM.getWidth() / 2 - this.minecraft.font.width(abilityName) / 2, (stats.size() - 1) * 10, 0xFFAA44);
            }
            matrixStack.popPose();
            if (!desc.isEmpty()) {
                matrixStack.pushPose();
                String text = Utils.translateToLocal(this.selectedItemStack.getDescriptionId(), new Object[0]);
                gui.drawString(this.minecraft.font, text, (int)(tooltipPosX + 5.0f), (int)tooltipPosY + 5, 0xFF9900);
                int n = (int)tooltipPosX + 5;
                int n2 = (int)tooltipPosY + 5;
                Objects.requireNonNull(this.minecraft.font);
                ClientUtils.drawSplitString(gui, desc, n, n2 + 9, (int)((float)this.width * 0.6f), 0xFFFFFF);
                matrixStack.popPose();
            }
        }
        if (RecipeRegistry.getInstance().containsKey(this.selectedRL)) {
            Recipe recipe = RecipeRegistry.getInstance().getValue(this.selectedRL);
            Iterator<Map.Entry<Item, Integer>> materials = Utils.getSortedMaterials(recipe.getMaterials()).entrySet().iterator();
            int i = 0;
            int listHeight = this.boxRB.getPosY() + 10 + (recipe.getMaterials().size() + 1) * 16 + 10 - this.boxRB.getPosY() + 10;
            this.scrollBar2.setContentHeight(listHeight);
            int startX = (int)iconPosX + 20;
            int startY = this.boxRB.getPosY() + 10;
            gui.enableScissor(this.boxRB.getX() + 2, this.scrollBar2.getY() + 2, this.boxRB.getX() + this.boxRB.getWidth(), this.scrollBar2.getBottom() - 5);
            while (materials.hasNext()) {
                Map.Entry<Item, Integer> m = materials.next();
                ItemStack stack = new ItemStack((ItemLike)m.getKey());
                String name = Utils.translateToLocal(stack.getDescriptionId(), new Object[0]);
                String mats = " x" + String.valueOf(m.getValue()) + " (" + playerData.getMaterialAmount(m.getKey()) + ")";
                int color2 = playerData.getMaterialAmount(m.getKey()) >= m.getValue() ? 65280 : 0xFF0000;
                ClientUtils.drawScrollingString(gui, this.minecraft.font, (Component)Component.literal((String)name), startX, this.scrollBar2.getX() - this.minecraft.font.width(mats), startY + (int)((float)(i * 16) - this.scrollBar2.scrollOffset), color2, false);
                gui.drawString(this.minecraft.font, mats, this.scrollBar2.getX() - this.minecraft.font.width(mats), startY + (int)((float)(i * 16) - this.scrollBar2.scrollOffset), color2);
                ClientUtils.drawItemAsIcon(stack, matrixStack, startX - 17, this.boxRB.getPosY() + 10 + (int)((float)(i * 16 - 4) - this.scrollBar2.scrollOffset), 16);
                ++i;
            }
            gui.disableScissor();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        if (this.parent.moogle != -1) {
            PacketHandler.sendToServer(new CSCloseMoogleGUI(this.parent.moogle));
        }
        super.onClose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.scrollBar.mouseClicked(mouseX, mouseY, mouseButton);
        this.scrollBar2.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 1) {
            PacketHandler.sendToServer(new CSOpenMenu());
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.mouseReleased(pMouseX, pMouseY, pButton);
        this.scrollBar2.mouseReleased(pMouseX, pMouseY, pButton);
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.scrollBar.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        this.scrollBar2.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        this.updateScroll();
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void updateScroll() {
        this.inventory.forEach(button -> {
            button.offsetY = (int)this.scrollBar.scrollOffset;
        });
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (mouseX >= (double)this.boxL.getX() && mouseX <= (double)(this.scrollBar.getX() + this.scrollBar.getWidth())) {
            this.scrollBar.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }
        if (mouseX >= (double)this.boxRB.getX() && mouseX <= (double)(this.scrollBar2.getX() + this.scrollBar2.getWidth())) {
            this.scrollBar2.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }
        this.updateScroll();
        return false;
    }
}

