/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.synthesis;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterable;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuStockItem;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSCloseMoogleGUI;
import online.kingdomkeys.kingdomkeys.network.cts.CSLevelUpKeybladePacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSOpenMenu;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class SynthesisForgeScreen
extends MenuFilterable {
    int ticks = 0;
    MenuBox boxL;
    MenuBox boxM;
    MenuBox boxR;
    int itemsX = 100;
    int itemsY = 100;
    int itemWidth = 140;
    int itemHeight = 10;
    MenuButton upgrade;
    private MenuButton back;
    SynthesisScreen parent;

    public SynthesisForgeScreen(PlayerData playerData, SynthesisScreen parent) {
        super("gui.synthesis.forge.title", new Color(0, 255, 0));
        this.drawSeparately = true;
        this.parent = parent;
        parent.playerData = playerData;
    }

    /*
     * WARNING - void declaration
     */
    protected void action(String string) {
        switch (string) {
            case "upgrade": {
                PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.itemget.get(), SoundSource.MASTER, 1.0f, 1.0f);
                ItemStack stack = this.selectedItemStack.copy();
                KeychainItem kcItem = (KeychainItem)stack.getItem();
                KeybladeItem item = kcItem.getKeyblade();
                Iterator<Map.Entry<Item, Integer>> itMats = item.data.getLevelData(item.getKeybladeLevel(stack)).getMaterialList().entrySet().iterator();
                boolean hasMaterials = true;
                while (itMats.hasNext()) {
                    Map.Entry<Item, Integer> m = itMats.next();
                    if (playerData.getMaterialAmount(m.getKey()) >= m.getValue()) continue;
                    hasMaterials = false;
                }
                if (hasMaterials) {
                    for (Map.Entry entry : item.data.getLevelData(item.getKeybladeLevel(stack)).getMaterialList().entrySet()) {
                        playerData.removeMaterial((Item)entry.getKey(), (Integer)entry.getValue());
                    }
                    kcItem.setKeybladeLevel(stack, kcItem.getKeybladeLevel(stack) + 1);
                    UUID keybladeID = Utils.getKeybladeID(stack);
                    if (keybladeID != null) {
                        void var11_13;
                        Object var11_12 = null;
                        for (Map.Entry<ResourceLocation, ItemStack> entry : playerData.getEquippedKeychains().entrySet()) {
                            if (!keybladeID.equals(Utils.getKeybladeID(entry.getValue()))) continue;
                            ResourceLocation resourceLocation = entry.getKey();
                        }
                        if (var11_13 != null) {
                            playerData.equipKeychain((ResourceLocation)var11_13, stack);
                        } else {
                            this.minecraft.player.getInventory().setItem(this.minecraft.player.getInventory().findSlotMatchingItem(this.selectedItemStack), stack);
                        }
                    }
                }
                PacketHandler.sendToServer(new CSLevelUpKeybladePacket(this.selectedItemStack));
                this.init();
                this.selectedItemStack = stack;
            }
        }
    }

    public void tick() {
        super.tick();
        ++this.ticks;
    }

    @Override
    public void init() {
        this.ticks = 0;
        float boxPosX = (float)this.width * 0.1437f;
        float topBarHeight = (float)this.height * 0.17f;
        float boxWidth = (float)this.width * 0.3f;
        float middleHeight = (float)this.height * 0.6f;
        this.boxL = new MenuBox((int)boxPosX, (int)topBarHeight, (int)boxWidth, (int)middleHeight, 1.0f, new Color(40, 4, 255));
        this.boxM = new MenuBox((int)boxPosX + (int)boxWidth, (int)topBarHeight, (int)(boxWidth * 0.7f), (int)middleHeight, 1.0f, new Color(108, 40, 40));
        this.boxR = new MenuBox(this.boxM.getX() + (int)(boxWidth * 0.7f), (int)topBarHeight, (int)(boxWidth * 1.17f), (int)middleHeight, 1.0f, new Color(4, 68, 4));
        int scrollTop = (int)topBarHeight;
        int scrollBot = (int)((float)scrollTop + middleHeight);
        this.scrollBar = new MenuScrollBar((int)(boxPosX + boxWidth - 17.0f), scrollTop, scrollBot, (int)middleHeight, 0);
        this.addRenderableWidget((GuiEventListener)this.scrollBar);
        this.scrollBar2 = new MenuScrollBar(this.boxR.getX() + this.boxR.getWidth() - 17, scrollTop, scrollBot, (int)middleHeight, 0);
        this.addRenderableWidget((GuiEventListener)this.scrollBar2);
        this.initItems();
        this.buttonPosX -= 10.0f;
        this.buttonWidth = (float)this.width * 0.07f;
        this.back = new MenuButton((int)this.buttonPosX, this.buttonPosY, (int)this.buttonWidth, Component.translatable((String)"gui.menu.back").getString(), MenuButton.ButtonType.BUTTON, b -> this.minecraft.setScreen((Screen)new SynthesisScreen(this.parent.playerData, this.parent.invFile, this.parent.name, this.parent.moogle)));
        this.addRenderableWidget((GuiEventListener)this.back);
        super.init();
    }

    @Override
    public void initItems() {
        int i;
        LocalPlayer player = this.minecraft.player;
        float invPosX = (float)this.width * 0.1494f;
        float invPosY = (float)this.height * 0.1851f;
        this.inventory.clear();
        this.children().clear();
        this.renderables.clear();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!(player.getInventory().getItem(i).getItem() instanceof KeychainItem)) continue;
            items.add(player.getInventory().getItem(i));
        }
        items.addAll(PlayerData.get((Player)player).getEquippedKeychains().values().stream().filter(itemStack -> !itemStack.isEmpty()).toList());
        items.sort(Comparator.comparing(Utils::getCategoryForStack).thenComparing(stack -> stack.getHoverName().getContents().toString()));
        for (i = 0; i < items.size(); ++i) {
            MenuStockItem item;
            if (((ItemStack)items.get(i)).getItem() instanceof KeychainItem) {
                KeybladeItem kb = ((KeychainItem)((ItemStack)items.get(i)).getItem()).toSummon();
                item = new MenuStockItem((MenuFilterable)this, (ItemStack)items.get(i), (int)invPosX, (int)invPosY + i * 14, this.boxL.getWidth() - this.scrollBar.getWidth() - 6, false, new ItemStack((ItemLike)kb).getHoverName().getString());
            } else {
                item = new MenuStockItem(this, (ItemStack)items.get(i), (int)invPosX, (int)invPosY + i * 14, this.boxL.getWidth() - this.scrollBar.getWidth() - 6, false);
            }
            item.setBackgroundColor(new Color(30, 30, 100));
            this.inventory.add(item);
        }
        this.inventory.forEach(x$0 -> {
            MenuStockItem cfr_ignored_0 = (MenuStockItem)this.addWidget((GuiEventListener)x$0);
        });
        super.init();
        this.upgrade = new MenuButton(this.boxM.getX() + this.boxM.getWidth() / 2 - (int)(this.buttonWidth + 22.0f) / 2, (int)((double)this.height * 0.67), (int)this.buttonWidth, "gui.synthesis.forge.upgrade", MenuButton.ButtonType.ROUNDBUTTON, e -> this.action("upgrade"));
        this.upgrade.setCenterText(true);
        this.addRenderableWidget((GuiEventListener)this.upgrade);
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        KeychainItem keychain;
        Item item;
        PoseStack matrixStack = gui.pose();
        this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
        this.boxL.renderWidget(gui, mouseX, mouseY, partialTicks);
        this.boxM.renderWidget(gui, mouseX, mouseY, partialTicks);
        this.boxR.renderWidget(gui, mouseX, mouseY, partialTicks);
        super.render(gui, mouseX, mouseY, partialTicks);
        if (!this.inventory.isEmpty()) {
            int listHeight = ((MenuStockItem)((Object)this.inventory.get(this.inventory.size() - 1))).getY() + 20 - ((MenuStockItem)((Object)this.inventory.get(0))).getY() + 3;
            this.scrollBar.setContentHeight(listHeight);
        }
        if (this.selectedItemStack != null && !this.selectedItemStack.isEmpty() && (item = this.selectedItemStack.getItem()) instanceof KeychainItem && (keychain = (KeychainItem)item).getKeybladeLevel(this.selectedItemStack) < keychain.getKeyblade().getMaxLevel()) {
            PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
            boolean enoughMats = true;
            if (keychain.getKeybladeLevel(this.selectedItemStack) < keychain.getKeyblade().getMaxLevel()) {
                KeychainItem kChain = (KeychainItem)this.selectedItemStack.getItem();
                KeybladeItem kBlade = kChain.getKeyblade();
                this.upgrade.visible = true;
                for (Map.Entry<Item, Integer> m : kBlade.data.getLevelData(kBlade.getKeybladeLevel(this.selectedItemStack)).getMaterialList().entrySet()) {
                    if (playerData.getMaterialAmount(m.getKey()) >= m.getValue()) continue;
                    enoughMats = false;
                }
            }
            this.upgrade.active = enoughMats && this.ticks > 10;
            this.upgrade.visible = true;
        } else {
            this.upgrade.visible = false;
        }
        for (Renderable renderable : this.inventory) {
            if (renderable instanceof MenuStockItem) {
                MenuStockItem menuStockItem = (MenuStockItem)renderable;
                menuStockItem.active = true;
                gui.enableScissor(this.boxL.getX() + 2, this.scrollBar.getY() + 2, this.boxL.getX() + this.boxL.getWidth(), this.scrollBar.getBottom() - 5);
                renderable.render(gui, mouseX, mouseY, partialTicks);
                gui.disableScissor();
                continue;
            }
            renderable.render(gui, mouseX, mouseY, partialTicks);
        }
        this.upgrade.render(gui, mouseX, mouseY, partialTicks);
        this.back.render(gui, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderSelectedData(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        Item item;
        PoseStack matrixStack = gui.pose();
        float tooltipPosX = (float)this.width * 0.3333f;
        float tooltipPosY = (float)this.height * 0.8f;
        float iconPosX = this.boxR.getX();
        float iconPosY = this.boxR.getY() + 25;
        if (this.selectedItemStack != null && (item = this.selectedItemStack.getItem()) instanceof KeychainItem) {
            KeychainItem kc = (KeychainItem)item;
            KeybladeItem kb = kc.getKeyblade();
            PlayerData playerData = PlayerData.get((Player)this.minecraft.player);
            matrixStack.pushPose();
            double offset = (float)this.boxM.getWidth() * 0.1f;
            matrixStack.translate((double)this.boxM.getX() + offset / 2.0, (double)iconPosY, 1.0);
            float size = 80.0f;
            matrixStack.translate((float)this.boxM.getWidth() * 0.7f / 2.0f, (float)(this.boxM.getHeight() / 2) - size / 2.0f, 0.0f);
            ClientUtils.drawItemAsIcon(new ItemStack((ItemLike)kb), matrixStack, 0, -30, (int)size);
            matrixStack.popPose();
            matrixStack.pushPose();
            String text = Utils.translateToLocal(kb.getDescriptionId(), new Object[0]);
            gui.drawString(this.minecraft.font, text, (int)(tooltipPosX + 5.0f), (int)tooltipPosY + 5, 0xFF9900);
            String string = kb.getDesc();
            int n = (int)tooltipPosX + 5;
            int n2 = (int)tooltipPosY + 5;
            Objects.requireNonNull(this.minecraft.font);
            ClientUtils.drawSplitString(gui, string, n, n2 + 9, (int)((float)this.width * 0.6f), 0xFFFFFF);
            matrixStack.popPose();
            matrixStack.pushPose();
            matrixStack.translate((double)(this.boxM.getX() + 10), (double)this.height * 0.58, 1.0);
            int level = kb.getKeybladeLevel(this.selectedItemStack);
            if (level < kb.getMaxLevel()) {
                Ability a;
                gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.status.level", new Object[0]) + ": " + level + " -> " + (level + 1), 0, -20, 0xFFFF00);
                actualStr = kb.getStrength(level);
                int nextStr = kb.getStrength(level + 1);
                int actualMag = kb.getMagic(level);
                int nextMag = kb.getMagic(level + 1);
                String nextAbility = kb.data.getLevelAbility(level + 1);
                gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.status.strength", new Object[0]) + ": " + actualStr + " -> " + nextStr, 0, -10, 0xFF0000);
                gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.status.magic", new Object[0]) + ": " + actualMag + " -> " + nextMag, 0, 0, 0x4444FF);
                if (nextAbility != null && (a = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)nextAbility))) != null) {
                    gui.drawString(this.minecraft.font, Utils.translateToLocal(a.getTranslationKey(), new Object[0]), 0, 10, 0x44FF44);
                }
            } else {
                gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.status.level", new Object[0]) + ": " + level, 0, -20, 0xFFFF00);
                actualStr = kb.getStrength(kb.getKeybladeLevel(this.selectedItemStack));
                int actualMag = kb.getMagic(kb.getKeybladeLevel(this.selectedItemStack));
                gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.status.strength", new Object[0]) + ": " + actualStr, 0, -10, 0xFF0000);
                gui.drawString(this.minecraft.font, Utils.translateToLocal("gui.menu.status.magic", new Object[0]) + ": " + actualMag, 0, 0, 0x4444FF);
            }
            matrixStack.popPose();
            matrixStack.pushPose();
            if (kb.getKeybladeLevel(this.selectedItemStack) < kb.getMaxLevel()) {
                Iterator<Map.Entry<Item, Integer>> materials = kb.data.getLevelData(kb.getKeybladeLevel(this.selectedItemStack)).getMaterialList().entrySet().iterator();
                int i = 0;
                int n3 = kb.data.getLevelData(kb.getKeybladeLevel(this.selectedItemStack)).getMaterialList().size() * 16;
                Objects.requireNonNull(this.font);
                int listHeight = n3 + 9;
                this.scrollBar2.setContentHeight(listHeight);
                int startX = (int)iconPosX + 20;
                int startY = this.boxR.getPosY() + 10;
                gui.enableScissor(this.boxR.getX() + 2, this.scrollBar2.getY() + 2, this.boxR.getX() + this.boxR.getWidth(), this.scrollBar2.getBottom() - 5);
                while (materials.hasNext()) {
                    Map.Entry<Item, Integer> m = materials.next();
                    ItemStack stack = new ItemStack((ItemLike)m.getKey());
                    String n4 = Utils.translateToLocal(stack.getDescriptionId(), new Object[0]);
                    String mats = " x" + String.valueOf(m.getValue()) + " (" + playerData.getMaterialAmount(m.getKey()) + ")";
                    int color = playerData.getMaterialAmount(m.getKey()) >= m.getValue() ? 65280 : 0xFF0000;
                    ClientUtils.drawScrollingString(gui, this.minecraft.font, (Component)Component.literal((String)n4), startX, this.scrollBar2.getX() - this.minecraft.font.width(mats), startY + (int)((float)(i * 16) - this.scrollBar2.scrollOffset), color, false);
                    gui.drawString(this.minecraft.font, mats, this.scrollBar2.getX() - this.minecraft.font.width(mats), startY + (int)((float)(i * 16) - this.scrollBar2.scrollOffset), color);
                    ClientUtils.drawItemAsIcon(stack, matrixStack, startX - 17, this.boxR.getPosY() + 10 + (int)((float)(i * 16 - 4) - this.scrollBar2.scrollOffset), 16);
                    ++i;
                }
                gui.disableScissor();
            }
            matrixStack.popPose();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        if (this.parent.moogle != -1) {
            PacketHandler.sendToServer(new CSCloseMoogleGUI(this.parent.moogle));
        }
        super.onClose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.scrollBar.mouseClicked(mouseX, mouseY, mouseButton);
        this.scrollBar2.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 1) {
            PacketHandler.sendToServer(new CSOpenMenu());
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.mouseReleased(pMouseX, pMouseY, pButton);
        this.scrollBar2.mouseReleased(pMouseX, pMouseY, pButton);
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.scrollBar.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        this.scrollBar2.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        this.updateScroll();
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void updateScroll() {
        this.inventory.forEach(button -> {
            button.offsetY = (int)this.scrollBar.scrollOffset;
        });
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (mouseX >= (double)this.boxL.getX() && mouseX <= (double)(this.scrollBar.getX() + this.scrollBar.getWidth())) {
            this.scrollBar.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }
        if (mouseX >= (double)this.boxR.getX() && mouseX <= (double)(this.scrollBar2.getX() + this.scrollBar2.getWidth())) {
            this.scrollBar2.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }
        this.updateScroll();
        return false;
    }
}

