/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.synthesis;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterable;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuStockItem;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.lib.Tags;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSCloseMoogleGUI;
import online.kingdomkeys.kingdomkeys.network.cts.CSDepositMaterials;
import online.kingdomkeys.kingdomkeys.network.cts.CSOpenMenu;
import online.kingdomkeys.kingdomkeys.network.cts.CSTakeMaterials;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class SynthesisMaterialScreen
extends MenuFilterable {
    MenuButton deposit;
    MenuButton back;
    MenuButton take;
    MenuBox boxL;
    MenuBox boxR;
    EditBox amountBox;
    SynthesisScreen parent;

    public SynthesisMaterialScreen(PlayerData playerData, SynthesisScreen parent) {
        super("gui.synthesis.materials", new Color(0, 255, 0));
        this.drawPlayerInfo = true;
        this.parent = parent;
        parent.playerData = playerData;
    }

    public SynthesisMaterialScreen(PlayerData playerData, String inv, String name, int moogle) {
        this(playerData, new SynthesisScreen(playerData, inv, name, moogle));
    }

    @Override
    public void action(ResourceLocation stackRL, ItemStack stack) {
        super.action(stackRL, stack);
        int amount = PlayerData.get((Player)this.minecraft.player).getMaterialAmount(stack.getItem());
        this.amountBox.setValue("" + Math.min(64, amount));
    }

    protected void action(String string) {
        switch (string) {
            case "deposit": {
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                LocalPlayer player = this.minecraft.player;
                try {
                    for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                        ItemStack stack = player.getInventory().getItem(i);
                        if (ItemStack.matches((ItemStack)stack, (ItemStack)ItemStack.EMPTY) || !stack.is(Tags.MATERIALS)) continue;
                        this.parent.playerData.addMaterial(stack.getItem(), stack.getCount());
                        player.getInventory().setItem(i, ItemStack.EMPTY);
                    }
                }
                catch (ConcurrentModificationException e) {
                    e.printStackTrace();
                }
                PacketHandler.sendToServer(new CSDepositMaterials(this.parent.invFile, this.parent.name, this.parent.moogle));
                break;
            }
            case "back": {
                this.minecraft.setScreen((Screen)new SynthesisScreen(this.parent.playerData, this.parent.invFile, this.parent.name, this.parent.moogle));
                break;
            }
            case "take": {
                ItemStack selectedItemstack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(this.selectedRL));
                if (ItemStack.isSameItem((ItemStack)selectedItemstack, (ItemStack)ItemStack.EMPTY) || this.minecraft.player.getInventory().getFreeSlot() <= -1) break;
                try {
                    Integer.parseInt(this.amountBox.getValue());
                    PacketHandler.sendToServer(new CSTakeMaterials(new ItemStack((ItemLike)selectedItemstack.getItem()), Integer.parseInt(this.amountBox.getValue()), this.parent.invFile, this.parent.name == null ? "" : this.parent.name, this.parent.moogle));
                    break;
                }
                catch (NumberFormatException e) {
                    KingdomKeys.LOGGER.error("NaN " + this.amountBox.getValue());
                }
            }
        }
    }

    @Override
    public void init() {
        float boxPosX = (float)this.width * 0.2f;
        float topBarHeight = (float)this.height * 0.17f;
        float boxWidth = (float)this.width * 0.33f;
        float middleHeight = (float)this.height * 0.6f;
        this.boxL = new MenuBox((int)boxPosX, (int)topBarHeight, (int)boxWidth, (int)middleHeight, 1.0f, new Color(40, 4, 255));
        this.boxR = new MenuBox(this.boxL.getX() + this.boxL.getWidth(), (int)topBarHeight, (int)boxWidth, (int)middleHeight, 1.0f, new Color(69, 69, 69));
        this.scrollBar = new MenuScrollBar((int)(boxPosX + boxWidth - 17.0f), this.boxL.getY(), this.boxL.getPosY() + this.boxL.getHeight(), (int)middleHeight, 0);
        this.addRenderableWidget((GuiEventListener)this.scrollBar);
        super.init();
        this.initItems();
    }

    @Override
    public void initItems() {
        float buttonPosX = (float)this.width * 0.008f;
        int button_statsY = (int)this.topBarHeight + 10;
        float buttonWidth = (float)this.width * 0.1744f - 20.0f;
        float invPosX = this.boxL.getX();
        float invPosY = (float)this.height * 0.1851f;
        this.inventory.clear();
        this.children().clear();
        this.renderables.clear();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Map.Entry<ResourceLocation, Integer> mat : this.parent.playerData.getMaterialMap().entrySet()) {
            Item item = (Item)BuiltInRegistries.ITEM.get(mat.getKey());
            items.add(new ItemStack((ItemLike)item, mat.getValue().intValue()));
        }
        items.sort(Comparator.comparing(Utils::getCategoryForStack).thenComparing(ItemStack::getDescriptionId));
        for (int i = 0; i < items.size(); ++i) {
            MenuStockItem item = new MenuStockItem(this, (ItemStack)items.get(i), (int)invPosX, (int)invPosY + i * 14, this.boxL.getWidth() - this.scrollBar.getWidth() - 4, true);
            item.setBackgroundColor(new Color(30, 30, 100));
            this.inventory.add(item);
        }
        this.inventory.forEach(x$0 -> {
            MenuStockItem cfr_ignored_0 = (MenuStockItem)this.addWidget((GuiEventListener)x$0);
        });
        this.deposit = new MenuButton((int)buttonPosX, button_statsY, (int)buttonWidth, Utils.translateToLocal("gui.synthesis.materials.deposit", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("deposit"));
        this.addRenderableWidget((GuiEventListener)this.deposit);
        this.back = new MenuButton((int)buttonPosX, button_statsY + 18, (int)buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.addRenderableWidget((GuiEventListener)this.back);
        this.amountBox = new EditBox(this, this.minecraft.font, this.boxR.getX() + 30, (int)(this.topBarHeight + this.middleHeight - 30.0f), this.minecraft.font.width("#####"), 16, (Component)Component.translatable((String)"test")){

            public boolean charTyped(char c, int i) {
                if (Utils.isNumber(c)) {
                    String text = new StringBuilder(this.getValue()).insert(this.getCursorPosition(), c).toString();
                    if (Integer.parseInt(text) > 64) {
                        return false;
                    }
                } else {
                    return false;
                }
                return super.charTyped(c, i);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.amountBox);
        this.take = new MenuButton(this.amountBox.getX() + this.amountBox.getWidth() + 5, (int)(this.topBarHeight + this.middleHeight - 32.0f), 58, "gui.synthesis.materials.take", MenuButton.ButtonType.ROUNDBUTTON, e -> this.action("take"));
        this.take.setCenterText(true);
        this.addRenderableWidget((GuiEventListener)this.take);
        this.take.visible = false;
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = gui.pose();
        this.drawMenuBackground(gui, mouseX, mouseY, partialTicks);
        this.boxL.renderWidget(gui, mouseX, mouseY, partialTicks);
        this.boxR.renderWidget(gui, mouseX, mouseY, partialTicks);
        gui.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        super.render(gui, mouseX, mouseY, partialTicks);
        if (!this.inventory.isEmpty()) {
            int listHeight = ((MenuStockItem)((Object)this.inventory.get(this.inventory.size() - 1))).getY() + 20 - ((MenuStockItem)((Object)this.inventory.get(0))).getY() + 3;
            this.scrollBar.setContentHeight(listHeight);
        }
        if (this.minecraft.player.getInventory().getFreeSlot() == -1) {
            this.take.active = false;
            this.take.setMessage((Component)Component.translatable((String)"gui.shop.no_empty_slot"));
        }
        for (MenuStockItem stockItem : this.inventory) {
            stockItem.active = false;
        }
        for (Renderable renderable : this.inventory) {
            if (renderable instanceof MenuStockItem) {
                MenuStockItem menuStockItem = (MenuStockItem)renderable;
                menuStockItem.active = true;
                gui.enableScissor(this.boxL.getX() + 2, this.scrollBar.getY() + 2, this.boxL.getX() + this.boxL.getWidth(), this.scrollBar.getBottom() - 5);
                renderable.render(gui, mouseX, mouseY, partialTicks);
                gui.disableScissor();
                continue;
            }
            renderable.render(gui, mouseX, mouseY, partialTicks);
        }
        this.deposit.render(gui, mouseX, mouseY, partialTicks);
        this.back.render(gui, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderSelectedData(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = gui.pose();
        this.amountBox.render(gui, mouseX, mouseY, partialTicks);
        this.take.render(gui, mouseX, mouseY, partialTicks);
        this.take.visible = true;
        float iconPosX = this.boxR.getX();
        float iconPosY = this.boxR.getY() + 15;
        matrixStack.pushPose();
        String name = this.selectedItemStack.getHoverName().getString();
        matrixStack.translate((float)(this.boxR.getX() + this.boxR.getWidth() / 2 - this.minecraft.font.width(name) / 2), (float)(this.boxR.getY() + 3), 1.0f);
        gui.drawString(this.minecraft.font, Utils.translateToLocal(name, new Object[0]), 0, 0, 0xFF9900);
        matrixStack.popPose();
        matrixStack.pushPose();
        float size = 80.0f;
        double offset = (float)this.boxR.getWidth() * 0.1f;
        matrixStack.translate((double)this.boxR.getX() + offset / 2.0, (double)iconPosY, 1.0);
        matrixStack.translate((float)this.boxR.getWidth() * 0.7f / 2.0f, (float)(this.boxR.getHeight() / 2) - size / 2.0f, 0.0f);
        ClientUtils.drawItemAsIcon(this.selectedItemStack, matrixStack, 0, 0, (int)size);
        matrixStack.popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.scrollBar.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 1) {
            PacketHandler.sendToServer(new CSOpenMenu());
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.mouseReleased(pMouseX, pMouseY, pButton);
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        this.scrollBar.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        this.updateScroll();
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void updateScroll() {
        this.inventory.forEach(button -> {
            button.offsetY = (int)this.scrollBar.scrollOffset;
        });
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (mouseX >= (double)this.boxL.getX() && mouseX <= (double)(this.scrollBar.getX() + this.scrollBar.getWidth())) {
            this.scrollBar.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }
        this.updateScroll();
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        if (this.parent.moogle != -1) {
            PacketHandler.sendToServer(new CSCloseMoogleGUI(this.parent.moogle));
        }
        super.onClose();
    }
}

