/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.synthesis;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.client.gui.IPlayerDataRequester;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.ShopScreen;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisCreateScreen;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisForgeScreen;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisMaterialScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.item.SynthesisBagItem;
import online.kingdomkeys.kingdomkeys.lib.Tags;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSCloseMoogleGUI;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopListRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.jetbrains.annotations.NotNull;

public class SynthesisScreen
extends MenuBackground
implements IPlayerDataRequester {
    MenuButton synthesise;
    MenuButton forge;
    MenuButton materials;
    MenuButton shop;
    PlayerData playerData;
    String invFile;
    int moogle;
    String name;

    public SynthesisScreen(PlayerData playerData, String name) {
        super(!name.isEmpty() ? name : "gui.synthesis", new Color(0, 255, 0));
        this.invFile = (Boolean)ModConfigs.SERVER.projectorHasShop.get() != false ? "kingdomkeys:default" : "";
        this.moogle = -1;
        this.drawPlayerInfo = true;
        this.playerData = playerData;
    }

    public SynthesisScreen(PlayerData playerData, String inv, String name, int moogle) {
        this(playerData, name == null || name.isEmpty() ? "gui.synthesis" : Component.translatable((String)"gui.synthesis.moogle.title", (Object[])new Object[]{name}).getString());
        this.moogle = moogle;
        this.name = name;
        if (ShopListRegistry.getInstance().containsKey(ResourceLocation.parse((String)inv)) || inv.isEmpty()) {
            this.invFile = inv;
        } else {
            KingdomKeys.LOGGER.error("The Shop '" + inv + "' does not exist or didn't get registered");
            this.invFile = "";
        }
    }

    protected void action(String string) {
        switch (string) {
            case "synthesise": {
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.minecraft.setScreen((Screen)new SynthesisCreateScreen(this.playerData, this));
                break;
            }
            case "forge": {
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.minecraft.setScreen((Screen)new SynthesisForgeScreen(this.playerData, this));
                break;
            }
            case "materials": {
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.minecraft.setScreen((Screen)new SynthesisMaterialScreen(this.playerData, this));
                break;
            }
            case "shop": {
                this.minecraft.level.playSound((Player)this.minecraft.player, this.minecraft.player.blockPosition(), (SoundEvent)ModSounds.menu_in.get(), SoundSource.MASTER, 1.0f, 1.0f);
                this.minecraft.setScreen((Screen)new ShopScreen(this.playerData, this));
            }
        }
    }

    public void onClose() {
        if (this.moogle != -1) {
            PacketHandler.sendToServer(new CSCloseMoogleGUI(this.moogle));
        }
        super.onClose();
    }

    @Override
    public void init() {
        super.init();
        this.renderables.clear();
        float topBarHeight = (float)this.height * 0.17f;
        int button_statsY = (int)topBarHeight + 5;
        float buttonPosX = (float)this.width * 0.03f;
        float buttonWidth = (float)this.width * 0.1744f - 20.0f;
        int pos = 0;
        if (this.invFile != null && !this.invFile.equals("")) {
            this.shop = new MenuButton((int)buttonPosX, button_statsY + pos++ * 18, (int)buttonWidth, Utils.translateToLocal("gui.shop", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("shop"));
            this.addRenderableWidget((GuiEventListener)this.shop);
        }
        this.synthesise = new MenuButton((int)buttonPosX, button_statsY + pos++ * 18, (int)buttonWidth, Utils.translateToLocal("gui.synthesis.synthesise", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("synthesise"));
        this.addRenderableWidget((GuiEventListener)this.synthesise);
        this.forge = new MenuButton((int)buttonPosX, button_statsY + pos++ * 18, (int)buttonWidth, Utils.translateToLocal("gui.synthesis.forge", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("forge"));
        this.addRenderableWidget((GuiEventListener)this.forge);
        this.materials = new MenuButton((int)buttonPosX, button_statsY + pos++ * 18, (int)buttonWidth, Utils.translateToLocal("gui.synthesis.materials", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("materials"));
        this.addRenderableWidget((GuiEventListener)this.materials);
        boolean hasKeychain = false;
        boolean hasMaterial = false;
        LocalPlayer player = Minecraft.getInstance().player;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!hasKeychain && player.getInventory().getItem(i).getItem() instanceof KeychainItem) {
                hasKeychain = true;
            }
            if (!hasMaterial && player.getInventory().getItem(i).is(Tags.MATERIALS)) {
                hasMaterial = true;
            }
            if (!(player.getInventory().getItem(i).getItem() instanceof SynthesisBagItem)) continue;
            IItemHandler bagInv = (IItemHandler)player.getInventory().getItem(i).getCapability(Capabilities.ItemHandler.ITEM);
            for (int j = 0; j < bagInv.getSlots(); ++j) {
                ItemStack bagItem = bagInv.getStackInSlot(j);
                if (ItemStack.matches((ItemStack)bagItem, (ItemStack)ItemStack.EMPTY) || !bagItem.is(Tags.MATERIALS)) continue;
                hasMaterial = true;
            }
        }
        for (ItemStack stack : this.playerData.getEquippedKeychains().values()) {
            if (stack.isEmpty()) continue;
            hasKeychain = true;
            break;
        }
        if (this.playerData.getKnownRecipeList().isEmpty()) {
            this.synthesise.active = false;
        }
        if (!hasKeychain) {
            this.forge.active = false;
        }
        if (this.playerData.getMaterialMap().isEmpty() && !hasMaterial) {
            this.materials.active = false;
        }
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        super.render(gui, mouseX, mouseY, partialTicks);
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void updatePlayerData(PlayerData playerData) {
        this.playerData = playerData;
    }
}

