/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.entity.mob.AssassinEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;

public class AssassinModel<T extends AssassinEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"assassin"), "main");
    private final ModelPart bodyBot;
    private final ModelPart bodyTop;
    private final ModelPart rightArm;
    private final ModelPart rightArmSpike4;
    private final ModelPart rightArmSpike5;
    private final ModelPart rightArmSpike0;
    private final ModelPart rightArmSpike1;
    private final ModelPart rightArmSpike2;
    private final ModelPart rightArmSpike3;
    private final ModelPart leftArm;
    private final ModelPart leftArmSpike4;
    private final ModelPart leftArmSpike5;
    private final ModelPart leftArmSpike0;
    private final ModelPart leftArmSpike1;
    private final ModelPart leftArmSpike2;
    private final ModelPart leftArmSpike3;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart face;
    private final ModelPart helmet;
    private final ModelPart horn1;
    private final ModelPart horn2;
    private final ModelPart rightLegTop;
    private final ModelPart rightLegBot;
    private final ModelPart rightFootTop;
    private final ModelPart rightFootBottom;
    private final ModelPart leftLegTop;
    private final ModelPart leftLegBot;
    private final ModelPart leftFootTop;
    private final ModelPart leftFootBottom;
    private final ModelPart skirtBack;
    private final ModelPart skirtTop;
    List<ClientUtils.ModelAnimation> animation = new ArrayList<ClientUtils.ModelAnimation>();
    protected double distanceMovedTotal = 0.0;

    public AssassinModel(ModelPart root) {
        this.bodyBot = root.getChild("bodyBot");
        this.bodyTop = this.bodyBot.getChild("bodyTop");
        this.rightArm = this.bodyTop.getChild("rightArm");
        this.rightArmSpike4 = this.rightArm.getChild("rightArmSpike4");
        this.rightArmSpike5 = this.rightArmSpike4.getChild("rightArmSpike5");
        this.rightArmSpike0 = this.rightArm.getChild("rightArmSpike0");
        this.rightArmSpike1 = this.rightArmSpike0.getChild("rightArmSpike1");
        this.rightArmSpike2 = this.rightArmSpike1.getChild("rightArmSpike2");
        this.rightArmSpike3 = this.rightArmSpike2.getChild("rightArmSpike3");
        this.leftArm = this.bodyTop.getChild("leftArm");
        this.leftArmSpike4 = this.leftArm.getChild("leftArmSpike4");
        this.leftArmSpike5 = this.leftArmSpike4.getChild("leftArmSpike5");
        this.leftArmSpike0 = this.leftArm.getChild("leftArmSpike0");
        this.leftArmSpike1 = this.leftArmSpike0.getChild("leftArmSpike1");
        this.leftArmSpike2 = this.leftArmSpike1.getChild("leftArmSpike2");
        this.leftArmSpike3 = this.leftArmSpike2.getChild("leftArmSpike3");
        this.neck = this.bodyTop.getChild("neck");
        this.head = this.neck.getChild("head");
        this.face = this.head.getChild("face");
        this.helmet = this.head.getChild("helmet");
        this.horn1 = this.helmet.getChild("horn1");
        this.horn2 = this.helmet.getChild("horn2");
        this.rightLegTop = this.bodyBot.getChild("rightLegTop");
        this.rightLegBot = this.rightLegTop.getChild("rightLegBot");
        this.rightFootTop = this.rightLegBot.getChild("rightFootTop");
        this.rightFootBottom = this.rightFootTop.getChild("rightFootBottom");
        this.leftLegTop = this.bodyBot.getChild("leftLegTop");
        this.leftLegBot = this.leftLegTop.getChild("leftLegBot");
        this.leftFootTop = this.leftLegBot.getChild("leftFootTop");
        this.leftFootBottom = this.leftFootTop.getChild("leftFootBottom");
        this.skirtBack = this.bodyBot.getChild("skirtBack");
        this.skirtTop = this.skirtBack.getChild("skirtTop");
        ClientUtils.ModelAnimation leftLegTopAnim = new ClientUtils.ModelAnimation(this.leftLegTop, -35.0f, -55.0f, -15.0f, 0.0f, true, ClientUtils.Angle.X, this.rightLegTop);
        this.animation.add(leftLegTopAnim);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bodyBot = partdefinition.addOrReplaceChild("bodyBot", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, 0.0f, 0.0f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)10.4f, (float)0.0f));
        PartDefinition bodyTop = bodyBot.addOrReplaceChild("bodyTop", CubeListBuilder.create().texOffs(15, 0).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)-1.2f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = bodyTop.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(22, 8).addBox(-1.5f, -1.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(-0.100000024f, 0.0f, -0.100000024f)), PartPose.offsetAndRotation((float)3.0f, (float)1.1f, (float)1.1f, (float)-1.9199f, (float)0.0f, (float)-3.1416f));
        PartDefinition rightArmSpike4 = rightArm.addOrReplaceChild("rightArmSpike4", CubeListBuilder.create().texOffs(36, 8).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.100000024f, 0.0f, 0.100000024f)), PartPose.offset((float)-0.5f, (float)8.0f, (float)0.0f));
        PartDefinition rightArmSpike5 = rightArmSpike4.addOrReplaceChild("rightArmSpike5", CubeListBuilder.create().texOffs(36, 8).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.19999999f, 0.0f, -0.19999999f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition rightArmSpike0 = rightArm.addOrReplaceChild("rightArmSpike0", CubeListBuilder.create().texOffs(46, 17).mirror().addBox(-6.4f, -1.7f, -0.5f, 8.0f, 5.0f, 1.0f, new CubeDeformation(-2.2f, -1.9f, -0.49f)), PartPose.offset((float)-0.8f, (float)0.5f, (float)0.0f));
        PartDefinition rightArmSpike1 = rightArmSpike0.addOrReplaceChild("rightArmSpike1", CubeListBuilder.create().texOffs(46, 24).mirror().addBox(-6.4f, -1.7f, -0.5f, 8.0f, 5.0f, 1.0f, new CubeDeformation(-2.2f, -1.9f, -0.49f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition rightArmSpike2 = rightArmSpike1.addOrReplaceChild("rightArmSpike2", CubeListBuilder.create().texOffs(46, 17).mirror().addBox(-6.4f, -1.7f, -0.5f, 8.0f, 5.0f, 1.0f, new CubeDeformation(-2.2f, -1.9f, -0.49f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition rightArmSpike3 = rightArmSpike2.addOrReplaceChild("rightArmSpike3", CubeListBuilder.create().texOffs(46, 24).mirror().addBox(-6.4f, -1.7f, -0.5f, 8.0f, 5.0f, 1.0f, new CubeDeformation(-2.2f, -1.9f, -0.49f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftArm = bodyTop.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(22, 8).addBox(-1.5f, -1.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(-0.100000024f, 0.0f, -0.100000024f)), PartPose.offsetAndRotation((float)-3.0f, (float)1.1f, (float)1.1f, (float)4.7124f, (float)0.0f, (float)0.0f));
        PartDefinition leftArmSpike0 = leftArm.addOrReplaceChild("leftArmSpike0", CubeListBuilder.create().texOffs(46, 17).mirror().addBox(-6.4f, -1.7f, -0.5f, 8.0f, 5.0f, 1.0f, new CubeDeformation(-2.2f, -1.9f, -0.49f)), PartPose.offset((float)-0.8f, (float)0.5f, (float)0.0f));
        PartDefinition leftArmSpike1 = leftArmSpike0.addOrReplaceChild("leftArmSpike1", CubeListBuilder.create().texOffs(46, 24).mirror().addBox(-6.4f, -1.7f, -0.5f, 8.0f, 5.0f, 1.0f, new CubeDeformation(-2.2f, -1.9f, -0.49f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftArmSpike2 = leftArmSpike1.addOrReplaceChild("leftArmSpike2", CubeListBuilder.create().texOffs(46, 17).mirror().addBox(-6.4f, -1.7f, -0.5f, 8.0f, 5.0f, 1.0f, new CubeDeformation(-2.2f, -1.9f, -0.49f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftArmSpike3 = leftArmSpike2.addOrReplaceChild("leftArmSpike3", CubeListBuilder.create().texOffs(46, 24).mirror().addBox(-6.4f, -1.7f, -0.5f, 8.0f, 5.0f, 1.0f, new CubeDeformation(-2.2f, -1.9f, -0.49f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftArmSpike4 = leftArm.addOrReplaceChild("leftArmSpike4", CubeListBuilder.create().texOffs(36, 8).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.100000024f, 0.0f, 0.100000024f)), PartPose.offset((float)-0.5f, (float)8.0f, (float)0.0f));
        PartDefinition leftArmSpike5 = leftArmSpike4.addOrReplaceChild("leftArmSpike5", CubeListBuilder.create().texOffs(36, 8).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(-0.19999999f, 0.0f, -0.19999999f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition neck = bodyTop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(35, 0).addBox(-2.0f, 0.0f, 0.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-0.6f, (float)-0.6f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(45, 0).addBox(-2.5f, -2.0f, -0.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition face = head.addOrReplaceChild("face", CubeListBuilder.create().texOffs(28, 20).addBox(-2.5f, -0.5f, -0.5f, 5.0f, 9.0f, 1.0f, new CubeDeformation(-1.0f, 0.0f, -0.4f)), PartPose.offsetAndRotation((float)-1.0f, (float)-2.2f, (float)0.8f, (float)-2.0944f, (float)0.0f, (float)0.0f));
        PartDefinition helmet = head.addOrReplaceChild("helmet", CubeListBuilder.create().texOffs(47, 8).addBox(-2.0f, -2.6f, 1.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)0.0f, (float)0.0f));
        PartDefinition horn1 = helmet.addOrReplaceChild("horn1", CubeListBuilder.create().texOffs(35, 12).addBox(-0.5f, -4.0f, 0.0f, 1.0f, 6.0f, 1.0f, new CubeDeformation(-0.3f, 0.0f, 0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.4f, (float)2.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition horn2 = helmet.addOrReplaceChild("horn2", CubeListBuilder.create().texOffs(41, 13).addBox(-0.5f, -8.0f, 0.0f, 1.0f, 9.0f, 1.0f, new CubeDeformation(-0.3f, 0.0f, 0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.5f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition rightLegTop = bodyBot.addOrReplaceChild("rightLegTop", CubeListBuilder.create().texOffs(0, 9).addBox(-0.2f, -0.2f, 0.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(-0.20000005f, 0.0f, -0.20000005f)), PartPose.offsetAndRotation((float)-1.6f, (float)5.0f, (float)0.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition rightLegBot = rightLegTop.addOrReplaceChild("rightLegBot", CubeListBuilder.create().texOffs(9, 9).addBox(-0.25f, 0.0f, 0.0f, 2.0f, 1.0f, 4.0f, new CubeDeformation(-0.29999995f, 0.0f, 0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.8f, (float)1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightFootTop = rightLegBot.addOrReplaceChild("rightFootTop", CubeListBuilder.create().texOffs(0, 18).addBox(0.25f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)3.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition rightFootBottom = rightFootTop.addOrReplaceChild("rightFootBottom", CubeListBuilder.create().texOffs(6, 15).addBox(0.25f, 0.5f, -6.0f, 1.0f, 1.0f, 6.0f, new CubeDeformation(-0.100000024f, -0.29999998f, 0.0f)), PartPose.offset((float)0.0f, (float)0.8f, (float)0.0f));
        PartDefinition skirtBack = bodyBot.addOrReplaceChild("skirtBack", CubeListBuilder.create().texOffs(0, 23).addBox(-2.0f, 0.0f, -0.4f, 4.0f, 8.0f, 1.0f, new CubeDeformation(0.099999905f, 0.0f, -0.39999998f)), PartPose.offset((float)-2.0f, (float)3.5f, (float)2.9f));
        PartDefinition skirtTop = skirtBack.addOrReplaceChild("skirtTop", CubeListBuilder.create().texOffs(11, 23).addBox(-2.0f, 0.0f, -3.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.099999905f, 0.0f, -0.4000001f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLegTop = bodyBot.addOrReplaceChild("leftLegTop", CubeListBuilder.create().texOffs(0, 9).addBox(-0.2f, -0.2f, 0.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(-0.20000005f, 0.0f, -0.20000005f)), PartPose.offsetAndRotation((float)-4.0f, (float)5.0f, (float)0.0f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition leftLegBot = leftLegTop.addOrReplaceChild("leftLegBot", CubeListBuilder.create().texOffs(9, 9).addBox(-0.25f, 0.0f, 0.0f, 2.0f, 1.0f, 4.0f, new CubeDeformation(-0.29999995f, 0.0f, 0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.8f, (float)1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftFootTop = leftLegBot.addOrReplaceChild("leftFootTop", CubeListBuilder.create().texOffs(0, 18).addBox(0.25f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)3.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition leftFootBottom = leftFootTop.addOrReplaceChild("leftFootBottom", CubeListBuilder.create().texOffs(6, 15).addBox(0.25f, 0.5f, -6.0f, 1.0f, 1.0f, 6.0f, new CubeDeformation(-0.100000024f, -0.29999998f, 0.0f)), PartPose.offset((float)0.0f, (float)0.8f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T ent, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.updateDistanceMovedTotal((Entity)ent);
        if (ent.distanceToSqr(((AssassinEntity)ent).xOld, ((AssassinEntity)ent).yOld, ((AssassinEntity)ent).zOld) > 0.0) {
            for (int i = 0; i < this.animation.size(); ++i) {
                ClientUtils.ModelAnimation m = this.animation.get(i);
                if (m == null || m.model == null) continue;
                if (m.increasing) {
                    m.actVal += 2.0f;
                    if (m.actVal >= m.maxVal) {
                        m.increasing = false;
                    }
                } else {
                    m.actVal -= 2.0f;
                    if (m.actVal <= m.minVal) {
                        m.increasing = true;
                    }
                }
                m.model.xRot = (float)Math.toRadians(m.actVal);
                if (m.modelCounterpart == null) continue;
                m.modelCounterpart.xRot = (float)Math.toRadians(m.defVal * 2.0f - m.actVal);
            }
        } else {
            this.leftLegTop.xRot = this.rightLegTop.xRot = (float)Math.toRadians(-35.0);
            this.leftLegBot.xRot = this.rightLegBot.xRot = (float)Math.toRadians(10.0);
            this.leftFootTop.xRot = this.rightFootTop.xRot = (float)Math.toRadians(25.0);
        }
        if (((BaseKHEntity)ent).getState() == 0) {
            this.rightArm.yRot = (float)Math.toRadians(0.0);
            this.rightArm.zRot = (float)Math.toRadians(180.0);
            this.leftArm.xRot = (float)Math.toRadians(270.0);
            this.leftArm.yRot = (float)Math.toRadians(0.0);
            this.leftArm.zRot = (float)Math.toRadians(0.0);
        } else if (((BaseKHEntity)ent).getState() == 1) {
            this.rightArm.xRot = (float)Math.toRadians(270.0);
            this.rightArm.yRot = (float)Math.toRadians(90 - ((AssassinEntity)ent).tickCount * 50);
            this.rightArm.zRot = (float)Math.toRadians(90.0);
            this.leftArm.xRot = (float)Math.toRadians(270.0);
            this.leftArm.yRot = (float)Math.toRadians(-90 - ((AssassinEntity)ent).tickCount * 50);
            this.leftArm.zRot = (float)Math.toRadians(90.0);
        } else if (((BaseKHEntity)ent).getState() == 2) {
            this.leftLegTop.xRot = (float)Math.toRadians(-135.0);
            this.rightLegTop.xRot = (float)Math.toRadians(-135.0);
            this.leftLegBot.xRot = (float)Math.toRadians(90.0);
            this.rightLegBot.xRot = (float)Math.toRadians(90.0);
            this.leftArm.yRot = (float)Math.toRadians(110.0);
            this.rightArm.yRot = (float)Math.toRadians(110.0);
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int colour) {
        this.bodyBot.render(poseStack, buffer, packedLight, packedOverlay);
    }

    protected void updateDistanceMovedTotal(Entity e) {
        this.distanceMovedTotal += e.distanceToSqr(e.xOld, e.yOld, e.zOld);
    }

    protected double getDistanceMovedTotal() {
        return this.distanceMovedTotal;
    }
}

