/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;

@OnlyIn(value=Dist.CLIENT)
public class DragoonModel<T extends BaseKHEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"dragoon"), "main");
    private final ModelPart right_leg;
    private final ModelPart left_leg;
    private final ModelPart body;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart head;
    private final ModelPart right_wing;
    private final ModelPart left_wing;
    List<ClientUtils.ModelAnimation> animation = new ArrayList<ClientUtils.ModelAnimation>();

    public DragoonModel(ModelPart root) {
        this.right_leg = root.getChild("body").getChild("right_leg");
        this.left_leg = root.getChild("body").getChild("left_leg");
        this.body = root.getChild("body");
        this.left_arm = root.getChild("body").getChild("left_arm");
        this.right_arm = root.getChild("body").getChild("right_arm");
        this.head = root.getChild("body").getChild("head");
        this.right_wing = root.getChild("body").getChild("right_wing");
        this.left_wing = root.getChild("body").getChild("left_wing");
        ClientUtils.ModelAnimation rightWingAnim = new ClientUtils.ModelAnimation(this.right_wing, 0.0f, -40.0f, 40.0f, 0.0f, true, ClientUtils.Angle.Y, this.left_wing);
        this.animation.add(rightWingAnim);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 10).addBox(-4.0917f, 7.2918f, -3.9461f, 8.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(42, 40).addBox(-2.9917f, 5.2918f, -3.9461f, 6.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(28, 24).addBox(-2.9917f, -2.2082f, 2.3039f, 1.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(34, 87).addBox(2.0083f, -2.2082f, 2.3039f, 1.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.0083f, (float)-6.7918f, (float)3.6961f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -2.0f, -2.5f, 8.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0083f, (float)0.2918f, (float)0.5539f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(102, 66).addBox(-4.0f, 1.5f, -2.5f, 8.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 40).addBox(-4.0f, -1.5f, -2.5f, 8.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(60, 40).addBox(-4.0f, -2.5f, -0.5f, 8.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0083f, (float)3.7918f, (float)-0.4461f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = body.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(81, 35).addBox(-3.25f, -0.75f, -0.75f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(17, 93).addBox(-0.5f, -0.25f, -0.75f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.2583f, (float)11.0418f, (float)-1.4461f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = body.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(91, 90).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(83, 0).addBox(0.25f, -0.75f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.2417f, (float)10.0418f, (float)-1.6961f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(16, 26).addBox(-1.0f, -1.702f, 4.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0083f, (float)8.9938f, (float)1.3039f));
        PartDefinition cube_r5 = tail.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(90, 26).addBox(-1.0f, -1.5f, 0.75f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.298f, (float)10.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = tail.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(12, 70).addBox(-1.0f, -2.5f, -2.5f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.298f, (float)2.25f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = body.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offset((float)3.0083f, (float)11.3032f, (float)-1.3159f));
        PartDefinition cube_r7 = left_leg.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(44, 0).addBox(-2.0f, -5.5f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.9886f, (float)-0.1302f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = left_leg.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(77, 66).addBox(-1.5f, -2.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)9.4886f, (float)-0.1302f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition left_foot = left_leg.addOrReplaceChild("left_foot", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)18.4886f, (float)-0.6302f));
        PartDefinition cube_r9 = left_foot.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(100, 17).addBox(-0.5f, -0.5654f, -2.4986f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-2.7464f, (float)-0.4776f, (float)1.309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r10 = left_foot.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(49, 101).addBox(0.3192f, -0.5f, -2.5224f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-2.7464f, (float)-0.4776f, (float)1.2752f, (float)-0.0779f, (float)-0.2502f));
        PartDefinition cube_r11 = left_foot.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(72, 4).addBox(-1.5f, -1.0f, -0.5f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-2.7464f, (float)-0.4776f, (float)1.2654f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r12 = left_foot.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(87, 101).addBox(-1.3192f, -0.5f, -2.5224f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-2.7464f, (float)-0.4776f, (float)1.2752f, (float)0.0779f, (float)0.2502f));
        PartDefinition cube_r13 = left_foot.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(80, 98).addBox(-1.0f, -1.25f, -1.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-6.5f, (float)1.25f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = body.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offset((float)-2.9917f, (float)11.7042f, (float)-1.802f));
        PartDefinition cube_r14 = right_leg.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(63, 18).addBox(-2.0f, -9.9732f, -2.6924f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.997f, (float)-5.8935f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r15 = right_leg.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(77, 27).addBox(-1.5f, -5.647f, -0.5398f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)9.5361f, (float)-4.7315f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition right_foot = right_leg.addOrReplaceChild("right_foot", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)18.5875f, (float)0.8559f));
        PartDefinition cube_r16 = right_foot.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(94, 101).addBox(-0.5f, 0.8053f, -4.5382f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-9.0514f, (float)-5.5874f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r17 = right_foot.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(101, 101).addBox(-0.1928f, 0.9584f, -4.433f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-9.0514f, (float)-5.5874f, (float)1.0192f, (float)-0.1395f, (float)-0.2223f));
        PartDefinition cube_r18 = right_foot.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(72, 59).addBox(-1.5f, 0.4584f, -2.4779f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-9.0514f, (float)-5.5874f, (float)1.0036f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r19 = right_foot.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(102, 21).addBox(-0.8072f, 0.9584f, -4.433f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-9.0514f, (float)-5.5874f, (float)1.0192f, (float)0.1395f, (float)0.2223f));
        PartDefinition cube_r20 = right_foot.addOrReplaceChild("cube_r20", CubeListBuilder.create().texOffs(93, 19).addBox(-1.0f, -1.7108f, 0.5931f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-9.0514f, (float)-5.5874f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing = body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(90, 13).addBox(-0.5f, -2.0f, -0.42f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5083f, (float)-0.2082f, (float)5.7239f));
        PartDefinition cube_r21 = left_wing.addOrReplaceChild("cube_r21", CubeListBuilder.create().texOffs(42, 40).addBox(0.75f, 11.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(73, 66).addBox(0.25f, 10.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(99, 74).addBox(-0.25f, 8.5f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(9, 89).addBox(-0.75f, 3.5f, -0.5f, 4.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(61, 100).addBox(-3.5f, -1.5f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.6832f, (float)-0.6823f, (float)0.08f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        PartDefinition cube_r22 = left_wing.addOrReplaceChild("cube_r22", CubeListBuilder.create().texOffs(97, 89).addBox(-3.0008f, -6.4807f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(63, 95).addBox(-3.0008f, -9.3807f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(32, 17).addBox(-2.9992f, 8.4807f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(101, 13).addBox(-3.4992f, 6.4807f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(98, 65).addBox(-3.9992f, 4.4807f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(33, 51).addBox(-4.4992f, 1.4807f, -0.5f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(77, 11).addBox(-4.9992f, -4.5193f, -0.5f, 5.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)11.5114f, (float)-15.7138f, (float)0.08f, (float)0.0f, (float)0.0f, (float)-2.2689f));
        PartDefinition cube_r23 = left_wing.addOrReplaceChild("cube_r23", CubeListBuilder.create().texOffs(42, 100).addBox(-0.25f, -2.25f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.1848f, (float)-7.5048f, (float)0.08f, (float)0.0f, (float)0.0f, (float)-2.2689f));
        PartDefinition cube_r24 = left_wing.addOrReplaceChild("cube_r24", CubeListBuilder.create().texOffs(91, 96).addBox(2.5f, -0.5f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.9287f, (float)-1.8358f, (float)0.08f, (float)0.0f, (float)0.0f, (float)-1.8326f));
        PartDefinition cube_r25 = left_wing.addOrReplaceChild("cube_r25", CubeListBuilder.create().texOffs(53, 96).addBox(-2.5f, -0.75f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.2771f, (float)-0.9519f, (float)0.08f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        PartDefinition cube_r26 = left_wing.addOrReplaceChild("cube_r26", CubeListBuilder.create().texOffs(99, 25).addBox(2.55f, -3.0f, -0.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)11.2572f, (float)-0.5549f, (float)0.08f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        PartDefinition cube_r27 = left_wing.addOrReplaceChild("cube_r27", CubeListBuilder.create().texOffs(28, 99).addBox(-3.25f, 0.0f, -0.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.9287f, (float)-1.8358f, (float)0.08f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition cube_r28 = left_wing.addOrReplaceChild("cube_r28", CubeListBuilder.create().texOffs(96, 0).addBox(-1.5f, -2.25f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)9.8126f, (float)-3.0732f, (float)0.08f, (float)0.0f, (float)0.0f, (float)-1.5272f));
        PartDefinition cube_r29 = left_wing.addOrReplaceChild("cube_r29", CubeListBuilder.create().texOffs(97, 34).addBox(-2.0f, -1.75f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.9287f, (float)-1.8358f, (float)0.08f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition cube_r30 = left_wing.addOrReplaceChild("cube_r30", CubeListBuilder.create().texOffs(0, 40).addBox(2.05f, 8.35f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(72, 45).addBox(1.55f, 7.35f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(71, 99).addBox(1.05f, 5.35f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(53, 89).addBox(0.55f, 0.6f, -0.5f, 4.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)11.6137f, (float)-1.6338f, (float)0.08f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        PartDefinition right_wing = body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(90, 7).addBox(-3.5f, -2.0f, -0.42f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.4917f, (float)-0.2082f, (float)5.7239f));
        PartDefinition cube_r31 = right_wing.addOrReplaceChild("cube_r31", CubeListBuilder.create().texOffs(32, 0).addBox(-1.75f, 11.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(65, 45).addBox(-2.25f, 10.5f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 33).addBox(-2.75f, 8.5f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(23, 87).addBox(-3.25f, 3.5f, -0.5f, 4.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(35, 100).addBox(1.5f, -1.5f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.6832f, (float)-0.6823f, (float)0.08f, (float)0.0f, (float)0.0f, (float)0.3054f));
        PartDefinition cube_r32 = right_wing.addOrReplaceChild("cube_r32", CubeListBuilder.create().texOffs(44, 33).addBox(8.0E-4f, -6.4807f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(26, 94).addBox(8.0E-4f, -9.3807f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(32, 5).addBox(1.9992f, 8.4807f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(101, 9).addBox(1.4992f, 6.4807f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(72, 0).addBox(0.9992f, 4.4807f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(22, 40).addBox(0.4992f, 1.4807f, -0.5f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 77).addBox(-8.0E-4f, -4.5193f, -0.5f, 5.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-11.5114f, (float)-15.7138f, (float)0.08f, (float)0.0f, (float)0.0f, (float)2.2689f));
        PartDefinition cube_r33 = right_wing.addOrReplaceChild("cube_r33", CubeListBuilder.create().texOffs(0, 100).addBox(-1.75f, -2.25f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-9.1848f, (float)-7.5048f, (float)0.08f, (float)0.0f, (float)0.0f, (float)2.2689f));
        PartDefinition cube_r34 = right_wing.addOrReplaceChild("cube_r34", CubeListBuilder.create().texOffs(94, 51).addBox(-5.5f, -0.5f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.9287f, (float)-1.8358f, (float)0.08f, (float)0.0f, (float)0.0f, (float)1.8326f));
        PartDefinition cube_r35 = right_wing.addOrReplaceChild("cube_r35", CubeListBuilder.create().texOffs(0, 95).addBox(-0.5f, -0.75f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.2771f, (float)-0.9519f, (float)0.08f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition cube_r36 = right_wing.addOrReplaceChild("cube_r36", CubeListBuilder.create().texOffs(14, 99).addBox(-4.55f, -3.0f, -0.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-11.2572f, (float)-0.5549f, (float)0.08f, (float)0.0f, (float)0.0f, (float)1.5708f));
        PartDefinition cube_r37 = right_wing.addOrReplaceChild("cube_r37", CubeListBuilder.create().texOffs(21, 99).addBox(1.25f, 0.0f, -0.5f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.9287f, (float)-1.8358f, (float)0.08f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition cube_r38 = right_wing.addOrReplaceChild("cube_r38", CubeListBuilder.create().texOffs(35, 95).addBox(-1.5f, -2.25f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-9.8126f, (float)-3.0732f, (float)0.08f, (float)0.0f, (float)0.0f, (float)1.5272f));
        PartDefinition cube_r39 = right_wing.addOrReplaceChild("cube_r39", CubeListBuilder.create().texOffs(44, 95).addBox(-1.0f, -1.75f, -0.5f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.9287f, (float)-1.8358f, (float)0.08f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition cube_r40 = right_wing.addOrReplaceChild("cube_r40", CubeListBuilder.create().texOffs(32, 14).addBox(-3.05f, 8.35f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(68, 59).addBox(-3.55f, 7.35f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(13, 78).addBox(-4.05f, 5.35f, -0.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(87, 57).addBox(-4.55f, 0.6f, -0.5f, 4.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-11.6137f, (float)-1.6338f, (float)0.08f, (float)0.0f, (float)0.0f, (float)1.5708f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0083f, (float)0.4327f, (float)0.8039f));
        PartDefinition cube_r41 = head.addOrReplaceChild("cube_r41", CubeListBuilder.create().texOffs(59, 82).addBox(-2.5f, -3.0f, -0.5f, 5.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-9.6498f, (float)-4.0009f, (float)2.0071f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r42 = head.addOrReplaceChild("cube_r42", CubeListBuilder.create().texOffs(98, 42).addBox(-0.5f, -8.0f, -3.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(22, 0).addBox(-1.0f, -7.0f, -4.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 69).addBox(-1.5f, -6.0f, -4.5f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(58, 30).addBox(-2.0f, -5.0f, -5.0f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 20).addBox(-2.5f, -4.0f, -5.0f, 6.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-15.1143f, (float)-2.7509f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r43 = head.addOrReplaceChild("cube_r43", CubeListBuilder.create().texOffs(0, 85).addBox(0.25f, -3.25f, -1.25f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-16.1143f, (float)-3.2509f, (float)2.193f, (float)0.1782f, (float)0.1265f));
        PartDefinition cube_r44 = head.addOrReplaceChild("cube_r44", CubeListBuilder.create().texOffs(9, 96).addBox(-0.5f, -3.5f, -0.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.6317f, (float)-11.9725f, (float)-1.2363f, (float)0.7967f, (float)0.1782f, (float)0.1265f));
        PartDefinition cube_r45 = head.addOrReplaceChild("cube_r45", CubeListBuilder.create().texOffs(98, 56).addBox(-0.5f, -3.5f, -0.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.6317f, (float)-11.9725f, (float)-1.2363f, (float)0.7967f, (float)-0.1782f, (float)-0.1265f));
        PartDefinition cube_r46 = head.addOrReplaceChild("cube_r46", CubeListBuilder.create().texOffs(44, 85).addBox(-2.25f, -3.25f, -1.25f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-16.1143f, (float)-3.2509f, (float)2.193f, (float)-0.1782f, (float)-0.1265f));
        PartDefinition cube_r47 = head.addOrReplaceChild("cube_r47", CubeListBuilder.create().texOffs(87, 64).addBox(-1.5f, -1.5566f, -0.5924f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.9317f, (float)3.8625f, (float)-1.2654f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r48 = head.addOrReplaceChild("cube_r48", CubeListBuilder.create().texOffs(80, 19).addBox(-1.5f, -1.4544f, -2.1884f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.9317f, (float)3.8625f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r49 = head.addOrReplaceChild("cube_r49", CubeListBuilder.create().texOffs(90, 77).addBox(-1.5f, -1.5566f, -0.5924f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.9317f, (float)5.1125f, (float)-1.2654f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r50 = head.addOrReplaceChild("cube_r50", CubeListBuilder.create().texOffs(80, 79).addBox(-1.5f, -1.4544f, -2.1884f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.9317f, (float)5.1125f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r51 = head.addOrReplaceChild("cube_r51", CubeListBuilder.create().texOffs(103, 50).addBox(-1.5f, -1.5187f, -2.1998f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-9.3674f, (float)5.6239f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r52 = head.addOrReplaceChild("cube_r52", CubeListBuilder.create().texOffs(91, 46).addBox(-1.5f, -1.5241f, -0.5358f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-9.496f, (float)5.601f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r53 = head.addOrReplaceChild("cube_r53", CubeListBuilder.create().texOffs(91, 84).addBox(-1.5f, 0.25f, -2.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-14.375f, (float)5.1715f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r54 = head.addOrReplaceChild("cube_r54", CubeListBuilder.create().texOffs(10, 82).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-13.1169f, (float)2.4702f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r55 = head.addOrReplaceChild("cube_r55", CubeListBuilder.create().texOffs(53, 58).addBox(-2.5f, -1.75f, -4.5f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-13.6698f, (float)1.9635f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r56 = head.addOrReplaceChild("cube_r56", CubeListBuilder.create().texOffs(0, 59).addBox(-2.0f, -0.75f, -3.25f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-10.3684f, (float)3.0706f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r57 = head.addOrReplaceChild("cube_r57", CubeListBuilder.create().texOffs(34, 58).addBox(-2.0f, -4.0f, -2.5f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-2.641f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(58, 8).addBox(0.0f, -1.6642f, -2.5286f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(60, 68).addBox(-0.25f, -2.1642f, -2.0286f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0083f, (float)0.059f, (float)1.6269f));
        PartDefinition cube_r58 = left_arm.addOrReplaceChild("cube_r58", CubeListBuilder.create().texOffs(79, 41).addBox(-1.5f, 11.0f, -1.65f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(86, 70).addBox(-3.5f, 11.0f, -1.65f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 23).addBox(-3.5f, 7.0f, -1.9f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(45, 68).addBox(-3.0f, 3.0f, -1.4f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(35, 77).addBox(-2.5f, -3.0f, -0.9f, 2.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0725f, (float)3.8657f, (float)-0.4886f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_shoulder = left_arm.addOrReplaceChild("left_shoulder", CubeListBuilder.create().texOffs(19, 51).addBox(-2.0f, -2.0f, -2.5f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.1234f, (float)1.2274f, (float)0.0963f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-4.0901f, (float)0.4818f, (float)1.2128f));
        PartDefinition cube_r59 = right_arm.addOrReplaceChild("cube_r59", CubeListBuilder.create().texOffs(30, 68).addBox(-1.5f, -4.0f, -5.0f, 3.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 13).addBox(-2.0f, 0.0f, -5.5f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.474f, (float)10.1384f, (float)1.0023f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r60 = right_arm.addOrReplaceChild("cube_r60", CubeListBuilder.create().texOffs(68, 53).addBox(-0.8133f, -1.9129f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 49).addBox(-1.0633f, -1.4129f, -2.5f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.8382f, (float)-0.6721f, (float)0.5101f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r61 = right_arm.addOrReplaceChild("cube_r61", CubeListBuilder.create().texOffs(24, 77).addBox(-1.0f, -7.25f, 0.75f, 2.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.474f, (float)7.7389f, (float)-1.3546f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r62 = right_arm.addOrReplaceChild("cube_r62", CubeListBuilder.create().texOffs(45, 48).addBox(-1.76f, -0.1706f, -2.5f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.8382f, (float)-0.6721f, (float)0.5101f, (float)0.0f, (float)0.0f, (float)0.829f));
        PartDefinition weapon = right_arm.addOrReplaceChild("weapon", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, 1.75f, -13.0f, 3.0f, 2.0f, 37.0f, new CubeDeformation(0.0f)).texOffs(27, 40).addBox(-1.5f, 1.75f, -20.25f, 3.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(70, 74).addBox(-1.5f, -2.25f, 20.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(14, 49).addBox(-1.0f, 1.75f, 28.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(61, 0).addBox(-1.5f, 1.25f, 24.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(57, 74).addBox(-1.5f, 3.75f, 20.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(82, 93).addBox(-1.0f, -4.25f, 20.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(93, 69).addBox(-1.0f, 7.75f, 20.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.474f, (float)7.7389f, (float)-2.3546f));
        PartDefinition cube_r63 = weapon.addOrReplaceChild("cube_r63", CubeListBuilder.create().texOffs(100, 93).addBox(-1.0f, 1.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.4327f, (float)-0.3746f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r64 = weapon.addOrReplaceChild("cube_r64", CubeListBuilder.create().texOffs(57, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.2591f, (float)-0.3898f, (float)-1.3963f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r65 = weapon.addOrReplaceChild("cube_r65", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.75f, 2.875f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(22, 5).addBox(-1.0f, 0.25f, -2.125f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(91, 38).addBox(-0.5f, 0.75f, -4.875f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.4075f, (float)-10.0295f, (float)-2.6616f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r66 = weapon.addOrReplaceChild("cube_r66", CubeListBuilder.create().texOffs(0, 10).addBox(-0.5f, 0.0f, 2.25f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(46, 78).addBox(-1.0f, -0.5f, -1.75f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(9, 33).addBox(-0.5f, 0.0f, -3.75f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)10.2988f, (float)-5.6174f, (float)-2.0308f, (float)0.069f, (float)-0.0485f));
        PartDefinition cube_r67 = weapon.addOrReplaceChild("cube_r67", CubeListBuilder.create().texOffs(0, 20).addBox(-0.5f, 0.75f, 4.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(64, 89).addBox(-1.0f, 0.25f, 1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(99, 80).addBox(-0.5f, 0.75f, -1.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.2439f, (float)-0.2161f, (float)-1.7017f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r68 = weapon.addOrReplaceChild("cube_r68", CubeListBuilder.create().texOffs(100, 97).addBox(-1.0f, 3.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.9536f, (float)-0.4201f, (float)-1.7453f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r69 = weapon.addOrReplaceChild("cube_r69", CubeListBuilder.create().texOffs(56, 68).addBox(-1.0f, 5.5f, 4.25f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.2685f, (float)2.2153f, (float)-2.2253f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r70 = weapon.addOrReplaceChild("cube_r70", CubeListBuilder.create().texOffs(101, 5).addBox(-1.0f, -0.5f, -0.75f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.9739f, (float)1.6329f, (float)-0.9163f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r71 = weapon.addOrReplaceChild("cube_r71", CubeListBuilder.create().texOffs(49, 58).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0658f, (float)-9.9323f, (float)-2.0508f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r72 = weapon.addOrReplaceChild("cube_r72", CubeListBuilder.create().texOffs(64, 53).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0658f, (float)-9.9323f, (float)-2.0071f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r73 = weapon.addOrReplaceChild("cube_r73", CubeListBuilder.create().texOffs(72, 83).addBox(-1.0f, -1.5f, -2.75f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.4675f, (float)-16.5794f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r74 = weapon.addOrReplaceChild("cube_r74", CubeListBuilder.create().texOffs(22, 15).addBox(-1.0f, -3.0f, -3.0f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.4675f, (float)-16.5794f, (float)-0.9163f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r75 = weapon.addOrReplaceChild("cube_r75", CubeListBuilder.create().texOffs(117, 11).addBox(1.0f, -4.75f, 1.75f, -2.0f, 11.0f, -2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.5833f, (float)-7.2426f, (float)-1.2677f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r76 = weapon.addOrReplaceChild("cube_r76", CubeListBuilder.create().texOffs(126, 9).addBox(1.0f, -10.5f, 1.75f, -2.0f, 9.0f, -2.0f, new CubeDeformation(0.0f)).texOffs(83, 86).addBox(-1.0f, -1.5f, -0.25f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.4363f, (float)-11.8344f, (float)-1.4835f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r77 = weapon.addOrReplaceChild("cube_r77", CubeListBuilder.create().texOffs(19, 61).addBox(-1.0f, -1.0f, -8.25f, 2.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.7067f, (float)-11.8882f, (float)-1.2654f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r78 = weapon.addOrReplaceChild("cube_r78", CubeListBuilder.create().texOffs(27, 45).addBox(-1.0f, 0.25f, -0.25f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.3394f, (float)-11.5884f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r79 = weapon.addOrReplaceChild("cube_r79", CubeListBuilder.create().texOffs(41, 68).addBox(-1.0f, -2.0f, -5.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.6606f, (float)-12.5884f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r80 = weapon.addOrReplaceChild("cube_r80", CubeListBuilder.create().texOffs(75, 91).addBox(-1.0f, -9.0f, -8.5f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.6041f, (float)1.994f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r81 = weapon.addOrReplaceChild("cube_r81", CubeListBuilder.create().texOffs(22, 70).addBox(-1.0f, -2.0f, -0.5f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.75f, (float)2.2f, (float)-0.48f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!Minecraft.getInstance().isPaused()) {
            if (((BaseKHEntity)entity).getState() == 0) {
                this.head.xRot = 0.0f;
                this.left_leg.xRot = 0.0f;
                this.right_leg.xRot = 0.0f;
                this.left_wing.xRot = 0.0f;
                this.right_wing.xRot = 0.0f;
                this.body.z = 0.0f;
                this.body.xRot = 0.0f;
                if (!this.animation.isEmpty()) {
                    this.animation.getFirst().animate();
                }
            } else if (((BaseKHEntity)entity).getState() == 1) {
                this.head.xRot = 90.0f;
                this.left_leg.xRot = 90.0f;
                this.right_leg.xRot = 90.0f;
                this.left_wing.xRot = 90.0f;
                this.right_wing.xRot = 90.0f;
                this.body.xRot = 0.0f;
                this.body.z = 0.0f;
            } else if (((BaseKHEntity)entity).getState() == 2) {
                this.head.xRot = 90.0f;
                this.left_leg.xRot = 90.0f;
                this.right_leg.xRot = 90.0f;
                this.left_wing.xRot = 90.0f;
                this.right_wing.xRot = 90.0f;
                this.body.xRot = (float)Math.toRadians(90.0);
                this.body.z = -3.0f;
            }
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int colour) {
        this.body.render(poseStack, buffer, packedLight, packedOverlay);
    }
}

