/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;

public class LargeBodyModel<T extends BaseKHEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"largebodymodel"), "main");
    private final ModelPart neck4;
    private final ModelPart neck3;
    private final ModelPart neck2;
    private final ModelPart neck1;
    private final ModelPart body;
    private final ModelPart body1;
    private final ModelPart body2;
    private final ModelPart body3;
    private final ModelPart body4;
    private final ModelPart body5;
    private final ModelPart body6;
    private final ModelPart body7;
    private final ModelPart rightArm1;
    private final ModelPart rightArm2;
    private final ModelPart rightArm3;
    private final ModelPart leftArm1;
    private final ModelPart leftArm2;
    private final ModelPart leftArm3;
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart hat1;
    private final ModelPart hat2;
    private final ModelPart hat3;
    private final ModelPart hat4;
    private final ModelPart hat5;
    private final ModelPart hat6;
    private final ModelPart leftLeg1;
    private final ModelPart leftLeg2;
    private final ModelPart leftLeg3;
    private final ModelPart rightLeg1;
    private final ModelPart rightLeg2;
    private final ModelPart rightLeg3;
    private int cycleIndex;
    private double totalDistance;
    private final double[] chargeFlailArmsAnimation = new double[]{1.65, 1.6, 1.57, 1.5, 1.57, 1.6, 1.65};
    private final double[] legsMovementAnimation = new double[]{-22.0, -18.0, -14.0, -10.0, -6.0, -2.0, 2.0, 6.0, 10.0, 14.0, 18.0, 22.0, 18.0, 14.0, 10.0, 6.0, 2.0, -2.0, -6.0, -10.0, -14.0, -18.0, -22.0};
    private final double[] afterAttackAnimation = new double[]{-180.0, -182.0, -184.0, -186.0, -188.0, -190.0, -188.0, -186.0, -184.0, -182.0, -180.0};
    private final double[] mowdownAttackAnimation = new double[]{50.0, 40.0, 30.0, 20.0, 10.0, 0.0, -10.0, -20.0, -30.0, -40.0, -50.0, -50.0, -40.0, -30.0, -20.0, -10.0, 0.0, 10.0, 20.0, 30.0, 40.0, 50.0};

    public LargeBodyModel(ModelPart root) {
        this.neck4 = root.getChild("neck4");
        this.neck3 = root.getChild("neck3");
        this.neck2 = root.getChild("neck2");
        this.neck1 = root.getChild("neck1");
        this.body = root.getChild("body");
        this.body1 = this.body.getChild("body1");
        this.body2 = this.body.getChild("body2");
        this.body3 = this.body.getChild("body3");
        this.body4 = this.body.getChild("body4");
        this.body5 = this.body.getChild("body5");
        this.body6 = this.body.getChild("body6");
        this.body7 = this.body.getChild("body7");
        this.leftArm1 = this.body.getChild("leftArm1");
        this.leftArm2 = this.leftArm1.getChild("leftArm2");
        this.leftArm3 = this.leftArm2.getChild("leftArm3");
        this.rightArm1 = this.body.getChild("rightArm1");
        this.rightArm2 = this.rightArm1.getChild("rightArm2");
        this.rightArm3 = this.rightArm2.getChild("rightArm3");
        this.head = root.getChild("head");
        this.hat = this.head.getChild("hat");
        this.hat1 = this.hat.getChild("hat1");
        this.hat2 = this.hat1.getChild("hat2");
        this.hat3 = this.hat2.getChild("hat3");
        this.hat4 = this.hat3.getChild("hat4");
        this.hat5 = this.hat4.getChild("hat5");
        this.hat6 = this.hat5.getChild("hat6");
        this.leftLeg1 = root.getChild("leftLeg1");
        this.leftLeg2 = this.leftLeg1.getChild("leftLeg2");
        this.leftLeg3 = this.leftLeg2.getChild("leftLeg3");
        this.rightLeg1 = root.getChild("rightLeg1");
        this.rightLeg2 = this.rightLeg1.getChild("rightLeg2");
        this.rightLeg3 = this.rightLeg2.getChild("rightLeg3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition neck4 = partdefinition.addOrReplaceChild("neck4", CubeListBuilder.create().texOffs(26, 50).addBox(-3.0f, -2.9f, 3.5f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck3 = partdefinition.addOrReplaceChild("neck3", CubeListBuilder.create().texOffs(26, 50).addBox(-3.0f, -2.9f, -3.5f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -10.0f, -8.5f, 18.0f, 18.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)9.8f, (float)0.4f));
        PartDefinition rightArm1 = body.addOrReplaceChild("rightArm1", CubeListBuilder.create().texOffs(65, 91).addBox(-0.9f, 0.0f, -1.5f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)10.0f, (float)-6.0f, (float)-0.5f));
        PartDefinition rightArm2 = rightArm1.addOrReplaceChild("rightArm2", CubeListBuilder.create().texOffs(65, 103).addBox(-1.5f, 6.0f, -2.5f, 5.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm3 = rightArm2.addOrReplaceChild("rightArm3", CubeListBuilder.create().texOffs(92, 92).addBox(-1.0f, 15.0f, -2.0f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body5 = body.addOrReplaceChild("body5", CubeListBuilder.create().texOffs(67, 50).addBox(-7.5f, -9.0f, -9.5f, 17.0f, 17.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body7 = body.addOrReplaceChild("body7", CubeListBuilder.create().texOffs(67, 70).addBox(-7.0f, -8.0f, -10.5f, 16.0f, 16.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body1 = body.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(65, 0).addBox(9.7f, -9.5f, -8.0f, 1.0f, 17.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body2 = body.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(65, 0).addBox(-8.7f, -9.5f, -8.0f, 1.0f, 17.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body3 = body.addOrReplaceChild("body3", CubeListBuilder.create().texOffs(65, 33).addBox(-7.5f, -10.7f, -8.0f, 17.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body6 = body.addOrReplaceChild("body6", CubeListBuilder.create().texOffs(67, 50).addBox(-7.5f, -9.5f, 4.2f, 17.0f, 17.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm1 = body.addOrReplaceChild("leftArm1", CubeListBuilder.create().texOffs(65, 91).addBox(-1.0f, 0.0f, -1.5f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-8.0f, (float)-6.0f, (float)-0.2f, (float)0.0f, (float)-3.1416f, (float)0.0f));
        PartDefinition leftArm2 = leftArm1.addOrReplaceChild("leftArm2", CubeListBuilder.create().texOffs(65, 103).addBox(-1.5f, 6.0f, -2.5f, 5.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm3 = leftArm2.addOrReplaceChild("leftArm3", CubeListBuilder.create().texOffs(92, 92).addBox(-1.0f, 15.0f, -2.0f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body4 = body.addOrReplaceChild("body4", CubeListBuilder.create().texOffs(65, 33).addBox(-7.5f, 7.7f, -8.0f, 17.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck2 = partdefinition.addOrReplaceChild("neck2", CubeListBuilder.create().texOffs(26, 50).addBox(5.0f, -2.9f, -3.5f, 0.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck1 = partdefinition.addOrReplaceChild("neck1", CubeListBuilder.create().texOffs(26, 50).addBox(-3.0f, -2.9f, -3.5f, 0.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(21, 36).addBox(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-0.7f, (float)0.0f));
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(38, 32).addBox(-3.5f, -6.0f, -3.5f, 7.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat1 = hat.addOrReplaceChild("hat1", CubeListBuilder.create().texOffs(45, 48).addBox(-2.5f, -7.0f, -2.5f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat2 = hat1.addOrReplaceChild("hat2", CubeListBuilder.create().texOffs(21, 66).addBox(-1.5f, -8.0f, -1.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat3 = hat2.addOrReplaceChild("hat3", CubeListBuilder.create().texOffs(21, 73).addBox(-0.5f, -10.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat4 = hat3.addOrReplaceChild("hat4", CubeListBuilder.create().texOffs(21, 73).addBox(-7.4f, -8.7f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition hat5 = hat4.addOrReplaceChild("hat5", CubeListBuilder.create().texOffs(21, 73).addBox(8.7f, -8.4f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        PartDefinition hat6 = hat5.addOrReplaceChild("hat6", CubeListBuilder.create().texOffs(21, 73).addBox(8.4f, 6.7f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        PartDefinition leftLeg1 = partdefinition.addOrReplaceChild("leftLeg1", CubeListBuilder.create().texOffs(0, 42).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5f, (float)18.0f, (float)0.0f, (float)0.0f, (float)0.2269f, (float)0.0f));
        PartDefinition leftLeg2 = leftLeg1.addOrReplaceChild("leftLeg2", CubeListBuilder.create().texOffs(0, 52).addBox(-1.5f, 4.0f, -5.5f, 3.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg3 = leftLeg2.addOrReplaceChild("leftLeg3", CubeListBuilder.create().texOffs(0, 62).addBox(-1.5f, 3.0f, -5.5f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg1 = partdefinition.addOrReplaceChild("rightLeg1", CubeListBuilder.create().texOffs(0, 42).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)18.0f, (float)0.0f, (float)0.0f, (float)-0.2269f, (float)0.0f));
        PartDefinition rightLeg2 = rightLeg1.addOrReplaceChild("rightLeg2", CubeListBuilder.create().texOffs(0, 52).addBox(-1.5f, 4.0f, -5.5f, 3.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg3 = rightLeg2.addOrReplaceChild("rightLeg3", CubeListBuilder.create().texOffs(0, 62).addBox(-1.5f, 3.0f, -5.5f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T ent, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.totalDistance += ent.distanceToSqr(((BaseKHEntity)ent).xOld, ((BaseKHEntity)ent).yOld, ((BaseKHEntity)ent).zOld);
        if (ent.distanceToSqr(((BaseKHEntity)ent).xOld, ((BaseKHEntity)ent).yOld, ((BaseKHEntity)ent).zOld) > 0.0) {
            this.cycleIndex = (int)(this.totalDistance * 4.0 % (double)this.legsMovementAnimation.length);
            this.leftLeg1.xRot = this.degToRad(this.legsMovementAnimation[this.cycleIndex]);
            this.rightLeg1.xRot = -this.degToRad(this.legsMovementAnimation[this.cycleIndex]);
        } else {
            this.rightLeg1.xRot = 0.0f;
            this.leftLeg1.xRot = 0.0f;
        }
        if (((BaseKHEntity)ent).getState() == 0) {
            this.body.yRot = 0.0f;
            this.rightArm1.xRot = 0.0f;
            this.leftArm1.xRot = 0.0f;
            this.leftLeg1.yRot = this.degToRad(-13.0);
            this.rightLeg1.yRot = this.degToRad(13.0);
            this.rightArm1.zRot = 0.0f;
            this.rightArm1.yRot = 0.0f;
            this.rightArm1.xRot = 0.0f;
        } else if (((BaseKHEntity)ent).getState() == 1) {
            this.cycleIndex = ((BaseKHEntity)ent).tickCount % this.chargeFlailArmsAnimation.length;
            this.leftArm1.xRot = (float)(-this.chargeFlailArmsAnimation[this.cycleIndex]);
            this.rightArm1.xRot = (float)this.chargeFlailArmsAnimation[this.cycleIndex];
        } else if (((BaseKHEntity)ent).getState() == 2) {
            this.leftArm1.zRot = this.degToRad(-60.0);
            this.rightArm1.zRot = this.degToRad(60.0);
            this.cycleIndex = (int)((double)((BaseKHEntity)ent).tickCount * 1.4 % (double)this.mowdownAttackAnimation.length);
            this.body.yRot = this.degToRad(this.mowdownAttackAnimation[this.cycleIndex]);
        } else if (((BaseKHEntity)ent).getState() == 10) {
            this.rightArm1.zRot = 0.0f;
            this.leftArm1.zRot = 0.0f;
            this.rightArm1.xRot = 0.0f;
            this.leftArm1.xRot = 0.0f;
            this.cycleIndex = ((BaseKHEntity)ent).tickCount % this.afterAttackAnimation.length;
            this.rightArm1.xRot = this.degToRad((float)this.afterAttackAnimation[this.cycleIndex]);
            this.rightArm1.yRot = this.degToRad(-26.0);
            this.rightArm1.zRot = this.degToRad(18.0);
        }
    }

    protected float degToRad(double degrees) {
        return (float)(degrees * Math.PI / 180.0);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int colour) {
        this.neck4.render(poseStack, buffer, packedLight, packedOverlay);
        this.neck3.render(poseStack, buffer, packedLight, packedOverlay);
        this.body.render(poseStack, buffer, packedLight, packedOverlay);
        this.neck2.render(poseStack, buffer, packedLight, packedOverlay);
        this.neck1.render(poseStack, buffer, packedLight, packedOverlay);
        this.head.render(poseStack, buffer, packedLight, packedOverlay);
        this.leftLeg1.render(poseStack, buffer, packedLight, packedOverlay);
        this.rightLeg1.render(poseStack, buffer, packedLight, packedOverlay);
    }
}

