/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ShadowModel<Type extends Entity>
extends EntityModel<Type> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"shadow"), "main");
    private final ModelPart UpperBody;
    private final ModelPart LowerBody;
    private final ModelPart LowerHead;
    private final ModelPart Head;
    private final ModelPart LegLeft1;
    private final ModelPart LegLeft3;
    private final ModelPart LegLeft2;
    private final ModelPart LegRight1;
    private final ModelPart LegRight3;
    private final ModelPart LegRight2;
    private final ModelPart ArmLeft1;
    private final ModelPart ArmLeft2;
    private final ModelPart ArmRight1;
    private final ModelPart ArmRight2;
    private final ModelPart AntenaLeft1;
    private final ModelPart AntenaLeft2;
    private final ModelPart AntenaRight1;
    private final ModelPart AntenaRight2;
    protected double distanceMovedTotal = 0.0;
    public double CYCLES_PER_BLOCK = 2.0;
    protected int cycleIndex = 0;
    private final int[][] ticksForWalkingAnimation = new int[][]{{0, -90}, {100, 2}, {51, -51}};
    protected double[][] animationWalk = new double[][]{{0.0, 100.0, 51.0, -90.0, 2.0, -46.0}, {-40.0, 51.0, 0.0, -40.0, 51.0, 0.0}, {-90.0, 2.0, -46.0, 0.0, 100.0, 51.0}, {-90.0, 2.0, -46.0, 0.0, 100.0, 51.0}, {-40.0, 51.0, 0.0, -40.0, 51.0, 0.0}, {0.0, 100.0, -51.0, -90.0, 2.0, -46.0}};

    public ShadowModel(ModelPart root) {
        this.UpperBody = root.getChild("UpperBody");
        this.LowerBody = root.getChild("LowerBody");
        this.LowerHead = root.getChild("LowerHead");
        this.Head = root.getChild("Head");
        this.LegLeft1 = root.getChild("LegLeft1");
        this.LegLeft3 = root.getChild("LegLeft3");
        this.LegLeft2 = root.getChild("LegLeft2");
        this.LegRight1 = root.getChild("LegRight1");
        this.LegRight3 = root.getChild("LegRight3");
        this.LegRight2 = root.getChild("LegRight2");
        this.ArmLeft1 = root.getChild("ArmLeft1");
        this.ArmLeft2 = root.getChild("ArmLeft2");
        this.ArmRight1 = root.getChild("ArmRight1");
        this.ArmRight2 = root.getChild("ArmRight2");
        this.AntenaLeft1 = root.getChild("AntenaLeft1");
        this.AntenaLeft2 = root.getChild("AntenaLeft2");
        this.AntenaRight1 = root.getChild("AntenaRight1");
        this.AntenaRight2 = root.getChild("AntenaRight2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition UpperBody = partdefinition.addOrReplaceChild("UpperBody", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.5f, -4.5f, -1.8f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)2.0f, (float)0.7064f, (float)0.0f, (float)0.0f));
        PartDefinition LowerBody = partdefinition.addOrReplaceChild("LowerBody", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-2.0f, -1.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)19.0f, (float)2.0f));
        PartDefinition LowerHead = partdefinition.addOrReplaceChild("LowerHead", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.5f, -5.0667f, -4.4f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)19.0f, (float)2.0f));
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 10).mirror().addBox(-2.5f, -5.5f, -9.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)19.0f, (float)2.0f));
        PartDefinition LegLeft1 = partdefinition.addOrReplaceChild("LegLeft1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(2.0f, 0.0667f, 0.5f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)2.0f, (float)-0.7064f, (float)0.0f, (float)0.0f));
        PartDefinition LegLeft3 = partdefinition.addOrReplaceChild("LegLeft3", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(1.5f, 4.0f, -3.5f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)19.0f, (float)2.0f));
        PartDefinition LegLeft2 = partdefinition.addOrReplaceChild("LegLeft2", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(2.0f, 1.5333f, -3.0667f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)2.0f, (float)0.8923f, (float)0.0f, (float)0.0f));
        PartDefinition LegRight1 = partdefinition.addOrReplaceChild("LegRight1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-3.0f, 0.0667f, 0.5f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)2.0f, (float)-0.7064f, (float)0.0f, (float)0.0f));
        PartDefinition LegRight3 = partdefinition.addOrReplaceChild("LegRight3", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-3.5f, 4.0f, -3.5f, 2.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)19.0f, (float)2.0f));
        PartDefinition LegRight2 = partdefinition.addOrReplaceChild("LegRight2", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-3.0f, 1.5333f, -3.0667f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)2.0f, (float)0.8923f, (float)0.0f, (float)0.0f));
        PartDefinition ArmLeft1 = partdefinition.addOrReplaceChild("ArmLeft1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(1.0f, -1.4667f, -2.2667f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)2.0f, (float)-0.409f, (float)0.0f, (float)0.0f));
        PartDefinition ArmLeft2 = partdefinition.addOrReplaceChild("ArmLeft2", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(2.0f, -1.4f, -4.3333f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)2.0f, (float)0.4461f, (float)0.0f, (float)0.0f));
        PartDefinition ArmRight1 = partdefinition.addOrReplaceChild("ArmRight1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-3.0f, -1.4667f, -2.2667f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)2.0f, (float)-0.409f, (float)0.0f, (float)0.0f));
        PartDefinition ArmRight2 = partdefinition.addOrReplaceChild("ArmRight2", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-3.0f, -1.4f, -4.3333f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)2.0f, (float)0.4461f, (float)0.0f, (float)0.0f));
        PartDefinition AntenaLeft1 = partdefinition.addOrReplaceChild("AntenaLeft1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(1.0f, -6.5f, -8.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)19.0f, (float)2.0f));
        PartDefinition AntenaLeft2 = partdefinition.addOrReplaceChild("AntenaLeft2", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(1.0f, -7.5f, -10.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)19.0f, (float)2.0f));
        PartDefinition AntenaRight1 = partdefinition.addOrReplaceChild("AntenaRight1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-2.0f, -6.5f, -8.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)19.0f, (float)2.0f));
        PartDefinition AntenaRight2 = partdefinition.addOrReplaceChild("AntenaRight2", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-2.0f, -7.5f, -10.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)19.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int colour) {
        this.UpperBody.render(poseStack, buffer, packedLight, packedOverlay);
        this.LowerBody.render(poseStack, buffer, packedLight, packedOverlay);
        this.LowerHead.render(poseStack, buffer, packedLight, packedOverlay);
        this.Head.render(poseStack, buffer, packedLight, packedOverlay);
        this.LegLeft1.render(poseStack, buffer, packedLight, packedOverlay);
        this.LegLeft3.render(poseStack, buffer, packedLight, packedOverlay);
        this.LegLeft2.render(poseStack, buffer, packedLight, packedOverlay);
        this.LegRight1.render(poseStack, buffer, packedLight, packedOverlay);
        this.LegRight3.render(poseStack, buffer, packedLight, packedOverlay);
        this.LegRight2.render(poseStack, buffer, packedLight, packedOverlay);
        this.ArmLeft1.render(poseStack, buffer, packedLight, packedOverlay);
        this.ArmLeft2.render(poseStack, buffer, packedLight, packedOverlay);
        this.ArmRight1.render(poseStack, buffer, packedLight, packedOverlay);
        this.ArmRight2.render(poseStack, buffer, packedLight, packedOverlay);
        this.AntenaLeft1.render(poseStack, buffer, packedLight, packedOverlay);
        this.AntenaLeft2.render(poseStack, buffer, packedLight, packedOverlay);
        this.AntenaRight1.render(poseStack, buffer, packedLight, packedOverlay);
        this.AntenaRight2.render(poseStack, buffer, packedLight, packedOverlay);
    }

    public void setupAnim(Type e, float p_102619_, float p_102620_, float p_102621_, float p_102622_, float p_102623_) {
        this.updateDistanceMovedTotal((Entity)e);
        this.cycleIndex = (int)(this.getDistanceMovedTotal() * this.CYCLES_PER_BLOCK % (double)this.animationWalk.length);
        if (e.distanceToSqr(((Entity)e).xo, ((Entity)e).yo, ((Entity)e).zo) > 0.0) {
            this.LegLeft1.xRot = this.degToRad(this.animationWalk[this.cycleIndex][0]);
            this.LegLeft2.xRot = this.degToRad(this.animationWalk[this.cycleIndex][1]);
            this.LegLeft3.xRot = this.degToRad(this.animationWalk[this.cycleIndex][2]);
            this.LegRight1.xRot = this.degToRad(this.animationWalk[this.cycleIndex][3]);
            this.LegRight2.xRot = this.degToRad(this.animationWalk[this.cycleIndex][4]);
            this.LegRight3.xRot = this.degToRad(this.animationWalk[this.cycleIndex][5]);
        } else {
            this.LegRight1.xRot = -0.7063936f;
            this.LegLeft1.xRot = -0.7063936f;
            this.LegRight2.xRot = 0.8922867f;
            this.LegLeft2.xRot = 0.8922867f;
            this.LegRight3.xRot = 0.0f;
            this.LegLeft3.xRot = 0.0f;
        }
    }

    protected void updateDistanceMovedTotal(Entity e) {
        this.distanceMovedTotal += e.distanceToSqr(e.xo, e.yo, e.zo);
    }

    protected double getDistanceMovedTotal() {
        return this.distanceMovedTotal;
    }

    protected float degToRad(double degrees) {
        return (float)(degrees * Math.PI / 180.0);
    }
}

