/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.client.ClientUtils;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;

@OnlyIn(value=Dist.CLIENT)
public class SoldierModel<T extends BaseKHEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"soldier"), "main");
    private final ModelPart right_leg;
    private final ModelPart left_leg;
    private final ModelPart body;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart head;
    List<ClientUtils.ModelAnimation> animation = new ArrayList<ClientUtils.ModelAnimation>();

    public SoldierModel(ModelPart root) {
        this.right_leg = root.getChild("body").getChild("right_leg");
        this.left_leg = root.getChild("body").getChild("left_leg");
        this.body = root.getChild("body");
        this.left_arm = root.getChild("body").getChild("left_arm");
        this.right_arm = root.getChild("body").getChild("right_arm");
        this.head = root.getChild("body").getChild("head");
        ClientUtils.ModelAnimation leftLegTopAnim = new ClientUtils.ModelAnimation(this.left_leg, 0.0f, -40.0f, 40.0f, 0.0f, true, ClientUtils.Angle.X, this.right_leg);
        ClientUtils.ModelAnimation headAnim = new ClientUtils.ModelAnimation(this.head, 0.0f, -30.0f, 30.0f, 0.0f, true, ClientUtils.Angle.Z, null);
        this.animation.add(leftLegTopAnim);
        this.animation.add(headAnim);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(30, 11).addBox(-5.0f, 5.0f, -3.0f, 10.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 17).addBox(-5.5f, 6.0f, -3.5f, 11.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 27).addBox(-5.0f, -5.0f, -2.5f, 10.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(79, 35).addBox(-3.0f, 2.0f, -3.5f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 68).addBox(-2.0f, 3.0f, -3.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 68).addBox(-2.0f, 3.0f, 2.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(79, 35).addBox(-3.0f, 2.0f, 2.5f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(32, 64).addBox(-4.0f, -4.0f, -3.5f, 8.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(32, 64).addBox(-4.0f, -4.0f, 2.5f, 8.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(31, 31).addBox(-4.5f, 4.0f, -2.5f, 9.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(26, 0).addBox(-4.5f, 2.0f, -2.5f, 9.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(34, 38).addBox(-4.0f, 3.0f, -2.5f, 8.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)5.0f, (float)0.5f));
        PartDefinition right_leg = body.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(17, 51).addBox(-1.0f, 9.5f, -5.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(80, 18).addBox(-1.5f, 9.5f, -4.5f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(25, 72).addBox(-2.0f, 9.5f, -2.5f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(76, 29).addBox(-1.5f, 8.5f, -2.5f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(80, 13).addBox(-1.5f, 6.5f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(50, 0).addBox(-1.5f, 9.5f, 1.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(63, 10).addBox(-2.0f, -1.5f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)12.5f, (float)0.5f));
        PartDefinition left_leg = body.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(30, 19).addBox(-1.0f, 9.5f, -5.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(26, 79).addBox(-1.5f, 9.5f, -4.5f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(68, 71).addBox(-2.0f, 9.5f, -2.5f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(52, 19).addBox(-1.5f, 8.5f, -2.5f, 3.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 79).addBox(-1.5f, 6.5f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(28, 55).addBox(-1.5f, 9.5f, 1.5f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(54, 55).addBox(-2.0f, -1.5f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)12.5f, (float)0.5f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(52, 76).addBox(-1.2067f, 0.0f, -1.3846f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(74, 60).addBox(-1.2067f, 6.0f, -1.8846f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(55, 0).addBox(-2.2067f, -2.0f, -2.3846f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.2067f, (float)1.0f, (float)0.3846f));
        PartDefinition left_hand = left_arm.addOrReplaceChild("left_hand", CubeListBuilder.create().texOffs(31, 31).addBox(10.0f, -12.0f, 2.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 27).addBox(10.0f, -12.0f, -2.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(26, 0).addBox(10.0f, -12.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 40).addBox(6.0f, -12.0f, -2.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(55, 26).addBox(6.0f, -15.0f, -2.0f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.2067f, (float)22.0f, (float)-0.3846f));
        PartDefinition cube_r1 = left_hand.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(50, 7).addBox(-0.5f, -1.0f, 3.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(57, 10).addBox(-0.5f, -1.0f, 1.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(62, 10).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.0168f, (float)-8.4676f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition fingertip_r1 = left_hand.addOrReplaceChild("fingertip_r1", CubeListBuilder.create().texOffs(10, 57).addBox(-0.5f, 1.5f, 1.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(57, 14).addBox(-0.5f, 1.5f, 3.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 62).addBox(-0.5f, 1.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)11.0914f, (float)-8.3446f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)1.2217f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(39, 76).addBox(-1.7933f, 0.0f, -1.3846f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(11, 75).addBox(-2.7933f, 6.1f, -1.8846f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(12, 55).addBox(-2.7933f, -2.0f, -2.3846f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.2067f, (float)1.0f, (float)0.3846f));
        PartDefinition right_hand = right_arm.addOrReplaceChild("right_hand", CubeListBuilder.create().texOffs(33, 55).addBox(0.0914f, -6.5019f, 0.6014f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 57).addBox(0.0914f, -3.5019f, 4.6014f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(49, 55).addBox(0.0914f, -3.5019f, 2.6014f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(34, 38).addBox(0.0914f, -3.5019f, 0.6014f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(17, 45).addBox(4.0914f, -3.5019f, 0.6014f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.8847f, (float)13.6019f, (float)-2.986f));
        PartDefinition fingertip_r2 = right_hand.addOrReplaceChild("fingertip_r2", CubeListBuilder.create().texOffs(51, 68).addBox(-0.5f, 1.5f, 3.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(56, 68).addBox(-0.5f, 1.5f, 1.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(49, 76).addBox(-0.5f, 1.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.1535f, (float)1.1014f, (float)0.0f, (float)0.0f, (float)-1.2217f));
        PartDefinition cube_r2 = right_hand.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(24, 65).addBox(-0.5f, -1.0f, 3.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(38, 72).addBox(-0.5f, -1.0f, 1.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(43, 72).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0745f, (float)0.0305f, (float)1.1014f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 71).addBox(-2.0f, -3.0f, -1.46f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.5f, -12.0f, -2.46f, 9.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.46f));
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(71, 23).addBox(-3.5f, -30.0f, -6.0f, 7.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 17).addBox(3.5f, -36.0f, -4.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(71, 55).addBox(-3.5f, -36.0f, -4.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(49, 71).addBox(-3.5f, -38.0f, 5.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(30, 20).addBox(-3.5f, -39.0f, -2.0f, 7.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(64, 61).addBox(3.5f, -38.0f, -2.0f, 1.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 58).addBox(-4.5f, -38.0f, -2.0f, 1.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 40).addBox(-5.5f, -36.0f, -2.0f, 1.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(71, 0).addBox(-3.5f, -38.0f, -4.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(62, 42).addBox(-4.5f, -36.0f, 5.0f, 9.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(10, 40).addBox(-3.5f, -36.0f, -6.0f, 7.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(41, 45).addBox(-4.5f, -34.0f, 5.0f, 9.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 38).addBox(4.5f, -36.0f, -2.0f, 1.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(64, 47).addBox(-3.5f, -34.0f, 7.0f, 7.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(33, 7).addBox(-3.5f, -36.0f, 7.0f, 7.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(58, 36).addBox(-4.5f, -30.0f, -4.0f, 9.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.5f, -36.0f, -4.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(76, 5).addBox(-1.5f, -43.0f, 0.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(78, 78).addBox(-1.5f, -45.0f, 1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(12, 65).addBox(-1.5f, -47.0f, 2.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(65, 78).addBox(-1.5f, -45.0f, 6.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)-0.46f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        block7: {
            this.left_arm.y = -3.0f;
            this.right_arm.y = -3.0f;
            this.left_leg.y = 8.0f;
            this.right_leg.y = 8.0f;
            this.head.y = -4.0f;
            if (Minecraft.getInstance().isPaused()) break block7;
            if (((BaseKHEntity)entity).getState() == 0) {
                this.head.zRot = 0.0f;
                this.head.yRot = 0.0f;
                this.body.yRot = 0.0f;
                this.right_arm.xRot = (float)Math.toRadians(-90.0);
                this.left_arm.xRot = (float)Math.toRadians(-90.0);
            } else if (((BaseKHEntity)entity).getState() == 1) {
                this.head.zRot = 0.0f;
                this.body.yRot = ((BaseKHEntity)entity).tickCount % 360;
                this.right_arm.xRot = 0.0f;
                this.left_arm.xRot = 0.0f;
                this.right_arm.zRot = (float)Math.toRadians(90.0);
                this.left_arm.zRot = (float)Math.toRadians(-90.0);
                return;
            }
            if (entity.distanceToSqr(((BaseKHEntity)entity).xOld, ((BaseKHEntity)entity).yOld, ((BaseKHEntity)entity).zOld) > 0.0) {
                for (ClientUtils.ModelAnimation m : this.animation) {
                    m.animate();
                }
            } else {
                for (ClientUtils.ModelAnimation m : this.animation) {
                    m.setDefault();
                }
            }
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int colour) {
        this.body.render(poseStack, buffer, packedLight, packedOverlay);
    }
}

