/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;

@OnlyIn(value=Dist.CLIENT)
public class WhiteMushroomModel<T extends BaseKHEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"white_mushroom"), "main");
    private final ModelPart main;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightarm;
    private final ModelPart rightarm2;
    private final ModelPart leftarm;
    private final ModelPart leftarm2;

    public WhiteMushroomModel(ModelPart root) {
        this.main = root.getChild("main");
        this.body = this.main.getChild("body");
        this.head = this.main.getChild("head");
        this.rightarm = this.main.getChild("rightarm");
        this.leftarm = this.main.getChild("leftarm");
        this.rightarm2 = this.rightarm.getChild("rightarm2_r1");
        this.leftarm2 = this.leftarm.getChild("leftarm2_r1");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition main = partdefinition.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = main.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(-9.0f, -18.0f, 1.0f, 10.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(34, 22).addBox(-10.0f, -6.0f, 0.0f, 12.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-11.0f, -3.0f, -1.0f, 14.0f, 3.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)0.0f, (float)-5.0f));
        PartDefinition head = main.addOrReplaceChild("head", CubeListBuilder.create().texOffs(36, 35).addBox(-4.0f, -7.0f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 15).addBox(-6.0f, -11.0f, -5.0f, 12.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-18.0f, (float)0.0f));
        PartDefinition rightarm = main.addOrReplaceChild("rightarm", CubeListBuilder.create(), PartPose.offset((float)-5.0f, (float)-18.0f, (float)-1.0f));
        PartDefinition rightarm2_r1 = rightarm.addOrReplaceChild("rightarm2_r1", CubeListBuilder.create().texOffs(40, 0).addBox(-2.0f, -5.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)1.0f, (float)2.9671f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm1_r1 = rightarm.addOrReplaceChild("rightarm1_r1", CubeListBuilder.create().texOffs(40, 0).addBox(-2.0f, -3.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)1.0f, (float)3.1416f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = main.addOrReplaceChild("leftarm", CubeListBuilder.create(), PartPose.offset((float)5.0f, (float)-18.0f, (float)-1.0f));
        PartDefinition leftarm2_r1 = leftarm.addOrReplaceChild("leftarm2_r1", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -5.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)1.0f, (float)2.9671f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm1_r1 = leftarm.addOrReplaceChild("leftarm1_r1", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -3.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)1.0f, (float)3.1416f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int colour) {
        this.main.render(poseStack, vertexConsumer, packedLight, packedOverlay, colour);
    }

    public void setupAnim(T entity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (!Minecraft.getInstance().isPaused()) {
            switch (((BaseKHEntity)entity).getState()) {
                case -3: {
                    this.main.y = 0.0f;
                    this.main.xRot = (float)Math.toRadians(0.0);
                    this.head.xRot = (float)Math.toRadians(0.0);
                    this.rightarm.xRot = (float)Math.toRadians(0.0);
                    this.leftarm.xRot = (float)Math.toRadians(0.0);
                    this.rightarm.zRot = (float)Math.toRadians(150.0);
                    this.leftarm.zRot = (float)Math.toRadians(-150.0);
                    this.rightarm2.xRot = (float)Math.toRadians(180.0);
                    this.leftarm2.xRot = (float)Math.toRadians(180.0);
                    break;
                }
                case -2: {
                    this.main.xRot = (float)Math.toRadians(0.0);
                    this.head.xRot = (float)Math.toRadians(-20.0);
                    this.rightarm.xRot = (float)Math.toRadians(0.0);
                    this.leftarm.xRot = (float)Math.toRadians(0.0);
                    this.rightarm.yRot = (float)Math.toRadians(((BaseKHEntity)entity).tickCount % 10 < 5 ? 90.0 : -90.0);
                    this.leftarm.yRot = (float)Math.toRadians(((BaseKHEntity)entity).tickCount % 10 < 5 ? 90.0 : -90.0);
                    this.rightarm.zRot = (float)Math.toRadians(90.0);
                    this.leftarm.zRot = (float)Math.toRadians(-90.0);
                    this.rightarm2.xRot = (float)Math.toRadians(90.0);
                    this.leftarm2.xRot = (float)Math.toRadians(90.0);
                    break;
                }
                case -1: {
                    this.main.xRot = (float)Math.toRadians(0.0);
                    this.head.xRot = (float)Math.toRadians(0.0);
                    this.rightarm.xRot = (float)Math.toRadians(0.0);
                    this.leftarm.xRot = (float)Math.toRadians(0.0);
                    this.rightarm.zRot = (float)Math.toRadians(150.0);
                    this.leftarm.zRot = (float)Math.toRadians(-150.0);
                    this.rightarm2.xRot = (float)Math.toRadians(180.0);
                    this.leftarm2.xRot = (float)Math.toRadians(180.0);
                    break;
                }
                case 0: {
                    this.main.y = 24.0f;
                    this.main.xRot = (float)Math.toRadians(0.0);
                    this.head.xRot = (float)Math.toRadians(0.0);
                    this.rightarm.xRot = (float)Math.toRadians(0.0);
                    this.leftarm.xRot = (float)Math.toRadians(0.0);
                    this.rightarm.yRot = (float)Math.toRadians(0.0);
                    this.leftarm.yRot = (float)Math.toRadians(0.0);
                    this.rightarm.zRot = (float)Math.toRadians(0.0);
                    this.leftarm.zRot = (float)Math.toRadians(0.0);
                    this.rightarm2.xRot = (float)Math.toRadians(180.0);
                    this.leftarm2.xRot = (float)Math.toRadians(180.0);
                    break;
                }
                case 1: {
                    this.main.xRot = (float)Math.toRadians(10.0);
                    this.head.xRot = (float)Math.toRadians(20.0);
                    this.rightarm.xRot = (float)Math.toRadians(-30.0);
                    this.leftarm.xRot = (float)Math.toRadians(-30.0);
                    this.rightarm.yRot = (float)Math.toRadians(-40.0);
                    this.leftarm.yRot = (float)Math.toRadians(40.0);
                    this.rightarm2.xRot = (float)Math.toRadians(90.0);
                    this.leftarm2.xRot = (float)Math.toRadians(90.0);
                    break;
                }
                case 2: {
                    this.main.xRot = (float)Math.toRadians(-20.0);
                    this.head.xRot = (float)Math.toRadians(0.0);
                    this.rightarm.xRot = (float)Math.toRadians(-90.0);
                    this.leftarm.xRot = (float)Math.toRadians(-90.0);
                    this.rightarm.yRot = (float)Math.toRadians(0.0);
                    this.leftarm.yRot = (float)Math.toRadians(0.0);
                    this.rightarm2.xRot = (float)Math.toRadians(90.0);
                    this.leftarm2.xRot = (float)Math.toRadians(90.0);
                    this.rightarm.zRot = (float)Math.toRadians(15.0);
                    this.leftarm.zRot = (float)Math.toRadians(-15.0);
                    break;
                }
                case 3: {
                    this.main.xRot = (float)Math.toRadians(15.0);
                    this.head.xRot = (float)Math.toRadians(40.0);
                    this.rightarm.xRot = (float)Math.toRadians(-20.0);
                    this.leftarm.xRot = (float)Math.toRadians(-20.0);
                    this.rightarm2.xRot = (float)Math.toRadians(180.0);
                    this.leftarm2.xRot = (float)Math.toRadians(180.0);
                }
            }
        }
    }
}

