/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.data.GlobalData;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.util.IDisabledAnimations;

@OnlyIn(value=Dist.CLIENT)
public class AeroLayerRenderer<T extends LivingEntity>
extends RenderLayer<T, PlayerModel<T>> {
    public static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/trident_riptide.png");
    public static final String BOX = "box";
    private final ModelPart box;

    public AeroLayerRenderer(RenderLayerParent<T, PlayerModel<T>> p_174540_, EntityModelSet p_174541_) {
        super(p_174540_);
        ModelPart modelpart = p_174541_.bakeLayer(ModelLayers.PLAYER_SPIN_ATTACK);
        this.box = modelpart.getChild(BOX);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entitylivingbaseIn instanceof AbstractClientPlayer) {
            LivingEntityRenderer renderer = (LivingEntityRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)((AbstractClientPlayer)entitylivingbaseIn));
            if (!((IDisabledAnimations)renderer).kingdom_Keys$isDisabled()) {
                this.renderEntity(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        } else {
            this.renderEntity(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }

    public void renderEntity(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (GlobalData.get(entitylivingbaseIn) != null && entitylivingbaseIn.hasEffect(ModMobEffects.AERO)) {
            MobEffectInstance aero = entitylivingbaseIn.getEffect(ModMobEffects.AERO);
            VertexConsumer vertexconsumer = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE));
            for (int i = 1; i <= aero.getAmplifier() + 1; ++i) {
                matrixStackIn.pushPose();
                float f = ageInTicks * 20.0f;
                if (i % 2 == 0) {
                    f *= -1.0f;
                }
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(f));
                float scale = 1.0f;
                switch (aero.getAmplifier()) {
                    case 0: {
                        if (entitylivingbaseIn instanceof Player) {
                            scale = 0.75f * (float)i;
                            matrixStackIn.scale(scale, scale * 1.2f, scale);
                            matrixStackIn.translate(0.0, (double)(-0.4f + 0.8f * (float)i), 0.0);
                            break;
                        }
                        scale = 0.35f * (float)i;
                        matrixStackIn.scale(scale, scale, scale);
                        break;
                    }
                    case 1: {
                        if (entitylivingbaseIn instanceof Player) {
                            scale = 0.85f * (float)i;
                            matrixStackIn.scale(scale, scale, scale);
                            matrixStackIn.translate(0.0, (double)(-0.8f + 0.8f * (float)i), 0.0);
                            break;
                        }
                        scale = 0.45f * (float)i;
                        matrixStackIn.scale(scale, scale, scale);
                        break;
                    }
                    case 2: {
                        if (entitylivingbaseIn instanceof Player) {
                            scale = 0.7f * (float)i;
                            matrixStackIn.scale(scale, scale * 0.6f, scale);
                            matrixStackIn.translate(0.0, (double)(-1.2f + 0.6f * (float)i), 0.0);
                            break;
                        }
                        scale = 0.55f * (float)i;
                        matrixStackIn.scale(scale, scale * 0.6f, scale);
                    }
                }
                int color = -1;
                if (((LivingEntity)entitylivingbaseIn).hurtTime > 0) {
                    color = new Color(100, 255, 255).hashCode();
                }
                this.box.render(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.NO_OVERLAY, color);
                matrixStackIn.popPose();
            }
        }
    }
}

