/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.client.model.armor.AquaModel;
import online.kingdomkeys.kingdomkeys.client.model.armor.ArmorBaseModel;
import online.kingdomkeys.kingdomkeys.client.model.armor.EraqusModel;
import online.kingdomkeys.kingdomkeys.client.model.armor.TerraModel;
import online.kingdomkeys.kingdomkeys.client.model.armor.UXArmorModel;
import online.kingdomkeys.kingdomkeys.client.model.armor.VentusModel;
import online.kingdomkeys.kingdomkeys.client.model.armor.XehanortModel;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.KeybladeArmorItem;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.util.Utils;

@OnlyIn(value=Dist.CLIENT)
public class KeybladeArmorRenderer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public static final Map<Item, ArmorBaseModel<LivingEntity>> armorModels = new HashMap<Item, ArmorBaseModel<LivingEntity>>();
    ResourceLocation texture;
    ResourceLocation texture2;
    UXArmorModel<LivingEntity> uxTopSlim;
    UXArmorModel<LivingEntity> uxBotSlim;

    public KeybladeArmorRenderer(RenderLayerParent<T, M> entityRendererIn, EntityModelSet modelSet) {
        super(entityRendererIn);
        VentusModel vTop = new VentusModel(modelSet.bakeLayer(VentusModel.LAYER_LOCATION_TOP));
        VentusModel vBot = new VentusModel(modelSet.bakeLayer(VentusModel.LAYER_LOCATION_BOTTOM));
        TerraModel tTop = new TerraModel(modelSet.bakeLayer(TerraModel.LAYER_LOCATION_TOP));
        TerraModel tBot = new TerraModel(modelSet.bakeLayer(TerraModel.LAYER_LOCATION_BOTTOM));
        AquaModel aTop = new AquaModel(modelSet.bakeLayer(AquaModel.LAYER_LOCATION_TOP));
        AquaModel aBot = new AquaModel(modelSet.bakeLayer(AquaModel.LAYER_LOCATION_BOTTOM));
        EraqusModel eTop = new EraqusModel(modelSet.bakeLayer(EraqusModel.LAYER_LOCATION_TOP));
        EraqusModel eBot = new EraqusModel(modelSet.bakeLayer(EraqusModel.LAYER_LOCATION_BOTTOM));
        XehanortModel xTop = new XehanortModel(modelSet.bakeLayer(XehanortModel.LAYER_LOCATION_TOP));
        XehanortModel xBot = new XehanortModel(modelSet.bakeLayer(XehanortModel.LAYER_LOCATION_BOTTOM));
        UXArmorModel uxTop = new UXArmorModel(modelSet.bakeLayer(UXArmorModel.LAYER_LOCATION_TOP));
        UXArmorModel uxBot = new UXArmorModel(modelSet.bakeLayer(UXArmorModel.LAYER_LOCATION_BOTTOM));
        this.uxTopSlim = new UXArmorModel(modelSet.bakeLayer(UXArmorModel.SLIM_LAYER_LOCATION_TOP));
        this.uxBotSlim = new UXArmorModel(modelSet.bakeLayer(UXArmorModel.SLIM_LAYER_LOCATION_BOTTOM));
        armorModels.put(ModItems.ux_Helmet.get(), uxTop);
        armorModels.put(ModItems.ux_Chestplate.get(), uxTop);
        armorModels.put(ModItems.ux_Leggings.get(), uxBot);
        armorModels.put(ModItems.ux_Boots.get(), uxTop);
        armorModels.put(ModItems.terra_Helmet.get(), tTop);
        armorModels.put(ModItems.terra_Chestplate.get(), tTop);
        armorModels.put(ModItems.terra_Leggings.get(), tBot);
        armorModels.put(ModItems.terra_Boots.get(), tTop);
        armorModels.put(ModItems.aqua_Helmet.get(), aTop);
        armorModels.put(ModItems.aqua_Chestplate.get(), aTop);
        armorModels.put(ModItems.aqua_Leggings.get(), aBot);
        armorModels.put(ModItems.aqua_Boots.get(), aTop);
        armorModels.put(ModItems.ventus_Helmet.get(), vTop);
        armorModels.put(ModItems.ventus_Chestplate.get(), vTop);
        armorModels.put(ModItems.ventus_Leggings.get(), vBot);
        armorModels.put(ModItems.ventus_Boots.get(), vTop);
        armorModels.put(ModItems.nightmareVentus_Helmet.get(), vTop);
        armorModels.put(ModItems.nightmareVentus_Chestplate.get(), vTop);
        armorModels.put(ModItems.nightmareVentus_Leggings.get(), vBot);
        armorModels.put(ModItems.nightmareVentus_Boots.get(), vTop);
        armorModels.put(ModItems.eraqus_Helmet.get(), eTop);
        armorModels.put(ModItems.eraqus_Chestplate.get(), eTop);
        armorModels.put(ModItems.eraqus_Leggings.get(), eBot);
        armorModels.put(ModItems.eraqus_Boots.get(), eTop);
        armorModels.put(ModItems.xehanort_Helmet.get(), xTop);
        armorModels.put(ModItems.xehanort_Chestplate.get(), xTop);
        armorModels.put(ModItems.xehanort_Leggings.get(), xBot);
        armorModels.put(ModItems.xehanort_Boots.get(), xTop);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Player player;
        NonNullList armor = NonNullList.create();
        int color = -1;
        boolean glint = true;
        if (entitylivingbaseIn instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entitylivingbaseIn;
            for (ItemStack itemStack : armorStand.getArmorSlots()) {
                armor.add((Object)itemStack);
            }
        }
        if (entitylivingbaseIn instanceof Player && PlayerData.get(player = (Player)entitylivingbaseIn) != null) {
            if (Minecraft.getInstance().player.getSkin().model().id().equals("slim") && !((Object)armorModels.get(ModItems.ux_Helmet.get())).equals(this.uxTopSlim)) {
                armorModels.replace(ModItems.ux_Helmet.get(), this.uxTopSlim);
                armorModels.replace(ModItems.ux_Chestplate.get(), this.uxTopSlim);
                armorModels.replace(ModItems.ux_Leggings.get(), this.uxBotSlim);
                armorModels.replace(ModItems.ux_Boots.get(), this.uxTopSlim);
            }
            PlayerData playerData = PlayerData.get(player);
            color = 0xFF000000 | playerData.getArmorColor() & 0xFFFFFF;
            glint = playerData.getArmorGlint();
            armor = player.getInventory().armor;
        }
        if (armor != null && !armor.isEmpty()) {
            VertexConsumer vertexconsumer;
            String armorName;
            Item item;
            ArmorBaseModel<LivingEntity> armorModelBoots = armorModels.get(((ItemStack)armor.get(0)).getItem());
            ArmorBaseModel<LivingEntity> armorModelLeggings = armorModels.get(((ItemStack)armor.get(1)).getItem());
            ArmorBaseModel<LivingEntity> armorModelChestplate = armorModels.get(((ItemStack)armor.get(2)).getItem());
            ArmorBaseModel<LivingEntity> armorModelHelmet = armorModels.get(((ItemStack)armor.get(3)).getItem());
            ItemStack itemStack = (ItemStack)armor.get(0);
            if (itemStack.getItem() instanceof KeybladeArmorItem) {
                item = itemStack.getItem();
                armorName = Utils.getItemRegistryName(item).getPath().substring(0, Utils.getItemRegistryName(item).getPath().indexOf("_"));
                this.texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)("textures/models/armor/" + armorName + "1.png"));
                vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.texture), (glint && itemStack.hasFoil() ? 1 : 0) != 0);
                armorModelBoots.rightLeg.copyFrom(((HumanoidModel)this.getParentModel()).rightLeg);
                armorModelBoots.leftLeg.copyFrom(((HumanoidModel)this.getParentModel()).leftLeg);
                armorModelBoots.leftLeg.render(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.NO_OVERLAY, color);
                armorModelBoots.rightLeg.render(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.NO_OVERLAY, color);
            }
            if ((itemStack = (ItemStack)armor.get(1)).getItem() instanceof KeybladeArmorItem) {
                item = itemStack.getItem();
                armorName = Utils.getItemRegistryName(item).getPath().substring(0, Utils.getItemRegistryName(item).getPath().indexOf("_"));
                this.texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)("textures/models/armor/" + armorName + "2.png"));
                vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.texture), (glint && itemStack.hasFoil() ? 1 : 0) != 0);
                armorModelLeggings.body.copyFrom(((HumanoidModel)this.getParentModel()).body);
                armorModelLeggings.rightLeg.copyFrom(((HumanoidModel)this.getParentModel()).rightLeg);
                armorModelLeggings.leftLeg.copyFrom(((HumanoidModel)this.getParentModel()).leftLeg);
                armorModelLeggings.body.render(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.NO_OVERLAY, color);
                armorModelLeggings.leftLeg.render(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.NO_OVERLAY, color);
                armorModelLeggings.rightLeg.render(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.NO_OVERLAY, color);
            }
            if ((itemStack = (ItemStack)armor.get(2)).getItem() instanceof KeybladeArmorItem) {
                item = itemStack.getItem();
                armorName = Utils.getItemRegistryName(item).getPath().substring(0, Utils.getItemRegistryName(item).getPath().indexOf("_"));
                this.texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)("textures/models/armor/" + armorName + "1.png"));
                vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.texture), (glint && itemStack.hasFoil() ? 1 : 0) != 0);
                armorModelChestplate.body.copyFrom(((HumanoidModel)this.getParentModel()).body);
                armorModelChestplate.rightArm.copyFrom(((HumanoidModel)this.getParentModel()).rightArm);
                armorModelChestplate.leftArm.copyFrom(((HumanoidModel)this.getParentModel()).leftArm);
                armorModelChestplate.leftArm.render(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.NO_OVERLAY, color);
                armorModelChestplate.rightArm.render(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.NO_OVERLAY, color);
                armorModelChestplate.body.render(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.NO_OVERLAY, color);
            }
            if ((itemStack = (ItemStack)armor.get(3)).getItem() instanceof KeybladeArmorItem) {
                item = itemStack.getItem();
                armorName = Utils.getItemRegistryName(item).getPath().substring(0, Utils.getItemRegistryName(item).getPath().indexOf("_"));
                this.texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)("textures/models/armor/" + armorName + "1.png"));
                vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)bufferIn, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.texture), (glint && itemStack.hasFoil() ? 1 : 0) != 0);
                armorModelHelmet.head.copyFrom(((HumanoidModel)this.getParentModel()).head);
                armorModelHelmet.head.render(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.NO_OVERLAY, color);
            }
        }
    }

    protected ResourceLocation getTextureLocation(T pEntity) {
        return ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/models/armor/terra1.png");
    }
}

