/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render.block;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import online.kingdomkeys.kingdomkeys.entity.block.PedestalTileEntity;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;

public class PedestalRenderer
implements BlockEntityRenderer<PedestalTileEntity> {
    private ItemRenderer renderItem;

    public PedestalRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PedestalTileEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderItem = Minecraft.getInstance().getItemRenderer();
        if (!tileEntityIn.isStationOfAwakeningMarker()) {
            IItemHandler itemHandler = (IItemHandler)tileEntityIn.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tileEntityIn.getBlockPos(), null);
            if (itemHandler != null && !itemHandler.getStackInSlot(0).isEmpty()) {
                this.renderItem(tileEntityIn, matrixStackIn, bufferIn, partialTicks, itemHandler.getStackInSlot(0).getItem() instanceof KeychainItem ? new ItemStack((ItemLike)((KeychainItem)itemHandler.getStackInSlot(0).getItem()).getKeyblade()) : itemHandler.getStackInSlot(0), combinedLightIn);
            }
        } else if (!tileEntityIn.hide) {
            this.renderItem(tileEntityIn, matrixStackIn, bufferIn, partialTicks, tileEntityIn.getDisplayStack(), combinedLightIn);
        }
    }

    private void renderItem(PedestalTileEntity tileEntity, PoseStack matrixStack, MultiBufferSource buffer, float partialTicks, ItemStack toRender, int combinedLightIn) {
        float rotation;
        float height;
        matrixStack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!tileEntity.isPaused()) {
            float lerpedTicks = (float)tileEntity.previousTicks + (float)(tileEntity.ticksExisted() - tileEntity.previousTicks) * partialTicks;
            height = tileEntity.getBaseHeight() + 0.1f * (float)Math.sin(tileEntity.getBobSpeed() * lerpedTicks);
            rotation = lerpedTicks * tileEntity.getRotationSpeed() % 360.0f;
            tileEntity.setCurrentTransforms(rotation, height);
        } else {
            height = tileEntity.getSavedHeight();
            rotation = tileEntity.getSavedRotation();
        }
        matrixStack.translate(0.5f, height, 0.5f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(rotation));
        matrixStack.scale(tileEntity.getScale(), tileEntity.getScale(), tileEntity.getScale());
        if (tileEntity.isFlipped()) {
            matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            matrixStack.translate(0.0f, -0.6f, 0.0f);
        }
        BakedModel model = this.renderItem.getModel(toRender, tileEntity.getLevel(), null, 1);
        this.renderItem.render(toRender, ItemDisplayContext.FIXED, false, matrixStack, buffer, combinedLightIn, OverlayTexture.NO_OVERLAY, model);
        matrixStack.popPose();
    }

    public AABB getRenderBoundingBox(PedestalTileEntity blockEntity) {
        return new AABB(blockEntity.getBlockPos()).expandTowards(0.0, 5.0, 0.0);
    }
}

