/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.client.model.entity.CubeModel;
import online.kingdomkeys.kingdomkeys.entity.organization.ArrowgunShotEntity;

@OnlyIn(value=Dist.CLIENT)
public class ArrowgunShotEntityRenderer
extends EntityRenderer<ArrowgunShotEntity> {
    private final CubeModel model;
    private Color color;

    public ArrowgunShotEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new CubeModel(context.bakeLayer(CubeModel.LAYER_LOCATION));
        this.shadowRadius = 0.25f;
    }

    public void render(ArrowgunShotEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.color = switch (entity.getShotType()) {
            case 0 -> new Color(1.0f, 0.2f, 0.2f);
            case 1 -> new Color(0.3f, 0.3f, 1.0f);
            default -> new Color(1, 1, 1);
        };
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0, 0.05, 0.0);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(entity.yRotO + (entity.getYRot() - entity.yRotO)));
        matrixStackIn.mulPose(Axis.XN.rotationDegrees(entity.xRotO + (entity.getXRot() - entity.xRotO)));
        matrixStackIn.scale(0.1f, 0.1f, 0.8f);
        this.model.renderToBuffer(matrixStackIn, bufferIn.getBuffer(this.model.renderType(this.getTextureLocation(entity))), packedLightIn, OverlayTexture.NO_OVERLAY, this.color.getRGB());
        matrixStackIn.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    @Nullable
    public ResourceLocation getTextureLocation(ArrowgunShotEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/entity/models/fire.png");
    }
}

