/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import online.kingdomkeys.kingdomkeys.client.model.entity.BombModel;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseBombEntity;
import org.joml.Matrix4f;

public class BombRenderer
extends MobRenderer<BaseBombEntity, BombModel<BaseBombEntity>> {
    public BombRenderer(EntityRendererProvider.Context context) {
        super(context, new BombModel(context.bakeLayer(BombModel.LAYER_LOCATION)), 0.35f);
    }

    public ResourceLocation getTextureLocation(BaseBombEntity entity) {
        return entity.getTexture();
    }

    protected void scale(BaseBombEntity entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.scale(1.0f, 1.0f, 1.0f);
        super.scale((LivingEntity)entitylivingbaseIn, matrixStackIn, partialTickTime);
    }

    public void render(BaseBombEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Minecraft mc = Minecraft.getInstance();
        if (entityIn.getState() == 1) {
            int timer = Math.max(entityIn.getTicks(), 0);
            String text = "" + (int)Math.ceil((float)timer / 20.0f);
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0, (double)entityIn.getBbHeight() + 0.75, 0.0);
            matrixStackIn.mulPose(mc.getEntityRenderDispatcher().cameraOrientation());
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
            matrixStackIn.scale(-0.05f, -0.05f, -0.05f);
            Matrix4f matrix4f = matrixStackIn.last().pose();
            mc.font.drawInBatch(text, (float)(-mc.font.width(text) / 2), 0.0f, 0xFFFFFF, false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, 0, packedLightIn);
            matrixStackIn.popPose();
        }
        super.render((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }
}

