/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import online.kingdomkeys.kingdomkeys.client.model.entity.MoogleModel;
import online.kingdomkeys.kingdomkeys.entity.mob.MoogleEntity;

public class MoogleRenderer
extends MobRenderer<MoogleEntity, MoogleModel<MoogleEntity>> {
    public MoogleRenderer(EntityRendererProvider.Context context) {
        super(context, new MoogleModel(context.bakeLayer(MoogleModel.LAYER_LOCATION)), 0.35f);
    }

    public void render(MoogleEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (entityIn.isFakeMoogle()) {
            VertexConsumer builder = bufferIn.getBuffer(((MoogleModel)this.model).renderType(this.getTextureLocation(entityIn)));
            matrixStackIn.popPose();
            float f = Mth.rotLerp((float)partialTicks, (float)entityIn.yBodyRotO, (float)entityIn.yBodyRot);
            float f7 = this.getBob((LivingEntity)entityIn, partialTicks);
            this.setupRotations((LivingEntity)entityIn, matrixStackIn, f7, f, partialTicks, entityIn.getScale());
            matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
            this.scale((LivingEntity)entityIn, matrixStackIn, partialTicks);
            matrixStackIn.translate(0.5, (double)-1.501f, -0.5);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(Minecraft.getInstance().player.getYRot() + 180.0f));
            Color colour = new Color(1.0f, 1.0f, 1.0f, entityIn.isFakeMoogle() ? 0.5f : 1.0f);
            ((MoogleModel)this.model).renderToBuffer(matrixStackIn, builder, packedLightIn, MoogleRenderer.getOverlayCoords((LivingEntity)entityIn, (float)0.0f), colour.getRGB());
            matrixStackIn.pushPose();
        } else {
            super.render((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    public ResourceLocation getTextureLocation(MoogleEntity entity) {
        if (!entity.isFakeMoogle()) {
            if (this.isOrg(entity)) {
                return ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/entity/mob/org_moogle.png");
            }
            return ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/entity/mob/moogle.png");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/entity/mob/fake_moogle.png");
    }

    private boolean isOrg(MoogleEntity entity) {
        if (entity.hasCustomName()) {
            String name = entity.getCustomName().getString().toLowerCase();
            return name.length() == 7 && name.contains("m") && name.chars().filter(c -> c == 111).count() == 2L && name.contains("x") && name.contains("g") && name.contains("l") && name.contains("e");
        }
        return false;
    }

    @Nullable
    protected RenderType getRenderType(MoogleEntity p_230496_1_, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        return super.getRenderType((LivingEntity)p_230496_1_, p_230496_2_, p_230496_3_, p_230496_4_);
    }
}

