/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.model.entity.NobodyCreeperModel;
import online.kingdomkeys.kingdomkeys.entity.mob.NobodyCreeperEntity;

public class NobodyCreeperRenderer
extends MobRenderer<NobodyCreeperEntity, NobodyCreeperModel<NobodyCreeperEntity>> {
    private final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/entity/mob/creeper.png");
    private final ResourceLocation swordTexture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/entity/mob/creeper_sword.png");
    private final ResourceLocation spearTexture = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/entity/mob/creeper_spear.png");

    public NobodyCreeperRenderer(EntityRendererProvider.Context context) {
        super(context, new NobodyCreeperModel(context.bakeLayer(NobodyCreeperModel.LAYER_LOCATION)), 0.35f);
    }

    public ResourceLocation getTextureLocation(NobodyCreeperEntity entity) {
        if (entity.getState() == 0 || entity.getState() == 3) {
            return this.texture;
        }
        if (entity.getState() == 1) {
            return this.swordTexture;
        }
        if (entity.getState() == 2) {
            return this.spearTexture;
        }
        return this.texture;
    }

    public void render(NobodyCreeperEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Direction direction;
        Entity entity;
        boolean shouldSit;
        matrixStackIn.pushPose();
        ((NobodyCreeperModel)this.model).attackTime = this.getAttackAnim((LivingEntity)entityIn, partialTicks);
        ((NobodyCreeperModel)this.model).riding = shouldSit = entityIn.isPassenger() && entityIn.getVehicle() != null && entityIn.getVehicle().shouldRiderSit();
        ((NobodyCreeperModel)this.model).young = entityIn.isBaby();
        float f = Mth.rotLerp((float)partialTicks, (float)entityIn.yBodyRotO, (float)entityIn.yBodyRot);
        float f1 = Mth.rotLerp((float)partialTicks, (float)entityIn.yHeadRotO, (float)entityIn.yHeadRot);
        float f2 = f1 - f;
        if (shouldSit && (entity = entityIn.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            f = Mth.rotLerp((float)partialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - f;
            float f3 = Mth.wrapDegrees((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot());
        if (entityIn.getPose() == Pose.SLEEPING && (direction = entityIn.getBedOrientation()) != null) {
            float f4 = entityIn.getEyeHeight(Pose.STANDING) - 0.1f;
            matrixStackIn.translate((double)((float)(-direction.getStepX()) * f4), 0.0, (double)((float)(-direction.getStepZ()) * f4));
        }
        float f7 = this.getBob((LivingEntity)entityIn, partialTicks);
        this.setupRotations((LivingEntity)entityIn, matrixStackIn, f7, f, partialTicks, entityIn.getScale());
        matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
        this.scale(entityIn, matrixStackIn, partialTicks);
        matrixStackIn.translate(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.isAlive()) {
            f8 = entityIn.walkAnimation.speed(partialTicks);
            f5 = entityIn.walkAnimation.position(partialTicks);
            if (entityIn.isBaby()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((NobodyCreeperModel)this.model).prepareMobModel((Entity)entityIn, f5, f8, partialTicks);
        ((NobodyCreeperModel)this.model).setupAnim(entityIn, f5, f8, f7, f2, f6);
        boolean flag = this.isBodyVisible((LivingEntity)entityIn);
        boolean flag1 = !flag && !entityIn.isInvisibleTo((Player)Minecraft.getInstance().player);
        boolean flag2 = Minecraft.getInstance().shouldEntityAppearGlowing((Entity)entityIn);
        RenderType rendertype = this.getRenderType((LivingEntity)entityIn, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(rendertype);
            int i = NobodyCreeperRenderer.getOverlayCoords((LivingEntity)entityIn, (float)this.getWhiteOverlayProgress((LivingEntity)entityIn, partialTicks));
            if (entityIn.getState() == 0 || entityIn.getState() == 3) {
                ((NobodyCreeperModel)this.model).RightArmDetail.render(matrixStackIn, ivertexbuilder, packedLightIn, i);
                ((NobodyCreeperModel)this.model).BodyLower.render(matrixStackIn, ivertexbuilder, packedLightIn, i);
                ((NobodyCreeperModel)this.model).LeftArmDetail.render(matrixStackIn, ivertexbuilder, packedLightIn, i);
            } else if (entityIn.getState() == 1) {
                ((NobodyCreeperModel)this.model).Sword_Handle1.render(matrixStackIn, ivertexbuilder, packedLightIn, i);
            } else if (entityIn.getState() == 2) {
                ((NobodyCreeperModel)this.model).Spear_Handle.render(matrixStackIn, ivertexbuilder, packedLightIn, i);
            }
        }
        matrixStackIn.popPose();
        super.render((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void scale(NobodyCreeperEntity entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.scale(1.0f, 1.0f, 1.0f);
        super.scale((LivingEntity)entitylivingbaseIn, matrixStackIn, partialTickTime);
    }
}

