/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.client.model.data.ModelData;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.SpawningOrbEntity;

public class SpawningOrbRenderer
extends EntityRenderer<SpawningOrbEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/entity/models/portal.png");

    public SpawningOrbRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(SpawningOrbEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float[] fArray;
        matrixStackIn.pushPose();
        VertexConsumer buffer = bufferIn.getBuffer(Sheets.translucentCullBlockSheet());
        BakedModel model = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"entity/portal")));
        matrixStackIn.pushPose();
        if (entity.getEntityType().equals(EntityHelper.MobType.NOBODY.name())) {
            float[] fArray2 = new float[4];
            fArray2[0] = 0.6f;
            fArray2[1] = 0.6f;
            fArray2[2] = 0.6f;
            fArray = fArray2;
            fArray2[3] = 0.9f;
        } else {
            float[] fArray3 = new float[4];
            fArray3[0] = 0.2f;
            fArray3[1] = 0.1f;
            fArray3[2] = 0.3f;
            fArray = fArray3;
            fArray3[3] = 0.9f;
        }
        float[] rgb = fArray;
        float ticks = entity.tickCount;
        if (ticks < 10.0f) {
            matrixStackIn.scale(ticks * 0.2f, ticks * 0.2f, ticks * 0.2f);
        } else if (ticks > 90.0f) {
            matrixStackIn.scale((100.0f - ticks) * 0.2f, (100.0f - ticks) * 0.2f, (100.0f - ticks) * 0.2f);
        } else {
            matrixStackIn.scale(2.0f, 2.0f, 2.0f);
        }
        matrixStackIn.scale(1.0f, 0.5f, 1.0f);
        matrixStackIn.mulPose(Axis.YN.rotationDegrees(Minecraft.getInstance().player.getRotationVector().y));
        for (BakedQuad quad : model.getQuads(null, null, entity.level().random, ModelData.EMPTY, RenderType.translucent())) {
            buffer.putBulkData(matrixStackIn.last(), quad, rgb[0], rgb[1], rgb[2], rgb[3], 0xF000F0, OverlayTexture.NO_OVERLAY, true);
        }
        matrixStackIn.popPose();
        matrixStackIn.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(SpawningOrbEntity entity) {
        return TEXTURE;
    }
}

