/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.model.data.ModelData;
import online.kingdomkeys.kingdomkeys.client.model.entity.WhiteMushroomModel;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.WhiteMushroomEntity;

public class WhiteMushroomRenderer<Type extends WhiteMushroomEntity>
extends MobRenderer<Type, WhiteMushroomModel<Type>> {
    int prevState = 0;
    int ticksDespawning = 0;

    public WhiteMushroomRenderer(EntityRendererProvider.Context context) {
        super(context, new WhiteMushroomModel(context.bakeLayer(WhiteMushroomModel.LAYER_LOCATION)), 0.5f);
    }

    public void render(Type entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        if (((BaseKHEntity)entity).getState() == -2) {
            if (this.prevState != -2) {
                this.ticksDespawning = ((WhiteMushroomEntity)entity).tickCount;
            }
            VertexConsumer buffer = bufferIn.getBuffer(Sheets.translucentCullBlockSheet());
            BakedModel model = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"entity/portal")));
            matrixStackIn.pushPose();
            float[] rgb = new float[]{0.2f, 0.1f, 0.3f, 0.9f};
            int offsetTicks = 25;
            int maxTicks = 20;
            float ticks = ((WhiteMushroomEntity)entity).tickCount - this.ticksDespawning - offsetTicks;
            if (ticks < 10.0f) {
                matrixStackIn.scale(ticks * 0.2f, ticks * 0.2f, ticks * 0.2f);
            } else if (ticks > (float)(maxTicks - 10 - offsetTicks)) {
                matrixStackIn.scale(((float)maxTicks - ticks) * 0.2f, ((float)maxTicks - ticks) * 0.2f, ((float)maxTicks - ticks) * 0.2f);
            } else {
                matrixStackIn.scale(2.0f, 2.0f, 2.0f);
            }
            matrixStackIn.scale(1.0f, 0.5f, 1.0f);
            matrixStackIn.mulPose(Axis.YN.rotationDegrees(Minecraft.getInstance().player.getRotationVector().y));
            for (BakedQuad quad : model.getQuads(null, null, entity.level().random, ModelData.EMPTY, RenderType.translucent())) {
                buffer.putBulkData(matrixStackIn.last(), quad, rgb[0], rgb[1], rgb[2], rgb[3], 0xF000F0, OverlayTexture.NO_OVERLAY, true);
            }
            matrixStackIn.popPose();
        }
        super.render(entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.popPose();
        this.prevState = ((BaseKHEntity)entity).getState();
    }

    protected void scale(Type entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.scale(0.6f, 0.6f, 0.6f);
        super.scale(entitylivingbaseIn, matrixStackIn, partialTickTime);
    }

    public ResourceLocation getTextureLocation(Type pEntity) {
        return ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/entity/mob/white_mushroom.png");
    }
}

