/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.entity.drops.XPEntity;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import org.joml.Matrix4f;

public class XPEntityRenderer
extends EntityRenderer<XPEntity> {
    int frame = 0;

    public XPEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.0f;
    }

    public ResourceLocation getTextureLocation(XPEntity entity) {
        return null;
    }

    public void render(XPEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Minecraft mc = Minecraft.getInstance();
        if (entityIn.getCaster() == null) {
            return;
        }
        PlayerData playerData = PlayerData.get(entityIn.getCaster());
        if (playerData == null) {
            return;
        }
        if (entityIn.getExp() != 0 && entityIn.getCaster() == Minecraft.getInstance().player && playerData.getSoAState() == SoAState.COMPLETE) {
            int xp = Math.max(entityIn.getExp(), 0);
            String text = "+" + xp + "xp";
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0, (double)entityIn.getBbHeight() + 0.75 + (double)((float)entityIn.tickCount / 100.0f), 0.0);
            matrixStackIn.mulPose(mc.getEntityRenderDispatcher().cameraOrientation());
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
            matrixStackIn.scale(-0.05f, -0.05f, -0.05f);
            if (entityIn.tickCount >= 10) {
                matrixStackIn.scale((float)(30 - entityIn.tickCount) * 0.05f, (float)(30 - entityIn.tickCount) * 0.05f, (float)(30 - entityIn.tickCount) * 0.05f);
            }
            Matrix4f matrix4f = matrixStackIn.last().pose();
            mc.font.drawInBatch(text, (float)(-mc.font.width(text) / 2), 0.0f, 65535, false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, 0, packedLightIn);
            matrixStackIn.popPose();
        }
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }
}

