/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render.entity.drops;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import online.kingdomkeys.kingdomkeys.entity.drops.ItemDropEntity;
import online.kingdomkeys.kingdomkeys.util.Utils;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class EntityItemDropRenderer
extends EntityRenderer<ItemDropEntity> {
    ResourceLocation texture;

    public EntityItemDropRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
    }

    protected int getBlockLightLevel(ItemDropEntity entityIn, BlockPos blockPos) {
        return Mth.clamp((int)(super.getBlockLightLevel((Entity)entityIn, blockPos) + 7), (int)0, (int)15);
    }

    public void render(ItemDropEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        float f = 0.0f;
        float f1 = 1.0f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float value = (float)entityIn.getValue() / 10.0f;
        value = Mth.clamp((float)Utils.map(value, 1.0f, 35.0f, 0.5f, 3.0f), (float)0.5f, (float)3.0f);
        matrixStackIn.scale(value, value, value);
        matrixStackIn.translate(0.0, (double)0.1f, 0.0);
        matrixStackIn.mulPose(this.entityRenderDispatcher.cameraOrientation());
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrixStackIn.scale(0.3f, 0.3f, 0.3f);
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(entityIn)));
        PoseStack.Pose matrixstack$entry = matrixStackIn.last();
        Matrix4f matrix4f = matrixstack$entry.pose();
        Matrix3f matrix3f = matrixstack$entry.normal();
        EntityItemDropRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, -0.5f, -0.25f, 255, 255, 255, f, f3, packedLightIn);
        EntityItemDropRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, 0.5f, -0.25f, 255, 255, 255, f1, f3, packedLightIn);
        EntityItemDropRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, 0.5f, 0.75f, 255, 255, 255, f1, f2, packedLightIn);
        EntityItemDropRenderer.vertex(ivertexbuilder, matrix4f, matrix3f, -0.5f, 0.75f, 255, 255, 255, f, f2, packedLightIn);
        matrixStackIn.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private static void vertex(VertexConsumer bufferIn, Matrix4f matrixIn, Matrix3f matrixNormalIn, float x, float y, int red, int green, int blue, float texU, float texV, int packedLight) {
        bufferIn.addVertex(matrixIn, x, y, 0.0f).setColor(red, green, blue, 255).setUv(texU, texV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(ItemDropEntity entity) {
        return this.texture;
    }
}

