/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render.magic;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import online.kingdomkeys.kingdomkeys.entity.drops.HeartEntity;

@OnlyIn(value=Dist.CLIENT)
public class HeartEntityRenderer
extends EntityRenderer<HeartEntity> {
    float rotation = 0.0f;

    public HeartEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.25f;
    }

    public void render(HeartEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        VertexConsumer buffer = bufferIn.getBuffer(Sheets.translucentCullBlockSheet());
        BakedModel model = Minecraft.getInstance().getModelManager().getModel(ModelResourceLocation.standalone((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"entity/heart")));
        matrixStackIn.pushPose();
        float a = 1.0f;
        float rgb = 1.0f;
        float ticks = entity.tickCount;
        if (ticks < 10.0f) {
            matrixStackIn.scale(ticks * 5.0E-4f, ticks * 5.0E-4f, ticks * 5.0E-4f);
        } else if (ticks > 20.0f) {
            matrixStackIn.scale((30.0f - ticks) * 5.0E-4f, (30.0f - ticks) * 5.0E-4f, (30.0f - ticks) * 5.0E-4f);
        } else {
            matrixStackIn.scale(0.005f, 0.005f, 0.005f);
        }
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(ticks * 20.0f));
        for (BakedQuad quad : model.getQuads(null, null, RandomSource.create(), ModelData.EMPTY, RenderType.cutout())) {
            buffer.putBulkData(matrixStackIn.last(), quad, rgb, rgb, rgb, a, 0xF000F0, OverlayTexture.NO_OVERLAY, true);
        }
        matrixStackIn.popPose();
        matrixStackIn.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    @Nullable
    public ResourceLocation getTextureLocation(HeartEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/entity/models/heart.png");
    }
}

