/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render.org;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.entity.organization.KKThrowableEntity;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.item.organization.CardItem;
import online.kingdomkeys.kingdomkeys.item.organization.ChakramItem;
import online.kingdomkeys.kingdomkeys.item.organization.LanceItem;
import online.kingdomkeys.kingdomkeys.item.organization.ScytheItem;

@OnlyIn(value=Dist.CLIENT)
public class KKThrowableEntityRenderer
extends EntityRenderer<KKThrowableEntity> {
    public final ItemRenderer itemRenderer;
    Random rand = new Random();
    float rotation = 0.0f;

    public KKThrowableEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.15f;
        this.itemRenderer = context.getItemRenderer();
        this.shadowStrength = 0.2f;
    }

    public void render(KKThrowableEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.pushPose();
        ItemStack itemstack = entityIn.getItem();
        BakedModel model = this.itemRenderer.getModel(itemstack, entityIn.level(), null, 1);
        poseStack.translate(0.0, 0.4, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f + entityIn.yRotO + (entityIn.getYRot() - entityIn.yRotO)));
        float rotation = ((float)entityIn.tickCount + partialTicks) * 1.5f;
        if (itemstack.getItem() instanceof ChakramItem) {
            if (itemstack.getItem() == ModItems.pizzaCut.get()) {
                poseStack.scale(1.0f, 1.0f, 1.0f);
            } else {
                poseStack.scale(0.04f, 0.04f, 0.04f);
            }
            if (entityIn.getRotationPoint() == 0) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.XN.rotation(rotation));
            }
            if (entityIn.getRotationPoint() == 1) {
                // empty if block
            }
            if (entityIn.getRotationPoint() == 2) {
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.ZP.rotation(rotation));
            }
        } else if (itemstack.getItem() instanceof KeybladeItem) {
            poseStack.scale(2.0f, 2.0f, 2.0f);
            if (entityIn.getRotationPoint() == 0) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.XN.rotation(rotation));
                poseStack.translate(0.5f, 0.0f, 0.0f);
            }
            if (entityIn.getRotationPoint() == 1) {
                poseStack.mulPose(Axis.ZP.rotation(rotation));
            }
            if (entityIn.getRotationPoint() == 2) {
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.ZP.rotation(rotation));
            }
        } else if (itemstack.getItem() instanceof ScytheItem) {
            if (entityIn.getRotationPoint() == 0) {
                poseStack.scale(10.0f, 10.0f, 10.0f);
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                poseStack.mulPose(Axis.XP.rotation(rotation));
            }
            if (entityIn.getRotationPoint() == 1) {
                poseStack.scale(2.0f, 2.0f, 2.0f);
                poseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                poseStack.mulPose(Axis.ZP.rotation(rotation));
            }
            switch (BuiltInRegistries.ITEM.getKey((Object)entityIn.getItem().getItem()).getPath()) {
                case "quiet_belladonna": 
                case "lofty_gerbera": 
                case "solemn_magnolia": 
                case "hallowed_lotus": {
                    poseStack.scale(0.1f, 0.1f, 0.1f);
                }
            }
        } else if (itemstack.getItem() instanceof LanceItem) {
            if (entityIn.getRotationPoint() == 0) {
                poseStack.mulPose(Axis.ZN.rotationDegrees(entityIn.xRotO + (entityIn.getXRot() - entityIn.xRotO) + 90.0f));
            }
            if (entityIn.getRotationPoint() == 1) {
                // empty if block
            }
            if (entityIn.getRotationPoint() == 2) {
                poseStack.mulPose(Axis.ZN.rotationDegrees(entityIn.xRotO + (entityIn.getXRot() - entityIn.xRotO) + 90.0f));
            }
        } else if (itemstack.getItem() instanceof CardItem) {
            poseStack.scale(3.0f, 3.0f, 3.0f);
        }
        this.itemRenderer.render(itemstack, itemstack.getItem() instanceof ChakramItem ? ItemDisplayContext.NONE : ItemDisplayContext.FIXED, false, poseStack, bufferIn, packedLightIn, OverlayTexture.NO_OVERLAY, model);
        poseStack.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    @Nullable
    public ResourceLocation getTextureLocation(KKThrowableEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

