/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class AbilityCommand
extends BaseCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ABILITIES = (p_198296_0_, p_198296_1_) -> {
        ArrayList<String> list = new ArrayList<String>();
        for (ResourceLocation actual : ModAbilities.registry.keySet()) {
            list.add(actual.toString());
        }
        return SharedSuggestionProvider.suggest(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"ability").requires(source -> source.hasPermission(2));
        builder.then(Commands.literal((String)"give").then(((RequiredArgumentBuilder)Commands.argument((String)"ability", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_ABILITIES).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(AbilityCommand::addAbility))).executes(AbilityCommand::addAbility)));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"take").then(((RequiredArgumentBuilder)Commands.argument((String)"ability", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_ABILITIES).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(AbilityCommand::removeAbility))).executes(AbilityCommand::removeAbility))).then(((LiteralArgumentBuilder)Commands.literal((String)"all").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(AbilityCommand::removeAllAbilities))).executes(AbilityCommand::removeAllAbilities)));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int addAbility(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = AbilityCommand.getPlayers(context, 4);
        String abilityName = StringArgumentType.getString(context, (String)"ability");
        Ability a = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)abilityName));
        if (a == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Ability '" + abilityName + "' does not exist")));
            return 0;
        }
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            playerData.addAbility(abilityName, true);
            if (player != ((CommandSourceStack)context.getSource()).getPlayerOrException()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Added '" + Utils.translateToLocal(a.getTranslationKey(), new Object[0]) + "' ability to " + player.getDisplayName().getString())), true);
            }
            player.sendSystemMessage((Component)Component.translatable((String)("You have been given the ability '" + Utils.translateToLocal(a.getTranslationKey(), new Object[0]) + "'")));
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        }
        return 1;
    }

    private static int removeAbility(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = AbilityCommand.getPlayers(context, 4);
        String ability = StringArgumentType.getString(context, (String)"ability");
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            playerData.removeAbility(ability);
            if (player != ((CommandSourceStack)context.getSource()).getPlayerOrException()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Removed ability '" + Utils.translateToLocal(ability, new Object[0]) + "' from " + player.getDisplayName().getString())), true);
            }
            Ability a = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)ability));
            player.sendSystemMessage((Component)Component.translatable((String)("Your ability '" + Utils.translateToLocal(a.getTranslationKey(), new Object[0]) + "' has been taken away")));
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        }
        return 1;
    }

    private static int removeAllAbilities(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = AbilityCommand.getPlayers(context, 4);
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            playerData.clearAbilities();
            if (player != ((CommandSourceStack)context.getSource()).getPlayerOrException()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Removed all abilities from " + player.getDisplayName().getString())), true);
            }
            player.sendSystemMessage((Component)Component.translatable((String)"Your abilities have been taken away"));
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        }
        return 1;
    }
}

