/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.data.CastleOblivionData;
import online.kingdomkeys.kingdomkeys.data.GlobalData;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncGlobalData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;

public class ConvertOldForgeDataCommand
extends BaseCommand {
    public static boolean run = false;

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"convert_old_forge_data").requires(source -> source.hasPermission(2))).executes(ConvertOldForgeDataCommand::convertData);
        KingdomKeys.LOGGER.info("Registered command {}", (Object)builder.getLiteral());
        return builder;
    }

    public static int convertData(CommandContext<CommandSourceStack> context) {
        CompoundTag data;
        CompoundTag main;
        DataInputStream inputStream;
        FileInputStream fis;
        if (!run) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"WARNING This command overwrites the KK world and player data with any existing KK world and player data from Forge, run this command again to confirm you want to overwrite it"));
            run = true;
            return 0;
        }
        AtomicBoolean converted = new AtomicBoolean();
        Path worldDataFolder = ((CommandSourceStack)context.getSource()).getServer().getWorldPath(new LevelResource("data"));
        File capabilities = new File(worldDataFolder.toFile(), "capabilities.dat");
        Path castleOblivionData = ((CommandSourceStack)context.getSource()).getServer().getWorldPath(new LevelResource("dimensions/kingdomkeys/castle_oblivion/data"));
        File coCaps = new File(castleOblivionData.toFile(), "capabilities.dat");
        if (capabilities.exists()) {
            try {
                fis = new FileInputStream(capabilities);
                try {
                    inputStream = new DataInputStream(new PushbackInputStream(fis, 2));
                    main = NbtIo.readCompressed((InputStream)inputStream, (NbtAccounter)NbtAccounter.unlimitedHeap());
                    data = main.getCompound("data");
                    if (data.contains("kingdomkeys:world_capabilities")) {
                        WorldData.load(data.getCompound("kingdomkeys:world_capabilities"), (HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess());
                        converted.set(true);
                        capabilities.delete();
                    }
                }
                finally {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (coCaps.exists()) {
            try {
                fis = new FileInputStream(coCaps);
                try {
                    inputStream = new DataInputStream(new PushbackInputStream(fis, 2));
                    main = NbtIo.readCompressed((InputStream)inputStream, (NbtAccounter)NbtAccounter.unlimitedHeap());
                    data = main.getCompound("data");
                    if (data.contains("kingdomkeys:castle_oblivion_exterior_capability")) {
                        CastleOblivionData.ExteriorData.load(data.getCompound("kingdomkeys:castle_oblivion_exterior_capability"), (HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess());
                        converted.set(true);
                        capabilities.delete();
                    }
                }
                finally {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        CastleOblivionData.ExteriorData.get(((CommandSourceStack)context.getSource()).getServer()).getInteriors().forEach((uuid, resourceLocation) -> {
            Path interiorData = ((CommandSourceStack)context.getSource()).getServer().getWorldPath(new LevelResource("dimensions/kingdomkeys/castle_oblivion_interior_" + uuid.toString() + "/data"));
            File interiorCap = new File(interiorData.toFile(), "capabilities.dat");
            if (interiorCap.exists()) {
                try (FileInputStream fis = new FileInputStream(coCaps);){
                    DataInputStream inputStream = new DataInputStream(new PushbackInputStream(fis, 2));
                    CompoundTag main = NbtIo.readCompressed((InputStream)inputStream, (NbtAccounter)NbtAccounter.unlimitedHeap());
                    CompoundTag data = main.getCompound("data");
                    if (data.contains("kingdomkeys:castle_oblivion_interior_capability")) {
                        CastleOblivionData.InteriorData.load(data.getCompound("kingdomkeys:castle_oblivion_interior_capability"), (HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess());
                        converted.set(true);
                        capabilities.delete();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        Path playerDataFolder = ((CommandSourceStack)context.getSource()).getServer().getWorldPath(new LevelResource("playerdata"));
        PlayerList playerList = ((CommandSourceStack)context.getSource()).getServer().getPlayerList();
        if (Files.isDirectory(playerDataFolder, new LinkOption[0])) {
            try (Stream<Path> files = Files.list(playerDataFolder);){
                files.forEach(path -> {
                    File playerDat = path.toFile();
                    ServerPlayer player = playerList.getPlayer(UUID.fromString(playerDat.getName().split("\\.")[0]));
                    try (FileInputStream fis = new FileInputStream(playerDat);){
                        DataInputStream inputStream = new DataInputStream(new PushbackInputStream(fis, 2));
                        CompoundTag main = NbtIo.readCompressed((InputStream)inputStream, (NbtAccounter)NbtAccounter.unlimitedHeap());
                        if (main.contains("ForgeCaps")) {
                            CompoundTag forgeCaps = main.getCompound("ForgeCaps");
                            if (forgeCaps.contains("kingdomkeys:player_capabilities")) {
                                CompoundTag playerCap = forgeCaps.getCompound("kingdomkeys:player_capabilities");
                                PlayerData.get((Player)player).deserializeNBT((HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess(), playerCap);
                                PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
                            }
                            if (forgeCaps.contains("kingdomkeys:global_capabilities")) {
                                CompoundTag globalCap = forgeCaps.getCompound("kingdomkeys:global_capabilities");
                                GlobalData.get((LivingEntity)player).deserializeNBT((HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess(), globalCap);
                                PacketHandler.sendTo(new SCSyncGlobalData((LivingEntity)player), player);
                            }
                            main.remove("ForgeCaps");
                            NbtIo.writeCompressed((CompoundTag)main, (Path)path);
                            converted.set(true);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!converted.get()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No old data was found to convert"));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Successfully converted data"), true);
        return 1;
    }
}

