/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.command.ExpCommand;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class DriveLevelCommand
extends BaseCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_DRIVE_FORMS = (p_198296_0_, p_198296_1_) -> {
        ArrayList<String> list = new ArrayList<String>();
        for (ResourceLocation location : ModDriveForms.registry.keySet()) {
            if (location.toString().equals("kingdomkeys:form_anti") || location.toString().equals(DriveForm.NONE.toString()) || location.toString().equals(DriveForm.SYNCH_BLADE.toString())) continue;
            list.add(location.toString());
        }
        return SharedSuggestionProvider.suggest(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"drivelevel").requires(source -> source.hasPermission(2));
        builder.then(Commands.literal((String)"set").then(Commands.argument((String)"form", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_DRIVE_FORMS).then(((RequiredArgumentBuilder)Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)7)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(DriveLevelCommand::setValue))).executes(DriveLevelCommand::setValue))));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int setValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = DriveLevelCommand.getPlayers(context, 5);
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        String form = StringArgumentType.getString(context, (String)"form");
        if (!ModDriveForms.registry.keySet().stream().map(ResourceLocation::toString).toList().contains(form)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Form '" + form + "' does not exist")));
            return 0;
        }
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            if (level == 0) {
                playerData.setDriveFormLevel(form, 0);
                PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
            } else {
                playerData.setDriveFormLevel(form, 1);
                playerData.setDriveFormExp((Player)player, form, 0);
                DriveForm drive = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)form));
                playerData.setNewKeychain(ResourceLocation.parse((String)form), ItemStack.EMPTY);
                playerData.getAbilityMap().remove(drive.getBaseAbilityForLevel(3));
                while (playerData.getDriveFormLevel(form) < level) {
                    int cost = drive.getLevelUpCost(playerData.getDriveFormLevel(form) + 1);
                    playerData.setDriveFormExp((Player)player, form, cost);
                }
            }
            ExpCommand.fix(playerData, (Player)player);
            DriveForm formInstance = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)form));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Set " + Utils.translateToLocal(formInstance.getTranslationKey(), new Object[0]) + " for " + player.getDisplayName().getString() + " to level " + level)), true);
            player.sendSystemMessage((Component)Component.translatable((String)("Your " + Utils.translateToLocal(formInstance.getTranslationKey(), new Object[0]) + " level is now " + level)));
        }
        return 1;
    }
}

